/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import org.jberet.job.Job;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.util.BatchLogger;

public final class JobExecutionRunner
extends CompositeExecutionRunner<JobContextImpl>
implements Runnable {
    private Job job;

    public JobExecutionRunner(JobContextImpl jobContext) {
        super(jobContext, null);
        this.job = jobContext.getJob();
    }

    @Override
    protected List<?> getJobElements() {
        return this.job.getDecisionOrFlowOrSplit();
    }

    @Override
    public void run() {
        if (((JobContextImpl)this.batchContext).getBatchStatus() != BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
        }
        try {
            for (JobListener l : ((JobContextImpl)this.batchContext).getJobListeners()) {
                try {
                    l.beforeJob();
                }
                catch (Throwable e) {
                    BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", l);
                    ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                    return;
                }
            }
            this.runFromHeadOrRestartPoint(((JobContextImpl)this.batchContext).getJobExecution().getRestartPoint());
            for (JobListener l : ((JobContextImpl)this.batchContext).getJobListeners()) {
                try {
                    l.afterJob();
                }
                catch (Throwable e) {
                    BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", l);
                    ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                    return;
                }
            }
        }
        catch (Throwable e) {
            BatchLogger.LOGGER.failToRunJob(e, this.job.getId(), "", this.job);
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
        }
        ((JobContextImpl)this.batchContext).destroyArtifact(((JobContextImpl)this.batchContext).getJobListeners());
        if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STARTED) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
        } else if (((JobContextImpl)this.batchContext).getBatchStatus() == BatchStatus.STOPPING) {
            ((JobContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
        }
        ((JobContextImpl)this.batchContext).saveInactiveStepExecutions();
        ((JobContextImpl)this.batchContext).getJobExecution().cleanUp();
    }
}

