/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import org.jberet.job.Flow;
import org.jberet.job.Split;
import org.jberet.runtime.FlowExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.SplitContextImpl;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.util.BatchLogger;

public final class SplitExecutionRunner
extends CompositeExecutionRunner<SplitContextImpl>
implements Runnable {
    private static final long SPLIT_FLOW_TIMEOUT_SECONDS = 300L;
    private Split split;

    public SplitExecutionRunner(SplitContextImpl splitContext, CompositeExecutionRunner enclosingRunner) {
        super(splitContext, enclosingRunner);
        this.split = splitContext.getSplit();
    }

    @Override
    protected List<?> getJobElements() {
        return this.split.getFlow();
    }

    @Override
    public void run() {
        String next;
        block8: {
            ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
            List<Flow> flows = this.split.getFlow();
            CountDownLatch latch = new CountDownLatch(flows.size());
            try {
                for (Flow f : flows) {
                    this.runFlow(f, latch);
                }
                latch.await(300L, TimeUnit.SECONDS);
                List<FlowExecutionImpl> fes = ((SplitContextImpl)this.batchContext).getFlowExecutions();
                for (int i = 0; i < fes.size(); ++i) {
                    if (!fes.get(i).getBatchStatus().equals((Object)BatchStatus.FAILED)) continue;
                    ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                    for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                        c.setBatchStatus(BatchStatus.FAILED);
                    }
                    break;
                }
                if (!((SplitContextImpl)this.batchContext).getBatchStatus().equals((Object)BatchStatus.STARTED)) break block8;
                ((SplitContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
            }
            catch (Throwable e) {
                BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.split.getId(), this.split);
                for (AbstractContext c : ((SplitContextImpl)this.batchContext).getOuterContexts()) {
                    c.setBatchStatus(BatchStatus.FAILED);
                }
            }
        }
        if (((SplitContextImpl)this.batchContext).getBatchStatus() == BatchStatus.COMPLETED && (next = this.split.getNext()) != null) {
            List<FlowExecutionImpl> fes = ((SplitContextImpl)this.batchContext).getFlowExecutions();
            StepExecution[] stepExecutions = new StepExecution[fes.size()];
            for (int i = 0; i < fes.size(); ++i) {
                stepExecutions[i] = fes.get(i).getLastStepExecution();
            }
            this.enclosingRunner.runJobElement(next, stepExecutions);
        }
    }
}

