/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import org.jberet.runtime.context.AbstractContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="jberet")
public interface BatchLogger
extends BasicLogger {
    public static final BatchLogger LOGGER = (BatchLogger)Logger.getMessageLogger(BatchLogger.class, (String)BatchLogger.class.getPackage().getName());

    @Message(id=1, value="Failed to create artifact with ref name %s")
    public IllegalStateException failToCreateArtifact(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Usage: java -classpath ... -Dkey1=val1 ... org.jberet.Main jobXML%nThe following application args are invalid:%n%s")
    public void mainUsage(List<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Failed to run batchlet %s")
    public void failToRunBatchlet(@Cause Throwable var1, Object var2);

    @Message(id=4, value="Failed to get job xml file for job %s")
    public JobStartException failToGetJobXml(@Cause Throwable var1, String var2);

    @Message(id=5, value="Failed to parse and bind XML for job %s")
    public JobStartException failToParseBindJobXml(@Cause Throwable var1, String var2);

    @Message(id=6, value="Failed to parse and bind batch XML %s")
    public JobStartException failToParseBindBatchXml(@Cause Throwable var1, String var2);

    @Message(id=7, value="Failed to process batch application metadata for job %s")
    public JobStartException failToProcessMetaData(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Failed to write batch artifact xml file")
    public void failToWriteBatchXml(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Failed to identify batch artifact")
    public void failToIdentifyArtifact(@Cause Throwable var1);

    @Message(id=10, value="A step cannot contain both chunk type and batchlet type: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void cannotContainBothChunkAndBatchlet(String var1);

    @Message(id=11, value="A concrete step must contain either a chunk or batchlet type: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void stepContainsNoChunkOrBatchlet(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Submitted batchlet task %s in thread %s")
    public void submittedBatchletTask(String var1, Thread var2);

    @Message(id=13, value="No method matches the annotation %s in artifact %s")
    public IllegalStateException noMethodMatchingAnnotation(Class<? extends Annotation> var1, Object var2);

    @Message(id=14, value="No job execution with id %s")
    public NoSuchJobExecutionException noSuchJobExecution(long var1);

    @Message(id=15, value="Unrecognized property category: %s, variable name: %s in property value: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void unrecognizedPropertyReference(String var1, String var2, String var3);

    @Message(id=16, value="Invalid exception filter class '%s'")
    @LogMessage(level=Logger.Level.WARN)
    public void invalidExceptionClassFilter(@Cause Throwable var1, String var2);

    @Message(id=17, value="The job: %s already exists in the job repository and cannot be added again.")
    @LogMessage(level=Logger.Level.WARN)
    public void jobAlreadyExists(String var1);

    @Message(id=18, value="Failed to run job %s, %s, %s")
    @LogMessage(level=Logger.Level.ERROR)
    public void failToRunJob(@Cause Throwable var1, String var2, String var3, Object var4);

    @Message(id=19, value="Unrecognizable job element: %s in job: %s")
    public IllegalStateException unrecognizableJobElement(String var1, String var2);

    @Message(id=20, value="Cycle detected in property reference: %s")
    public BatchRuntimeException cycleInPropertyReference(List<String> var1);

    @Message(id=21, value="Possible syntax errors in property: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void possibleSyntaxErrorInProperty(String var1);

    @Message(id=22, value="The step %s would form a loopback in sequence: %s")
    public IllegalStateException loopbackStep(String var1, String var2);

    @Message(id=23, value="The requested batch operation %s is not supported in %s")
    public IllegalStateException batchOperationNotSupported(String var1, AbstractContext var2);

    @Message(id=24, value="Cycles detected in job element inheritance: %s")
    public JobStartException cycleInheritance(String var1);

    @Message(id=25, value="Job execution %s is running and cannot be abandoned.")
    public JobExecutionIsRunningException jobExecutionIsRunningException(long var1);

    @Message(id=26, value="Job execution %s has already completed and cannot be restarted.")
    public JobExecutionAlreadyCompleteException jobExecutionAlreadyCompleteException(long var1);

    @Message(id=27, value="Failed to restart job execution %s, which had batch status %s.")
    public JobRestartException jobRestartException(long var1, BatchStatus var3);

    @Message(id=28, value="Job execution %s is not the most recent execution of job instance %s.")
    public JobExecutionNotMostRecentException jobExecutionNotMostRecentException(long var1, long var3);

    @Message(id=29, value="Job execution %s has batch status %s, and is not running.")
    public JobExecutionNotRunningException jobExecutionNotRunningException(long var1, BatchStatus var3);

    @Message(id=30, value="A decision cannot be the first element: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void decisionCannotBeFirst(String var1);

    @Message(id=31, value="Could not resolve expression because: %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void unresolvableExpression(String var1);

    @Message(id=32, value="Could not resolve the expression: %s")
    public BatchRuntimeException unresolvableExpressionException(String var1);

    @Message(id=33, value="The step %s has started %s times and reached its start limit %s")
    public BatchRuntimeException stepReachedStartLimit(String var1, int var2, int var3);

    @Message(id=34, value="Invalid chunk checkpoint-policy %s.  It must be either item or custom.")
    public BatchRuntimeException invalidCheckpointPolicy(String var1);

    @Message(id=35, value="Invalid chunk item-count %s.  It must be greater than 0.")
    public BatchRuntimeException invalidItemCount(int var1);

    @Message(id=36, value="checkpoint-algorithm element is missing in step %s.  It is required for custom checkpoint-policy.")
    public BatchRuntimeException checkpointAlgorithmMissing(String var1);

    @Message(id=37, value="The specified job with the name %s does not exist.")
    public NoSuchJobException noSuchJobException(String var1);

    @Message(id=38, value="Failed to stop the job %s, %s, %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToStopJob(@Cause Throwable var1, String var2, String var3, Object var4);

    @Message(id=39, value="Failed to clone %s when running job [%s] and step [%s]")
    @LogMessage(level=Logger.Level.WARN)
    public void failToClone(@Cause Throwable var1, Object var2, String var3, String var4);

    @Message(id=40, value="Failed to inject value %s into field %s, because the field type %s is not supported for property injection.")
    public BatchRuntimeException unsupportedFieldType(String var1, Field var2, Class<?> var3);

    @Message(id=41, value="Failed to inject value %s into field %s")
    public BatchRuntimeException failToInjectProperty(@Cause Throwable var1, String var2, Field var3);

    @Message(id=42, value="Failed to destroy artifact %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToDestroyArtifact(@Cause Throwable var1, Object var2);

    @Message(id=43, value="The configuration file %s is not found in the classpath, and will use the default configuration.")
    @LogMessage(level=Logger.Level.INFO)
    public void useDefaultJBeretConfig(String var1);

    @Message(id=44, value="Failed to load configuration file %s")
    public BatchRuntimeException failToLoadConfig(@Cause Throwable var1, String var2);

    @Message(id=45, value="Unrecognized job repository type %s")
    public BatchRuntimeException unrecognizedJobRepositoryType(String var1);

    @Message(id=46, value="Failed to look up datasource %s")
    public BatchRuntimeException failToLookupDataSource(@Cause Throwable var1, String var2);

    @Message(id=47, value="Failed to obtain connection from %s, %s")
    public BatchRuntimeException failToObtainConnection(@Cause Throwable var1, Object var2, Object var3);

    @Message(id=48, value="Failed to load sql properties %s")
    public BatchRuntimeException failToLoadSqlProperties(@Cause Throwable var1, String var2);

    @Message(id=49, value="Tables created for batch job repository with DDL file %s")
    @LogMessage(level=Logger.Level.INFO)
    public void tableCreated(String var1);

    @Message(id=50, value="Tables created for batch job repository with DDL content:%n %s")
    @LogMessage(level=Logger.Level.INFO)
    public void tableCreated2(String var1);

    @Message(id=51, value="Failed to create tables for batch job repository with DDL %s%n%s")
    public BatchRuntimeException failToCreateTables(@Cause Throwable var1, String var2, String var3);

    @Message(id=52, value="Failed to load ddl file %s")
    public BatchRuntimeException failToLoadDDL(String var1);

    @Message(id=53, value="Failed to insert %s")
    public BatchRuntimeException failToInsert(@Cause Throwable var1, String var2);

    @Message(id=54, value="Failed to close %s: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToClose(@Cause Throwable var1, Class<?> var2, Object var3);

    @Message(id=55, value="Persisted %s with id %s")
    @LogMessage(level=Logger.Level.INFO)
    public void persisted(Object var1, long var2);
}

