/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.batch.operations.JobStartException;
import org.jberet.job.Flow;
import org.jberet.job.Job;
import org.jberet.job.Listener;
import org.jberet.job.Listeners;
import org.jberet.job.Property;
import org.jberet.job.Step;
import org.jberet.util.BatchThreadFactory;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectClonerFactory;
import org.jboss.marshalling.cloner.ObjectCloners;

public class BatchUtil {
    public static final String NL = System.getProperty("line.separator");
    private static ExecutorService executorService = Executors.newCachedThreadPool(new BatchThreadFactory());
    private static final ObjectClonerFactory clonerFactory = ObjectCloners.getSerializingObjectClonerFactory();
    private static final ObjectCloner cloner = clonerFactory.createCloner(new ClonerConfiguration());

    public static ClassLoader getBatchApplicationClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BatchUtil.class.getClassLoader();
        }
        return cl;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static Properties getPropertiesFromJobDefinition(Job job) {
        return BatchUtil.toJavaUtilProperties(job.getProperties());
    }

    public static Properties getPropertiesFromStepDefinition(Step step) {
        return BatchUtil.toJavaUtilProperties(step.getProperties());
    }

    public static String propertiesToString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : properties.stringPropertyNames()) {
            sb.append(key).append('=').append(properties.getProperty(key)).append(NL);
        }
        return sb.toString();
    }

    public static Properties toJavaUtilProperties(org.jberet.job.Properties props) {
        Properties result = new Properties();
        if (props != null) {
            for (Property p : props.getProperty()) {
                String v = p.getValue();
                if (v == null) continue;
                result.setProperty(p.getName(), v);
            }
        }
        return result;
    }

    public static String getBatchProperty(org.jberet.job.Properties batchProps, String key) {
        if (batchProps != null) {
            for (Property p : batchProps.getProperty()) {
                if (!p.getName().equals(key)) continue;
                return p.getValue();
            }
        }
        return null;
    }

    public static boolean propertiesContains(org.jberet.job.Properties props, String key) {
        if (props == null) {
            return false;
        }
        for (Property p : props.getProperty()) {
            if (!p.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean listenersContains(Listeners listeners, Listener listener) {
        if (listeners == null) {
            return false;
        }
        for (Listener l : listeners.getListener()) {
            if (l != listener) continue;
            return true;
        }
        return false;
    }

    public static StringBuilder toElementSequence(List<?> elements) {
        StringBuilder sb = new StringBuilder();
        for (Object e : elements) {
            if (e instanceof Step) {
                sb.append(((Step)e).getId());
            } else if (e instanceof Job) {
                sb.append(((Job)e).getId());
            } else if (e instanceof Flow) {
                sb.append(((Flow)e).getId());
            }
            sb.append(" -> ");
        }
        return sb;
    }

    public static <T> T clone(T original) throws JobStartException {
        try {
            cloner.reset();
            return (T)cloner.clone(original);
        }
        catch (IOException e) {
            throw new JobStartException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new JobStartException((Throwable)e);
        }
    }
}

