/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.batch.operations.BatchRuntimeException;
import org.jberet.job.Analyzer;
import org.jberet.job.Batchlet;
import org.jberet.job.CheckpointAlgorithm;
import org.jberet.job.Chunk;
import org.jberet.job.Collector;
import org.jberet.job.Decision;
import org.jberet.job.End;
import org.jberet.job.ExceptionClassFilter;
import org.jberet.job.Fail;
import org.jberet.job.Flow;
import org.jberet.job.ItemProcessor;
import org.jberet.job.ItemReader;
import org.jberet.job.ItemWriter;
import org.jberet.job.Job;
import org.jberet.job.Listener;
import org.jberet.job.Listeners;
import org.jberet.job.Next;
import org.jberet.job.Partition;
import org.jberet.job.PartitionMapper;
import org.jberet.job.PartitionPlan;
import org.jberet.job.PartitionReducer;
import org.jberet.job.Property;
import org.jberet.job.Split;
import org.jberet.job.Step;
import org.jberet.job.Stop;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public final class PropertyResolver {
    protected static final String jobParametersToken = "jobParameters";
    protected static final String jobPropertiesToken = "jobProperties";
    protected static final String systemPropertiesToken = "systemProperties";
    protected static final String partitionPlanToken = "partitionPlan";
    private static final String prefix = "#{";
    private static final String defaultValuePrefix = "?:";
    private static final int shortestTemplateLen = "#{jobProperties['x']}".length();
    private static final int prefixLen = "#{".length();
    private Properties systemProperties = System.getProperties();
    private Properties jobParameters;
    private Properties partitionPlanProperties;
    private Deque<org.jberet.job.Properties> jobPropertiesStack = new ArrayDeque<org.jberet.job.Properties>();
    private boolean resolvePartitionPlanProperties;

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void setJobParameters(Properties jobParameters) {
        this.jobParameters = jobParameters;
    }

    public void setPartitionPlanProperties(Properties partitionPlanProperties) {
        this.partitionPlanProperties = partitionPlanProperties;
    }

    public void pushJobProperties(org.jberet.job.Properties jobProps) {
        this.jobPropertiesStack.push(jobProps);
    }

    public void setResolvePartitionPlanProperties(boolean resolvePartitionPlanProperties) {
        this.resolvePartitionPlanProperties = resolvePartitionPlanProperties;
    }

    public void resolve(Job job) {
        String newVal;
        String oldVal = job.getRestartable();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            job.setRestartable(newVal);
        }
        org.jberet.job.Properties props = job.getProperties();
        this.resolve(props, false);
        this.resolve(job.getListeners());
        this.resolveJobElements(job.getDecisionOrFlowOrSplit());
        if (props != null) {
            this.jobPropertiesStack.pop();
        }
    }

    private void resolveJobElements(List<?> jobElements) {
        if (jobElements == null) {
            return;
        }
        for (Object e : jobElements) {
            if (e instanceof Step) {
                this.resolve((Step)e);
                continue;
            }
            if (e instanceof Flow) {
                this.resolve((Flow)e);
                continue;
            }
            if (e instanceof Decision) {
                this.resolve((Decision)e);
                continue;
            }
            if (!(e instanceof Split)) continue;
            this.resolve((Split)e);
        }
    }

    public void resolve(Step step) {
        String newVal;
        this.resolve(step.getPartition());
        String oldVal = step.getNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setNext(newVal);
        }
        if ((oldVal = step.getAllowStartIfComplete()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setAllowStartIfComplete(newVal);
        }
        if ((oldVal = step.getStartLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            step.setStartLimit(newVal);
        }
        org.jberet.job.Properties props = step.getProperties();
        this.resolve(props, false);
        this.resolve(step.getListeners());
        Batchlet batchlet = step.getBatchlet();
        if (batchlet != null) {
            oldVal = batchlet.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                batchlet.setRef(newVal);
            }
            this.resolve(batchlet.getProperties(), true);
        }
        this.resolve(step.getChunk());
        this.resolveTransitionElements(step.getTransitionElements());
        if (props != null) {
            this.jobPropertiesStack.pop();
        }
    }

    private void resolve(Partition partition) {
        PartitionMapper mapper;
        PartitionPlan plan;
        PartitionReducer reducer;
        Collector collector;
        String newVal;
        String oldVal;
        if (partition == null) {
            return;
        }
        Analyzer analyzer = partition.getAnalyzer();
        if (analyzer != null) {
            oldVal = analyzer.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                analyzer.setRef(newVal);
            }
            this.resolve(analyzer.getProperties(), true);
        }
        if ((collector = partition.getCollector()) != null) {
            oldVal = collector.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                collector.setRef(newVal);
            }
            this.resolve(collector.getProperties(), true);
        }
        if ((reducer = partition.getReducer()) != null) {
            oldVal = reducer.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                reducer.setRef(newVal);
            }
            this.resolve(reducer.getProperties(), true);
        }
        if ((plan = partition.getPlan()) != null) {
            oldVal = plan.getPartitions();
            if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                plan.setPartitions(newVal);
            }
            if ((oldVal = plan.getThreads()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                plan.setThreads(newVal);
            }
            if (!this.resolvePartitionPlanProperties) {
                for (org.jberet.job.Properties p : plan.getProperties()) {
                    this.resolve(p, true);
                }
            }
        }
        if ((mapper = partition.getMapper()) != null) {
            oldVal = mapper.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                mapper.setRef(newVal);
            }
            if (!this.resolvePartitionPlanProperties) {
                this.resolve(mapper.getProperties(), true);
            }
        }
    }

    private void resolve(Chunk chunk) {
        CheckpointAlgorithm checkpointAlgorithm;
        ItemReader reader;
        String newVal;
        if (chunk == null) {
            return;
        }
        this.resolve(chunk.getSkippableExceptionClasses());
        this.resolve(chunk.getRetryableExceptionClasses());
        this.resolve(chunk.getNoRollbackExceptionClasses());
        String oldVal = chunk.getCheckpointPolicy();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setCheckpointPolicy(newVal);
        }
        if ((oldVal = chunk.getItemCount()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setItemCount(newVal);
        }
        if ((oldVal = chunk.getTimeLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setTimeLimit(newVal);
        }
        if ((oldVal = chunk.getSkipLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setSkipLimit(newVal);
        }
        if ((oldVal = chunk.getRetryLimit()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            chunk.setRetryLimit(newVal);
        }
        if (!(oldVal = (reader = chunk.getReader()).getRef()).equals(newVal = this.resolve(oldVal))) {
            reader.setRef(newVal);
        }
        this.resolve(reader.getProperties(), true);
        ItemWriter writer = chunk.getWriter();
        oldVal = writer.getRef();
        newVal = this.resolve(oldVal);
        if (!oldVal.equals(newVal)) {
            writer.setRef(newVal);
        }
        this.resolve(writer.getProperties(), true);
        ItemProcessor processor = chunk.getProcessor();
        if (processor != null) {
            oldVal = processor.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                processor.setRef(newVal);
            }
            this.resolve(processor.getProperties(), true);
        }
        if ((checkpointAlgorithm = chunk.getCheckpointAlgorithm()) != null) {
            oldVal = checkpointAlgorithm.getRef();
            if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                checkpointAlgorithm.setRef(newVal);
            }
            this.resolve(checkpointAlgorithm.getProperties(), true);
        }
    }

    private void resolve(ExceptionClassFilter filter) {
        List<ExceptionClassFilter.Exclude> ex;
        String newVal;
        String oldVal;
        if (filter == null) {
            return;
        }
        List<ExceptionClassFilter.Include> in = filter.getInclude();
        if (in != null) {
            for (ExceptionClassFilter.Include i : in) {
                oldVal = i.getClazz();
                if (oldVal.equals(newVal = this.resolve(oldVal))) continue;
                i.setClazz(newVal);
            }
        }
        if ((ex = filter.getExclude()) != null) {
            for (ExceptionClassFilter.Exclude e : ex) {
                oldVal = e.getClazz();
                if (oldVal.equals(newVal = this.resolve(oldVal))) continue;
                e.setClazz(newVal);
            }
        }
    }

    private void resolve(Split split) {
        String newVal;
        String oldVal = split.getNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            split.setNext(newVal);
        }
        for (Flow e : split.getFlow()) {
            this.resolve(e);
        }
    }

    public void resolve(Flow flow) {
        String newVal;
        String oldVal = flow.getNext();
        if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
            flow.setNext(newVal);
        }
        this.resolveTransitionElements(flow.getTransitionElements());
        this.resolveJobElements(flow.getDecisionOrFlowOrSplit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(org.jberet.job.Properties props, boolean popProps) {
        if (props == null) {
            return;
        }
        org.jberet.job.Properties propsToPush = new org.jberet.job.Properties();
        this.jobPropertiesStack.push(propsToPush);
        try {
            String newVal;
            String oldVal = props.getPartition();
            if (oldVal != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                props.setPartition(newVal);
            }
            for (Property p : props.getProperty()) {
                oldVal = p.getName();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    p.setName(newVal);
                }
                propsToPush.getProperty().add(p);
                oldVal = p.getValue();
                if (oldVal != null) {
                    newVal = this.resolve(oldVal);
                    if (oldVal.equals(newVal)) continue;
                    p.setValue(newVal);
                    continue;
                }
                p.setValue("");
            }
        }
        finally {
            if (popProps) {
                this.jobPropertiesStack.pop();
            }
        }
    }

    private void resolve(Listeners listeners) {
        if (listeners == null) {
            return;
        }
        for (Listener l : listeners.getListener()) {
            String newVal;
            String oldVal = l.getRef();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                l.setRef(newVal);
            }
            this.resolve(l.getProperties(), true);
        }
    }

    private void resolve(Decision decision) {
        String newVal;
        String oldVal = decision.getRef();
        if (!oldVal.equals(newVal = this.resolve(oldVal))) {
            decision.setRef(newVal);
        }
        this.resolve(decision.getProperties(), true);
        this.resolveTransitionElements(decision.getTransitionElements());
    }

    private void resolveTransitionElements(List<?> transitions) {
        for (Object e : transitions) {
            String newVal;
            String oldVal;
            if (e instanceof Next) {
                Next next = (Next)e;
                oldVal = next.getTo();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    next.setTo(newVal);
                }
                if ((oldVal = next.getOn()).equals(newVal = this.resolve(oldVal))) continue;
                next.setOn(newVal);
                continue;
            }
            if (e instanceof Fail) {
                Fail fail = (Fail)e;
                oldVal = fail.getOn();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    fail.setOn(newVal);
                }
                if ((oldVal = fail.getExitStatus()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
                fail.setExitStatus(newVal);
                continue;
            }
            if (e instanceof End) {
                End end = (End)e;
                oldVal = end.getOn();
                if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                    end.setOn(newVal);
                }
                if ((oldVal = end.getExitStatus()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
                end.setExitStatus(newVal);
                continue;
            }
            if (!(e instanceof Stop)) continue;
            Stop stop = (Stop)e;
            oldVal = stop.getOn();
            if (!oldVal.equals(newVal = this.resolve(oldVal))) {
                stop.setOn(newVal);
            }
            if ((oldVal = stop.getExitStatus()) != null && !oldVal.equals(newVal = this.resolve(oldVal))) {
                stop.setExitStatus(newVal);
            }
            if ((oldVal = stop.getRestart()) == null || oldVal.equals(newVal = this.resolve(oldVal))) continue;
            stop.setRestart(newVal);
        }
    }

    public String resolve(String rawVale) {
        if (rawVale.length() < shortestTemplateLen || !rawVale.contains(prefix)) {
            return rawVale;
        }
        StringBuilder sb = new StringBuilder(rawVale);
        try {
            this.resolve(sb, 0, true, null);
        }
        catch (BatchRuntimeException e) {
            BatchLogger.LOGGER.unresolvableExpression(e.getMessage());
            return null;
        }
        return sb.toString();
    }

    private void resolve(StringBuilder sb, int start, boolean defaultAllowed, LinkedList<String> referringExpressions) throws BatchRuntimeException {
        if (sb.length() - start < shortestTemplateLen) {
            return;
        }
        int startExpression = sb.indexOf(prefix, start);
        if (startExpression < 0) {
            return;
        }
        int startPropCategory = startExpression + prefixLen;
        int openBracket = sb.indexOf("[", startPropCategory);
        String propCategory = sb.substring(startPropCategory, openBracket);
        int startVariableName = openBracket + 2;
        int endBracket = sb.indexOf("]", startVariableName + 1);
        int endExpression = endBracket + 1;
        if (endExpression >= sb.length()) {
            BatchLogger.LOGGER.possibleSyntaxErrorInProperty(sb.toString());
            endExpression = sb.length() - 1;
        }
        int endCurrentPass = endExpression;
        String expression = sb.substring(startExpression, endExpression + 1);
        if (referringExpressions != null && referringExpressions.contains(expression)) {
            throw BatchLogger.LOGGER.cycleInPropertyReference(referringExpressions);
        }
        if (!this.resolvePartitionPlanProperties && propCategory.equals(partitionPlanToken)) {
            this.resolve(sb, endCurrentPass + 1, true, null);
            return;
        }
        String variableName = sb.substring(startVariableName, endBracket - 1);
        String val = this.getPropertyValue(variableName, propCategory, sb);
        if (val != null) {
            val = this.reresolve(expression, val, defaultAllowed, referringExpressions);
        }
        if (!defaultAllowed) {
            if (val == null) {
                val = "";
            }
            endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endExpression, val);
        } else {
            int startDefaultMarker = endExpression + 1;
            int endDefaultMarker = startDefaultMarker + 1;
            String next2Chars = null;
            if (endDefaultMarker < sb.length()) {
                next2Chars = sb.substring(startDefaultMarker, endDefaultMarker + 1);
            }
            boolean hasDefault = defaultValuePrefix.equals(next2Chars);
            int endDefaultExpressionMarker = sb.indexOf(";", endDefaultMarker + 1);
            if (endDefaultExpressionMarker < 0) {
                endDefaultExpressionMarker = sb.length();
            }
            if (val != null) {
                endCurrentPass = !hasDefault ? this.replaceAndGetEndPosition(sb, startExpression, endExpression, val) : this.replaceAndGetEndPosition(sb, startExpression, endDefaultExpressionMarker, val);
            } else if (!hasDefault) {
                endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endExpression, "");
            } else {
                StringBuilder sb4DefaultExpression = new StringBuilder(sb.substring(endDefaultMarker + 1, endDefaultExpressionMarker));
                this.resolve(sb4DefaultExpression, 0, false, null);
                endCurrentPass = this.replaceAndGetEndPosition(sb, startExpression, endDefaultExpressionMarker, sb4DefaultExpression.toString());
            }
        }
        this.resolve(sb, endCurrentPass + 1, true, null);
    }

    private String reresolve(String expression, String currentlyResolvedToVal, boolean defaultAllowed, LinkedList<String> referringExpressions) throws BatchRuntimeException {
        if (currentlyResolvedToVal.length() < shortestTemplateLen || !currentlyResolvedToVal.contains(prefix)) {
            return currentlyResolvedToVal;
        }
        if (referringExpressions == null) {
            referringExpressions = new LinkedList();
        }
        referringExpressions.add(expression);
        StringBuilder sb = new StringBuilder(currentlyResolvedToVal);
        try {
            this.resolve(sb, 0, defaultAllowed, referringExpressions);
        }
        catch (BatchRuntimeException e) {
            BatchLogger.LOGGER.unresolvableExpression(e.getMessage());
            return null;
        }
        return sb.toString();
    }

    private int replaceAndGetEndPosition(StringBuilder sb, int startExpression, int endExpression, String replacingVal) {
        sb.replace(startExpression, endExpression + 1, replacingVal);
        return startExpression - 1 + replacingVal.length();
    }

    private String getPropertyValue(String variableName, String propCategory, StringBuilder sb) {
        String val = null;
        if (propCategory.equals(jobParametersToken)) {
            if (this.jobParameters != null) {
                val = this.jobParameters.getProperty(variableName);
            }
        } else if (propCategory.equals(jobPropertiesToken)) {
            org.jberet.job.Properties p;
            Iterator<org.jberet.job.Properties> i$ = this.jobPropertiesStack.iterator();
            while (i$.hasNext() && (val = BatchUtil.getBatchProperty(p = i$.next(), variableName)) == null) {
            }
        } else if (propCategory.equals(systemPropertiesToken)) {
            val = this.systemProperties.getProperty(variableName);
        } else if (propCategory.equals(partitionPlanToken)) {
            if (this.partitionPlanProperties != null) {
                val = this.partitionPlanProperties.getProperty(variableName);
            }
        } else {
            BatchLogger.LOGGER.unrecognizedPropertyReference(propCategory, variableName, sb.toString());
        }
        return val;
    }
}

