/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.camel;

import _private.JBeretCamelLogger;
import java.io.Serializable;
import java.util.List;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.apache.camel.ProducerTemplate;
import org.jberet.camel.CamelArtifactBase;

@Named
@Dependent
public class CamelItemWriter
extends CamelArtifactBase
implements ItemWriter {
    protected ProducerTemplate producerTemplate;

    public void open(Serializable checkpoint) throws Exception {
        this.init();
        if (this.producerTemplate == null) {
            this.producerTemplate = this.camelContext.createProducerTemplate();
        }
        JBeretCamelLogger.LOGGER.openWriter(this, this.endpointUri, this.camelContext, this.producerTemplate);
        this.producerTemplate.start();
    }

    public void close() throws Exception {
        if (this.producerTemplate != null) {
            this.producerTemplate.stop();
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object e : items) {
            this.producerTemplate.sendBody(this.endpoint, e);
        }
    }

    public Serializable checkpointInfo() {
        return null;
    }
}

