/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import javax.annotation.PostConstruct;
import org.jberet.creation.AbstractArtifactFactory;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.spi.ArtifactFactory;
import org.jberet.util.BatchLogger;

public final class ArtifactFactoryWrapper
extends AbstractArtifactFactory {
    private final ArtifactFactory factory;

    public ArtifactFactoryWrapper(ArtifactFactory factory) {
        this.factory = factory;
    }

    @Override
    public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
        Class<?> cls = this.factory.getArtifactClass(ref, classLoader);
        if (cls == null) {
            cls = this.getClassFromBatchXmlOrClassLoader(ref, classLoader);
        }
        return cls;
    }

    @Override
    public Object create(String ref, Class<?> cls, ClassLoader classLoader) throws Exception {
        Class<?> c;
        Object obj = this.factory.create(ref, cls, classLoader);
        if (obj == null && (c = this.getClassFromBatchXmlOrClassLoader(ref, classLoader)) != null) {
            obj = c.newInstance();
            ArtifactCreationContext acc = ArtifactCreationContext.getCurrentArtifactCreationContext();
            this.doInjection(obj, c, classLoader, acc.jobContext, acc.stepContext, acc.properties);
            this.invokeAnnotatedLifecycleMethod(obj, cls, PostConstruct.class);
        }
        return obj;
    }

    private Class<?> getClassFromBatchXmlOrClassLoader(String ref, ClassLoader classLoader) {
        Class<?> cls = null;
        BatchArtifacts batchArtifacts = ArtifactCreationContext.getCurrentArtifactCreationContext().jobContext.getBatchArtifacts();
        String className = null;
        if (batchArtifacts != null) {
            className = batchArtifacts.getClassNameForRef(ref);
        }
        if (className == null) {
            className = ref;
        }
        try {
            cls = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            BatchLogger.LOGGER.failToCreateArtifact(e, ref);
        }
        return cls;
    }
}

