/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;

public final class Job
implements Serializable {
    private static final long serialVersionUID = -3566969844084046522L;
    private final String id;
    private String restartable;
    private Properties properties;
    private final List<RefArtifact> listeners = new ArrayList<RefArtifact>();
    private final List<JobElement> jobElements = new ArrayList<JobElement>();

    Job(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getRestartable() {
        return this.restartable;
    }

    public boolean getRestartableBoolean() {
        return Boolean.parseBoolean(this.restartable);
    }

    void setRestartable(String restartable) {
        if (restartable != null) {
            this.restartable = restartable;
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<RefArtifact> getListeners() {
        return this.listeners;
    }

    void addListeners(List<RefArtifact> ls) {
        this.listeners.addAll(ls);
    }

    public List<JobElement> getJobElements() {
        return this.jobElements;
    }

    void addJobElement(JobElement jobElement) {
        this.jobElements.add(jobElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return this.id.equals(job.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

