/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.runner;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.api.listener.StepListener;
import javax.batch.api.partition.PartitionAnalyzer;
import javax.batch.api.partition.PartitionMapper;
import javax.batch.api.partition.PartitionReducer;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;
import javax.transaction.UserTransaction;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.PropertyResolver;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Step;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.runtime.runner.AbstractRunner;
import org.jberet.runtime.runner.BatchletRunner;
import org.jberet.runtime.runner.ChunkRunner;
import org.jberet.runtime.runner.CompositeExecutionRunner;
import org.jberet.util.BatchLogger;
import org.jberet.util.BatchUtil;

public final class StepExecutionRunner
extends AbstractRunner<StepContextImpl>
implements Runnable {
    Step step;
    private final List<StepListener> stepListeners = new ArrayList<StepListener>();
    Map<String, Class<?>> chunkRelatedListeners;
    PartitionMapper mapper;
    PartitionPlan plan;
    PartitionReducer reducer;
    PartitionAnalyzer analyzer;
    RefArtifact collectorConfig;
    int numOfPartitions;
    int numOfThreads;
    Properties[] partitionProperties;
    boolean isPartitioned;
    BlockingQueue<Serializable> collectorDataQueue;
    BlockingQueue<Boolean> completedPartitionThreads;
    UserTransaction ut;
    private final StepExecutionImpl stepExecution;

    public StepExecutionRunner(StepContextImpl stepContext, CompositeExecutionRunner enclosingRunner) {
        super(stepContext, enclosingRunner);
        this.step = stepContext.getStep();
        this.stepExecution = stepContext.getStepExecution();
        this.ut = this.jobContext.getBatchEnvironment().getUserTransaction();
        this.createStepListeners();
        this.initPartitionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block24: {
            block25: {
                handle = this.jobContext.getBatchEnvironment().getThreadContextSetup().setup();
                try {
                    allowStartIfComplete = ((StepContextImpl)this.batchContext).getAllowStartIfComplete();
                    if (allowStartIfComplete == Boolean.FALSE) break block24;
                    try {
                        executedSteps = this.jobContext.getExecutedSteps();
                        if (executedSteps.contains(this.step)) {
                            stepIds = BatchUtil.toElementSequence(executedSteps);
                            stepIds.append(this.step.getId());
                            throw BatchLogger.LOGGER.loopbackStep(this.step.getId(), stepIds.toString());
                        }
                        startLimit = this.step.getStartLimitInt();
                        if (startLimit > 0 && (startCount = this.stepExecution.getStartCount()) >= startLimit) {
                            throw BatchLogger.LOGGER.stepReachedStartLimit(this.step.getId(), startLimit, startCount);
                        }
                        this.stepExecution.incrementStartCount();
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STARTED);
                        this.jobContext.getJobRepository().addStepExecution(this.jobContext.getJobExecution(), this.stepExecution);
                        chunk = this.step.getChunk();
                        batchlet = this.step.getBatchlet();
                        if (chunk == null && batchlet == null) {
                            ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.ABANDONED);
                            BatchLogger.LOGGER.stepContainsNoChunkOrBatchlet(this.id);
                            handle.tearDown();
                            return;
                        }
                    }
                    catch (Throwable e) {
                        BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), this.step);
                        if (e instanceof Exception) {
                            ((StepContextImpl)this.batchContext).setException((Exception)e);
                        } else {
                            ((StepContextImpl)this.batchContext).setException((Exception)new BatchRuntimeException(e));
                        }
                        ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                        break block25;
                    }
                }
                catch (Throwable var10_16) {
                    handle.tearDown();
                    throw var10_16;
                }
                {
                    if (chunk == null || batchlet == null) ** GOTO lbl-1000
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.ABANDONED);
                    BatchLogger.LOGGER.cannotContainBothChunkAndBatchlet(this.id);
                    handle.tearDown();
                    return;
                }
lbl-1000:
                // 2 sources

                {
                    for (StepListener l : this.stepListeners) {
                        l.beforeStep();
                    }
                    this.runBatchletOrChunk(batchlet, chunk);
                    executedSteps.add(this.step);
                    for (StepListener l : this.stepListeners) {
                        try {
                            l.afterStep();
                        }
                        catch (Throwable e) {
                            BatchLogger.LOGGER.failToRunJob(e, this.jobContext.getJobName(), this.step.getId(), l);
                            ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.FAILED);
                            handle.tearDown();
                            return;
                        }
                    }
                }
                {
                    ((StepContextImpl)this.batchContext).savePersistentData();
                }
            }
            this.jobContext.destroyArtifact(new Object[]{this.mapper, this.reducer, this.analyzer});
            this.jobContext.destroyArtifact(this.stepListeners);
            stepStatus = ((StepContextImpl)this.batchContext).getBatchStatus();
            switch (1.$SwitchMap$javax$batch$runtime$BatchStatus[stepStatus.ordinal()]) {
                case 1: {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.COMPLETED);
                    break;
                }
                case 2: {
                    for (AbstractContext e : ((StepContextImpl)this.batchContext).getOuterContexts()) {
                        e.setBatchStatus(BatchStatus.FAILED);
                    }
                    break;
                }
                case 3: {
                    ((StepContextImpl)this.batchContext).setBatchStatus(BatchStatus.STOPPED);
                    break;
                }
            }
        }
        if (((StepContextImpl)this.batchContext).getBatchStatus() == BatchStatus.COMPLETED) {
            next = this.resolveTransitionElements(this.step.getTransitionElements(), this.step.getAttributeNext(), false);
            this.enclosingRunner.runJobElement(next, new StepExecution[]{this.stepExecution});
        }
        handle.tearDown();
    }

    private void runBatchletOrChunk(RefArtifact batchlet, Chunk chunk) throws Exception {
        if (this.isPartitioned) {
            this.beginPartition();
        } else if (chunk != null) {
            ChunkRunner chunkRunner = new ChunkRunner((StepContextImpl)this.batchContext, this.enclosingRunner, this, chunk);
            chunkRunner.run();
        } else {
            BatchletRunner batchletRunner = new BatchletRunner((StepContextImpl)this.batchContext, this.enclosingRunner, this, batchlet);
            batchletRunner.run();
        }
    }

    private void beginPartition() throws Exception {
        BatchStatus consolidatedBatchStatus;
        block30: {
            if (this.reducer != null) {
                this.reducer.beginPartitionedStep();
            }
            boolean isRestart = this.jobContext.isRestart();
            boolean isOverride = false;
            if (this.mapper != null) {
                javax.batch.api.partition.PartitionPlan partitionPlan = this.mapper.mapPartitions();
                isOverride = partitionPlan.getPartitionsOverride();
                this.numOfPartitions = partitionPlan.getPartitions();
                this.numOfThreads = partitionPlan.getThreads();
                this.partitionProperties = partitionPlan.getPartitionProperties();
            } else {
                this.numOfPartitions = this.plan.getPartitionsInt();
                this.numOfThreads = this.plan.getThreadsInt();
                List<org.jberet.job.model.Properties> propertiesList = this.plan.getPropertiesList();
                this.partitionProperties = new Properties[propertiesList.size()];
                for (org.jberet.job.model.Properties props : propertiesList) {
                    int idx = props.getPartition() == null ? 0 : Integer.parseInt(props.getPartition());
                    this.partitionProperties[idx] = org.jberet.job.model.Properties.toJavaUtilProperties(props);
                }
            }
            if (isRestart && !isOverride) {
                this.numOfPartitions = ((StepContextImpl)this.batchContext).getStepExecution().getNumOfPartitions();
            }
            if (this.numOfPartitions > this.numOfThreads) {
                this.completedPartitionThreads = new ArrayBlockingQueue<Boolean>(this.numOfPartitions);
            }
            this.collectorDataQueue = new LinkedBlockingQueue<Serializable>();
            List<Integer> indexes = this.stepExecution.getPartitionPropertiesIndex();
            for (int i = 0; i < this.numOfPartitions; ++i) {
                Chunk ch;
                int partitionIndex = -1;
                if (isRestart && !isOverride) {
                    if (indexes != null && i < indexes.size()) {
                        partitionIndex = indexes.get(i);
                    }
                } else {
                    partitionIndex = i;
                }
                StepContextImpl stepContext1 = ((StepContextImpl)this.batchContext).clone();
                Step step1 = stepContext1.getStep();
                PropertyResolver resolver = new PropertyResolver();
                if (partitionIndex >= 0 && partitionIndex < this.partitionProperties.length) {
                    resolver.setPartitionPlanProperties(this.partitionProperties[partitionIndex]);
                    stepContext1.getStepExecution().addPartitionPropertiesIndex(partitionIndex);
                }
                resolver.setResolvePartitionPlanProperties(true);
                resolver.resolve(step1);
                if (isRestart && !isOverride) {
                    List<Serializable> partitionWriterCheckpointInfo;
                    List<Serializable> partitionReaderCheckpointInfo;
                    List<Serializable> partitionPersistentUserData = this.stepExecution.getPartitionPersistentUserData();
                    if (partitionPersistentUserData != null) {
                        stepContext1.setPersistentUserData(partitionPersistentUserData.get(i));
                    }
                    if ((partitionReaderCheckpointInfo = this.stepExecution.getPartitionReaderCheckpointInfo()) != null) {
                        stepContext1.getStepExecution().setReaderCheckpointInfo(partitionReaderCheckpointInfo.get(i));
                    }
                    if ((partitionWriterCheckpointInfo = this.stepExecution.getPartitionWriterCheckpointInfo()) != null) {
                        stepContext1.getStepExecution().setWriterCheckpointInfo(partitionWriterCheckpointInfo.get(i));
                    }
                }
                if (isRestart && isOverride && this.reducer != null) {
                    this.reducer.rollbackPartitionedStep();
                }
                AbstractRunner runner1 = (ch = step1.getChunk()) == null ? new BatchletRunner(stepContext1, this.enclosingRunner, this, step1.getBatchlet()) : new ChunkRunner(stepContext1, this.enclosingRunner, this, ch);
                if (i >= this.numOfThreads) {
                    this.completedPartitionThreads.take();
                }
                this.jobContext.getBatchEnvironment().getExecutorService().submit(runner1);
            }
            consolidatedBatchStatus = BatchStatus.STARTED;
            ArrayList<StepExecutionImpl> fromAllPartitions = new ArrayList<StepExecutionImpl>();
            this.ut.begin();
            try {
                while (fromAllPartitions.size() < this.numOfPartitions) {
                    Serializable data = this.collectorDataQueue.take();
                    if (data instanceof StepExecutionImpl) {
                        StepExecutionImpl s = (StepExecutionImpl)data;
                        fromAllPartitions.add(s);
                        BatchStatus bs = s.getBatchStatus();
                        if (bs == BatchStatus.FAILED || bs == BatchStatus.STOPPED) {
                            List<Integer> idxes = s.getPartitionPropertiesIndex();
                            Integer idx = null;
                            if (idxes != null && idxes.size() > 0) {
                                idx = idxes.get(0);
                            }
                            this.stepExecution.addPartitionPropertiesIndex(idx);
                            this.stepExecution.setNumOfPartitions(this.stepExecution.getNumOfPartitions() + 1);
                            this.stepExecution.addPartitionPersistentUserData(s.getPersistentUserData());
                            this.stepExecution.addPartitionReaderCheckpointInfo(s.getReaderCheckpointInfo());
                            this.stepExecution.addPartitionWriterCheckpointInfo(s.getWriterCheckpointInfo());
                            if (consolidatedBatchStatus != BatchStatus.FAILED) {
                                consolidatedBatchStatus = bs;
                            }
                        }
                        if (this.analyzer == null) continue;
                        this.analyzer.analyzeStatus(bs, s.getExitStatus());
                        continue;
                    }
                    if (this.analyzer == null) continue;
                    this.analyzer.analyzeCollectorData(data);
                }
                if (consolidatedBatchStatus == BatchStatus.FAILED || consolidatedBatchStatus == BatchStatus.STOPPED) {
                    this.ut.rollback();
                } else {
                    if (this.reducer != null) {
                        this.reducer.beforePartitionedStepCompletion();
                    }
                    this.ut.commit();
                }
                if (this.reducer != null) {
                    if (consolidatedBatchStatus == BatchStatus.FAILED || consolidatedBatchStatus == BatchStatus.STOPPED) {
                        this.reducer.rollbackPartitionedStep();
                        this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
                    } else {
                        this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
                    }
                }
            }
            catch (Exception e) {
                consolidatedBatchStatus = BatchStatus.FAILED;
                if (this.reducer == null) break block30;
                this.reducer.rollbackPartitionedStep();
                this.ut.rollback();
                this.reducer.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            }
        }
        ((StepContextImpl)this.batchContext).setBatchStatus(consolidatedBatchStatus);
    }

    private void initPartitionConfig() {
        Partition partition = this.step.getPartition();
        if (partition != null) {
            RefArtifact analyzerConfig;
            RefArtifact mapperConfig;
            this.isPartitioned = true;
            RefArtifact reducerConfig = partition.getReducer();
            if (reducerConfig != null) {
                this.reducer = (PartitionReducer)this.jobContext.createArtifact(reducerConfig.getRef(), null, reducerConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            if ((mapperConfig = partition.getMapper()) != null) {
                this.mapper = (PartitionMapper)this.jobContext.createArtifact(mapperConfig.getRef(), null, mapperConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            if ((analyzerConfig = partition.getAnalyzer()) != null) {
                this.analyzer = (PartitionAnalyzer)this.jobContext.createArtifact(analyzerConfig.getRef(), null, analyzerConfig.getProperties(), (StepContextImpl)this.batchContext);
            }
            this.collectorConfig = partition.getCollector();
            this.plan = partition.getPlan();
        }
    }

    private void createStepListeners() {
        List<RefArtifact> listeners = this.step.getListeners();
        for (RefArtifact listener : listeners) {
            String ref = listener.getRef();
            Class<?> cls = this.jobContext.getArtifactClass(ref);
            if (StepListener.class.isAssignableFrom(cls)) {
                Object o = this.jobContext.createArtifact(ref, null, listener.getProperties(), (StepContextImpl)this.batchContext);
                this.stepListeners.add((StepListener)o);
            }
            if (!ChunkListener.class.isAssignableFrom(cls) && !ItemReadListener.class.isAssignableFrom(cls) && !ItemWriteListener.class.isAssignableFrom(cls) && !ItemProcessListener.class.isAssignableFrom(cls) && !SkipReadListener.class.isAssignableFrom(cls) && !SkipWriteListener.class.isAssignableFrom(cls) && !SkipProcessListener.class.isAssignableFrom(cls) && !RetryReadListener.class.isAssignableFrom(cls) && !RetryWriteListener.class.isAssignableFrom(cls) && !RetryProcessListener.class.isAssignableFrom(cls)) continue;
            if (this.chunkRelatedListeners == null) {
                this.chunkRelatedListeners = new HashMap();
            }
            this.chunkRelatedListeners.put(ref, cls);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$javax$batch$runtime$BatchStatus;

        static {
            $SwitchMap$javax$batch$runtime$BatchStatus = new int[BatchStatus.values().length];
            try {
                1.$SwitchMap$javax$batch$runtime$BatchStatus[BatchStatus.STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$batch$runtime$BatchStatus[BatchStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$javax$batch$runtime$BatchStatus[BatchStatus.STOPPING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

