/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.UtilMessage;

public final class LoadingCacheUtils {
    private LoadingCacheUtils() {
    }

    public static <K, V> V getCacheValue(LoadingCache<K, V> cache, K key) {
        try {
            return cache.get(key);
        }
        catch (ExecutionException e) {
            throw new WeldException(UtilMessage.UNABLE_TO_LOAD_CACHE_VALUE, e.getCause(), key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new WeldException(UtilMessage.UNABLE_TO_LOAD_CACHE_VALUE, cause, key);
        }
    }

    public static <T, K, V> T getCastCacheValue(LoadingCache<K, V> cache, Object key) {
        return (T)LoadingCacheUtils.getCacheValue(cache, key);
    }
}

