/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import com.arjuna.ats.jta.UserTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jberet.se.BatchThreadFactory;
import org.jberet.se.SEArtifactFactory;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.ThreadContextSetup;
import org.jberet.util.BatchLogger;

public final class BatchSEEnvironment
implements BatchEnvironment {
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new BatchThreadFactory());
    private static final ThreadContextSetup.TearDownHandle NO_OP_THREAD_CONTEXT_TEAR_DOWN = new ThreadContextSetup.TearDownHandle(){

        public void tearDown() {
        }
    };
    private static final ThreadContextSetup NO_OP_THREAD_CONTEXT_SETUP = new ThreadContextSetup(){

        public ThreadContextSetup.TearDownHandle setup() {
            return NO_OP_THREAD_CONTEXT_TEAR_DOWN;
        }
    };
    public static final String CONFIG_FILE_NAME = "jberet.properties";
    private volatile Properties configProperties;

    public ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BatchSEEnvironment.class.getClassLoader();
        }
        return cl;
    }

    public ArtifactFactory getArtifactFactory() {
        return new SEArtifactFactory();
    }

    public ExecutorService getExecutorService() {
        return executorService;
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return UserTransaction.userTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getBatchConfigurationProperties() {
        Properties result = this.configProperties;
        if (result == null) {
            BatchSEEnvironment batchSEEnvironment = this;
            synchronized (batchSEEnvironment) {
                result = this.configProperties;
                if (result == null) {
                    result = new Properties();
                    InputStream configStream = this.getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
                    if (configStream != null) {
                        try {
                            result.load(configStream);
                        }
                        catch (IOException e) {
                            throw BatchLogger.LOGGER.failToLoadConfig((Throwable)e, CONFIG_FILE_NAME);
                        }
                    } else {
                        BatchLogger.LOGGER.useDefaultJBeretConfig(CONFIG_FILE_NAME);
                    }
                    this.configProperties = result;
                }
            }
        }
        return result;
    }

    public ThreadContextSetup getThreadContextSetup() {
        return NO_OP_THREAD_CONTEXT_SETUP;
    }

    public <T> T lookup(String name) throws NamingException {
        return InitialContext.doLookup(name);
    }
}

