/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi.transactional;

import com.arjuna.ats.jta.logging.jtaLogger;
import javax.enterprise.context.ContextNotActiveException;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.jboss.tm.usertx.client.ServerVMClientUserTransaction;

public class TransactionalInterceptorBase {
    private boolean previousUserTransactionAvailability;
    private static TransactionManager transactionManager;

    private Transactional getTransactional(InvocationContext ic) {
        Transactional transactional = ic.getMethod().getAnnotation(Transactional.class);
        if (transactional != null) {
            return transactional;
        }
        Class<?> targetClass = ic.getTarget().getClass();
        transactional = targetClass.getAnnotation(Transactional.class);
        if (transactional != null) {
            return transactional;
        }
        throw new RuntimeException(jtaLogger.i18NLogger.get_expected_transactional_annotation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InvocationContext ic, TransactionManager tm) throws Exception {
        tm.begin();
        Transaction tx = tm.getTransaction();
        try {
            Object object = ic.proceed();
            return object;
        }
        catch (Exception e) {
            this.handleException(ic, e, tx);
        }
        finally {
            this.endTransaction(tm, tx);
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object invokeInCallerTx(InvocationContext ic, Transaction tx) throws Exception {
        try {
            return ic.proceed();
        }
        catch (Exception e) {
            this.handleException(ic, e, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    protected void handleException(InvocationContext ic, Exception e, Transaction tx) throws Exception {
        Transactional transactional = this.getTransactional(ic);
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(e.getClass())) continue;
            throw e;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(e.getClass())) continue;
            tx.setRollbackOnly();
            throw e;
        }
        if (e instanceof RuntimeException) {
            tx.setRollbackOnly();
            throw e;
        }
        throw e;
    }

    protected void endTransaction(TransactionManager tm, Transaction tx) throws Exception {
        if (tx != tm.getTransaction()) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
        }
        if (tx.getStatus() == 1) {
            tm.rollback();
        } else {
            tm.commit();
        }
    }

    protected void setUserTransactionAvailable(boolean available) {
        this.previousUserTransactionAvailability = ServerVMClientUserTransaction.isAvailable();
        ServerVMClientUserTransaction.setAvailability((boolean)available);
    }

    protected void resetUserTransactionAvailability() {
        ServerVMClientUserTransaction.setAvailability((boolean)this.previousUserTransactionAvailability);
    }

    protected TransactionManager getTransactionManager() {
        if (transactionManager == null) {
            try {
                InitialContext initialContext = new InitialContext();
                transactionManager = (TransactionManager)initialContext.lookup("java:jboss/TransactionManager");
            }
            catch (NamingException e) {
                throw new ContextNotActiveException(jtaLogger.i18NLogger.get_could_not_lookup_tm(), (Throwable)e);
            }
        }
        return transactionManager;
    }
}

