/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.weld.context.beanstore.LockedBean;

public class LockStore
implements Serializable {
    private static final long serialVersionUID = -698649566870070414L;
    private volatile transient Map<String, ReferenceCountedLock> locks = new HashMap<String, ReferenceCountedLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedBean lock(String id) {
        ReferenceCountedLock refLock;
        LockStore lockStore = this;
        synchronized (lockStore) {
            if (this.locks == null) {
                this.locks = new HashMap<String, ReferenceCountedLock>();
            }
            if ((refLock = this.locks.get(id)) != null) {
                ++refLock.count;
            } else {
                refLock = new ReferenceCountedLock(id);
                this.locks.put(id, refLock);
            }
        }
        refLock.lock.lock();
        return refLock;
    }

    private class ReferenceCountedLock
    implements LockedBean {
        private final String key;
        int count = 1;
        final ReentrantLock lock = new ReentrantLock();

        private ReferenceCountedLock(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            LockStore lockStore = LockStore.this;
            synchronized (lockStore) {
                this.lock.unlock();
                --this.count;
                if (this.count == 0) {
                    LockStore.this.locks.remove(this.key);
                }
            }
        }
    }
}

