/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.jta.xa.XidImple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class RecoveryXids {
    private final Map<XidImple, Long> _whenFirstSeen = new HashMap<XidImple, Long>();
    private final Map<XidImple, Long> _whenLastSeen = new HashMap<XidImple, Long>();
    private XAResource _xares;
    private long _lastValidated;
    private static final int staleSafetyIntervalMillis = 20000;
    private static int safetyIntervalMillis = 10000;

    public RecoveryXids(XAResource xares) {
        this._xares = xares;
        this._lastValidated = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecoveryXids) {
            try {
                return ((RecoveryXids)obj)._xares.isSameRM(this._xares);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final void nextScan(Xid[] trans) {
        long currentTime = System.currentTimeMillis();
        if (trans != null) {
            for (Xid xid : trans) {
                XidImple xidImple = new XidImple(xid);
                if (!this._whenFirstSeen.containsKey(xidImple)) {
                    this._whenFirstSeen.put(xidImple, currentTime);
                }
                this._whenLastSeen.put(xidImple, currentTime);
            }
        }
        HashSet<XidImple> candidates = new HashSet<XidImple>(this._whenFirstSeen.keySet());
        for (XidImple candidate : candidates) {
            if (this._whenLastSeen.get(candidate) == currentTime) continue;
            this._whenFirstSeen.remove(candidate);
            this._whenLastSeen.remove(candidate);
        }
    }

    public final Xid[] toRecover() {
        LinkedList<XidImple> oldEnoughXids = new LinkedList<XidImple>();
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<XidImple, Long> entry : this._whenFirstSeen.entrySet()) {
            if (entry.getValue() + (long)safetyIntervalMillis > currentTime) continue;
            oldEnoughXids.add(entry.getKey());
        }
        return oldEnoughXids.toArray(new Xid[oldEnoughXids.size()]);
    }

    public final boolean isSameRM(XAResource xares) {
        try {
            if (xares == null) {
                return false;
            }
            return xares.isSameRM(this._xares);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean contains(Xid xid) {
        XidImple xidImple = new XidImple(xid);
        return this._whenFirstSeen.containsKey(xidImple);
    }

    public boolean isStale() {
        long now = System.currentTimeMillis();
        long threshold = this._lastValidated + (long)(2 * safetyIntervalMillis < 20000 ? 20000 : 2 * safetyIntervalMillis);
        long diff = now - threshold;
        boolean result = diff > 0L;
        return result;
    }

    public boolean remove(Xid xid) {
        XidImple xidImple = new XidImple(xid);
        if (this._whenFirstSeen.containsKey(xidImple)) {
            this._whenFirstSeen.remove(xidImple);
            this._whenLastSeen.remove(xidImple);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._whenFirstSeen.isEmpty();
    }

    public boolean updateIfEquivalentRM(XAResource xaResource, Xid[] xids) {
        if (xids != null && xids.length > 0) {
            for (int i = 0; i < xids.length; ++i) {
                if (!this.contains(xids[i])) continue;
                this._xares = xaResource;
                this._lastValidated = System.currentTimeMillis();
                return true;
            }
        }
        if (this.isSameRM(xaResource)) {
            this._xares = xaResource;
            this._lastValidated = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

