/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.util.collections.Arrays2;
import org.slf4j.cal10n.LocLogger;

public class ScopeModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(Scope.class, NormalScope.class);
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private final boolean normal;
    private final boolean passivating;

    public ScopeModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
        if (this.isValid()) {
            if (enhancedAnnotatedAnnotation.isAnnotationPresent(NormalScope.class)) {
                this.passivating = ((NormalScope)enhancedAnnotatedAnnotation.getAnnotation(NormalScope.class)).passivating();
                this.normal = true;
            } else {
                this.normal = false;
                this.passivating = false;
            }
        } else {
            this.normal = false;
            this.passivating = false;
        }
    }

    @Override
    protected void check(EnhancedAnnotation<T> annotatedAnnotation) {
        super.check(annotatedAnnotation);
        if (this.isValid()) {
            if (!annotatedAnnotation.isAnnotationPresent(Target.class)) {
                log.debug((Enum)ReflectionMessage.MISSING_TARGET, new Object[]{annotatedAnnotation});
            } else if (!Arrays2.unorderedEquals((Object[])((Target)annotatedAnnotation.getAnnotation(Target.class)).value(), new Object[]{ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})) {
                log.debug((Enum)ReflectionMessage.MISSING_TARGET_METHOD_FIELD_TYPE, new Object[]{annotatedAnnotation});
            }
        }
    }

    public boolean isNormal() {
        return this.normal;
    }

    public boolean isPassivating() {
        return this.passivating;
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    @Override
    public String toString() {
        String valid = this.isValid() ? "Valid " : "Invalid";
        String normal = this.isNormal() ? "normal " : "non-normal ";
        String passivating = this.isPassivating() ? "passivating " : "pon-passivating ";
        return valid + normal + passivating + " scope model for " + this.getRawType();
    }
}

