/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.ForwardingContext;

public class PassivatingContextWrapper {
    private PassivatingContextWrapper() {
    }

    public static Context wrap(Context context, ContextualStore store) {
        if (context instanceof AlterableContext) {
            return new AlterableContextWrapper((AlterableContext)context, store);
        }
        return new ContextWrapper(context, store);
    }

    private static class AlterableContextWrapper
    extends AbstractPassivatingContextWrapper<AlterableContext>
    implements AlterableContext {
        public AlterableContextWrapper(AlterableContext context, ContextualStore store) {
            super(context, store);
        }

        @Override
        public void destroy(Contextual<?> contextual) {
            contextual = this.store.getSerializableContextual(contextual);
            ((AlterableContext)this.delegate()).destroy(contextual);
        }
    }

    private static class ContextWrapper
    extends AbstractPassivatingContextWrapper<Context> {
        public ContextWrapper(Context context, ContextualStore store) {
            super(context, store);
        }
    }

    private static abstract class AbstractPassivatingContextWrapper<C extends Context>
    extends ForwardingContext {
        private final C context;
        protected final ContextualStore store;

        public AbstractPassivatingContextWrapper(C context, ContextualStore store) {
            this.context = context;
            this.store = store;
        }

        @Override
        public <T> T get(Contextual<T> contextual) {
            contextual = this.store.getSerializableContextual(contextual);
            return this.context.get(contextual);
        }

        @Override
        public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            contextual = this.store.getSerializableContextual(contextual);
            return this.context.get(contextual, creationalContext);
        }

        protected C delegate() {
            return this.context;
        }
    }
}

