/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchUtil;

public abstract class AbstractRepository
implements JobRepository {
    final ConcurrentMap<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    final Map<Long, JobInstance> jobInstances = Collections.synchronizedMap(new LinkedHashMap());
    final ConcurrentMap<Long, JobExecution> jobExecutions = new ConcurrentHashMap<Long, JobExecution>();

    abstract void insertJobInstance(JobInstanceImpl var1);

    abstract void insertJobExecution(JobExecutionImpl var1);

    abstract void insertStepExecution(StepExecutionImpl var1, JobExecutionImpl var2);

    @Override
    public void addJob(Job job) {
        Job existing = this.jobs.putIfAbsent(job.getId(), job);
        if (existing != null) {
            BatchLogger.LOGGER.jobAlreadyExists(job.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(String jobId) {
        this.jobs.remove(jobId);
        Map<Long, JobInstance> map = this.jobInstances;
        synchronized (map) {
            Iterator<Map.Entry<Long, JobInstance>> it = this.jobInstances.entrySet().iterator();
            while (it.hasNext()) {
                JobInstance ji = it.next().getValue();
                if (!ji.getJobName().equals(jobId)) continue;
                it.remove();
            }
        }
        Iterator it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecution je = (JobExecution)it.next().getValue();
            if (!je.getJobName().equals(jobId)) continue;
            it.remove();
        }
    }

    @Override
    public Job getJob(String jobId) {
        return (Job)this.jobs.get(jobId);
    }

    @Override
    public Collection<Job> getJobs() {
        return this.jobs.values();
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        ApplicationAndJobName appJobNames = new ApplicationAndJobName(applicationName, job.getId());
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, appJobNames);
        this.insertJobInstance(jobInstance);
        JobInstance jobInstanceExisting = this.jobInstances.put(jobInstance.getInstanceId(), jobInstance);
        if (jobInstanceExisting != null) {
            throw BatchMessages.MESSAGES.jobInstanceAlreadyExists(jobInstance.getInstanceId());
        }
        return jobInstance;
    }

    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        this.jobInstances.remove(jobInstanceIdToRemove);
    }

    @Override
    public JobInstance getJobInstance(long jobInstanceId) {
        return this.jobInstances.get(jobInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobInstance> getJobInstances(String jobName) {
        ArrayList<JobInstance> result = new ArrayList<JobInstance>();
        Map<Long, JobInstance> map = this.jobInstances;
        synchronized (map) {
            for (JobInstance e : this.jobInstances.values()) {
                if (!e.getJobName().equals(jobName)) continue;
                result.add(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobInstanceCount(String jobName) {
        int count = 0;
        Map<Long, JobInstance> map = this.jobInstances;
        synchronized (map) {
            for (JobInstance e : this.jobInstances.values()) {
                if (!e.getJobName().equals(jobName)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        JobExecution jobExecutionExisting = this.jobExecutions.putIfAbsent(jobExecution.getExecutionId(), jobExecution);
        if (jobExecutionExisting != null) {
            throw BatchMessages.MESSAGES.jobExecutionAlreadyExists(jobExecutionExisting.getExecutionId());
        }
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecution getJobExecution(long jobExecutionId) {
        return (JobExecution)this.jobExecutions.get(jobExecutionId);
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        if (jobInstance == null) {
            ArrayList<JobExecution> result = new ArrayList<JobExecution>();
            result.addAll(this.jobExecutions.values());
            return result;
        }
        return ((JobInstanceImpl)jobInstance).getJobExecutions();
    }

    @Override
    public StepExecutionImpl createStepExecution(String stepName) {
        return new StepExecutionImpl(stepName);
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId) {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobExecution(jobExecutionId);
        return jobExecution.getStepExecutions();
    }

    @Override
    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution(stepExecution);
        this.insertStepExecution(stepExecution, jobExecution);
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, StepExecutionImpl stepExecution) {
        Serializable copy;
        Serializable ser = stepExecution.getPersistentUserData();
        if (ser != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setPersistentUserData(copy);
        }
        if ((ser = stepExecution.getReaderCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setReaderCheckpointInfo(copy);
        }
        if ((ser = stepExecution.getWriterCheckpointInfo()) != null) {
            copy = BatchUtil.clone(ser);
            stepExecution.setWriterCheckpointInfo(copy);
        }
    }

    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)jobExecution;
        jobExecutionImpl.setEndTime(System.currentTimeMillis());
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart) {
        for (StepExecution stepExecution : jobExecutionToRestart.getStepExecutions()) {
            if (!stepName.equals(stepExecution.getStepName())) continue;
            return (StepExecutionImpl)stepExecution;
        }
        StepExecutionImpl result = null;
        long instanceId = jobExecutionToRestart.getJobInstance().getInstanceId();
        for (JobExecution jobExecution : this.jobExecutions.values()) {
            JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)jobExecution;
            if (instanceId != jobExecutionImpl.getJobInstance().getInstanceId() || jobExecutionImpl.getExecutionId() == jobExecutionToRestart.getExecutionId()) continue;
            for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                if (!stepExecution.getStepName().equals(stepName) || result != null && result.getStepExecutionId() >= stepExecution.getStepExecutionId()) continue;
                result = (StepExecutionImpl)stepExecution;
            }
        }
        return result;
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, StepExecutionImpl partitionExecution) {
        enclosingStepExecution.getPartitionExecutions().add(partitionExecution);
    }

    @Override
    public List<StepExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly) {
        if (stepExecution != null) {
            List<StepExecutionImpl> partitionExecutions = stepExecution.getPartitionExecutions();
            if (partitionExecutions.isEmpty() || !notCompletedOnly) {
                return partitionExecutions;
            }
            ArrayList<StepExecutionImpl> result = new ArrayList<StepExecutionImpl>();
            for (StepExecutionImpl sei : partitionExecutions) {
                if (sei.getBatchStatus() == BatchStatus.COMPLETED) continue;
                result.add(sei);
            }
            return result;
        }
        return null;
    }
}

