/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.AbstractAnnotatedTypeRegisteringEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class AfterTypeDiscoveryImpl
extends AbstractAnnotatedTypeRegisteringEvent
implements AfterTypeDiscovery {
    private final GlobalEnablementBuilder builder;
    private final ContainerLifecycleEvents events;
    private final ClassTransformer transformer;
    private final SlimAnnotatedTypeStore store;

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        new AfterTypeDiscoveryImpl(beanManager, bdaMapping, deployment, contexts).fire();
    }

    protected AfterTypeDiscoveryImpl(BeanManagerImpl beanManager, BeanDeploymentArchiveMapping bdaMapping, Deployment deployment, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)AfterTypeDiscovery.class), bdaMapping, deployment, contexts);
        this.builder = (GlobalEnablementBuilder)beanManager.getServices().get(GlobalEnablementBuilder.class);
        this.events = (ContainerLifecycleEvents)beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.transformer = (ClassTransformer)beanManager.getServices().get(ClassTransformer.class);
        this.store = (SlimAnnotatedTypeStore)beanManager.getServices().get(SlimAnnotatedTypeStore.class);
    }

    public List<Class<?>> getAlternatives() {
        return this.builder.getAlternativeList();
    }

    public List<Class<?>> getInterceptors() {
        return this.builder.getInterceptorList();
    }

    public List<Class<?>> getDecorators() {
        return this.builder.getDecoratorList();
    }

    public void addAnnotatedType(AnnotatedType<?> type, String id) {
        this.addSyntheticAnnotatedType(type, id);
    }

    @Override
    protected void storeSyntheticAnnotatedType(BeanDeployment deployment, AnnotatedType<?> type, String id) {
        SlimAnnotatedType<?> annotatedType = this.transformer.getUnbackedAnnotatedType(type, this.getBeanManager().getId(), id);
        Extension extension = this.getSyntheticAnnotatedTypeSource();
        ProcessAnnotatedTypeImpl<?> event = this.events.fireProcessAnnotatedType(this.getBeanManager(), annotatedType, extension);
        if (event == null) {
            ((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment()).addSyntheticAnnotatedType(annotatedType, extension);
            this.store.put(annotatedType);
        } else {
            if (event.isVeto()) {
                return;
            }
            annotatedType = event.getResultingAnnotatedType();
            ((BeanDeployerEnvironment)deployment.getBeanDeployer().getEnvironment()).addSyntheticAnnotatedType(annotatedType, extension);
            this.store.put(annotatedType);
        }
    }
}

