/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;

final class FastForwardCsvListReader
extends AbstractCsvReader
implements ICsvListReader {
    private final int startRowNumber;

    public FastForwardCsvListReader(Reader reader, CsvPreference preferences, int startRowNumber) {
        super(reader, preferences);
        this.startRowNumber = startRowNumber;
    }

    public List<String> read() throws IOException {
        this.fastForwardToStartRow();
        if (this.readRow()) {
            return new ArrayList<String>(this.getColumns());
        }
        return null;
    }

    public List<Object> read(CellProcessor ... processors) throws IOException {
        this.fastForwardToStartRow();
        if (processors == null) {
            throw new NullPointerException("processors should not be null");
        }
        if (this.readRow()) {
            return this.executeProcessors(processors);
        }
        return null;
    }

    public List<Object> executeProcessors(CellProcessor ... processors) {
        return super.executeProcessors(new ArrayList(this.getColumns().size()), processors);
    }

    private void fastForwardToStartRow() throws IOException {
        while (this.getRowNumber() < this.startRowNumber) {
            this.readRow();
        }
    }
}

