/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Serializable;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JsonItemReaderWriterBase;

@Named
public class JsonItemReader
extends JsonItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonParserFeatures;
    @Inject
    @BatchProperty
    protected Map<String, String> deserializationFeatures;
    @Inject
    @BatchProperty
    protected Class inputDecorator;
    @Inject
    @BatchProperty
    protected Class[] customDeserializers;
    private JsonParser jsonParser;
    private JsonToken token;
    private int rowNumber;

    public void open(Serializable checkpoint) throws Exception {
        DeserializationFeature feature;
        String value;
        String key;
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (checkpoint != null) {
            this.start = (Integer)checkpoint;
        }
        if (this.start > this.end) {
            throw SupportLogger.LOGGER.invalidStartPosition((Integer)checkpoint, this.start, this.end);
        }
        super.initJsonFactory();
        if (this.inputDecorator != null) {
            this.jsonFactory.setInputDecorator((InputDecorator)this.inputDecorator.newInstance());
        }
        if (this.deserializationFeatures != null) {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper(this.jsonFactory);
            }
            for (Map.Entry<String, String> e : this.deserializationFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = DeserializationFeature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.objectMapper.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.objectMapper.configure(feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
        this.registerModule();
        this.jsonParser = this.jsonFactory.createParser(this.getInputReader(false));
        if (this.objectMapper != null) {
            this.jsonParser.setCodec((ObjectCodec)this.objectMapper);
        }
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.jsonParserFeatures != null) {
            for (Map.Entry<String, String> e : this.jsonParserFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = JsonParser.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.jsonParser.configure((JsonParser.Feature)feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.jsonParser.configure((JsonParser.Feature)feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
    }

    public Object readItem() throws Exception {
        if (this.rowNumber >= this.end) {
            return null;
        }
        int nestedObjectLevel = 0;
        while (true) {
            this.token = this.jsonParser.nextToken();
            if (this.token == null) {
                return null;
            }
            if (this.token == JsonToken.START_OBJECT) {
                if (++nestedObjectLevel == 1) {
                    ++this.rowNumber;
                } else if (nestedObjectLevel < 1) {
                    SupportLogger.LOGGER.unexpectedJsonContent(this.jsonParser.getCurrentLocation());
                }
                if (this.rowNumber < this.start) continue;
                break;
            }
            if (this.token != JsonToken.END_OBJECT) continue;
            --nestedObjectLevel;
        }
        return this.jsonParser.readValueAs(this.beanType);
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.rowNumber);
    }

    public void close() throws Exception {
        if (this.jsonParser != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.jsonParser.close();
            this.jsonParser = null;
        }
    }

    @Override
    protected void registerModule() throws Exception {
        if (this.customDeserializers != null) {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper(this.jsonFactory);
            }
            SimpleModule simpleModule = new SimpleModule("customDeserializer-module");
            for (Class aClass : this.customDeserializers) {
                simpleModule.addDeserializer(aClass, (JsonDeserializer)aClass.newInstance());
            }
            this.objectMapper.registerModule((Module)simpleModule);
        }
    }
}

