/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JsonItemReaderWriterBase;

@Named
public class JsonItemWriter
extends JsonItemReaderWriterBase
implements ItemWriter {
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String writeMode;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonGeneratorFeatures;
    @Inject
    @BatchProperty
    protected Map<String, String> serializationFeatures;
    @Inject
    @BatchProperty
    protected Class prettyPrinter;
    @Inject
    @BatchProperty
    protected Class outputDecorator;
    @Inject
    @BatchProperty
    protected Class[] customSerializers;
    protected JsonGenerator jsonGenerator;

    public void open(Serializable checkpoint) throws Exception {
        SerializationFeature feature;
        String value;
        String key;
        SupportLogger.LOGGER.tracef("Open JsonItemWriter with checkpoint %s, which is ignored for JsonItemWriter.%n", checkpoint);
        super.initJsonFactory();
        if (this.outputDecorator != null) {
            this.jsonFactory.setOutputDecorator((OutputDecorator)this.outputDecorator.newInstance());
        }
        if (this.serializationFeatures != null) {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper(this.jsonFactory);
            }
            for (Map.Entry<String, String> e : this.serializationFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = SerializationFeature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.objectMapper.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.objectMapper.configure(feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
        this.registerModule();
        this.jsonGenerator = this.jsonFactory.createGenerator(this.getOutputWriter(this.writeMode, this.stepContext));
        if (this.objectMapper != null) {
            this.jsonGenerator.setCodec((ObjectCodec)this.objectMapper);
        }
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        if (this.jsonGeneratorFeatures != null) {
            for (Map.Entry<String, String> e : this.jsonGeneratorFeatures.entrySet()) {
                key = e.getKey();
                value = e.getValue();
                try {
                    feature = JsonGenerator.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.jsonGenerator.configure((JsonGenerator.Feature)feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.jsonGenerator.configure((JsonGenerator.Feature)feature, false);
                    continue;
                }
                throw SupportLogger.LOGGER.invalidReaderWriterProperty(value, key);
            }
        }
        if (this.prettyPrinter == null) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        } else {
            this.jsonGenerator.setPrettyPrinter((PrettyPrinter)this.prettyPrinter.newInstance());
        }
        this.jsonGenerator.writeStartArray();
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object o : items) {
            this.jsonGenerator.writeObject(o);
        }
        this.jsonGenerator.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
        if (this.jsonGenerator != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.jsonGenerator.close();
            this.jsonGenerator = null;
            if (this.resource.equalsIgnoreCase("StepContext")) {
                Object transientUserData = this.stepContext.getTransientUserData();
                if ("overwrite".equalsIgnoreCase(this.writeMode) || transientUserData == null) {
                    this.stepContext.setTransientUserData((Object)this.stringWriter.toString());
                } else {
                    this.stepContext.setTransientUserData((Object)(transientUserData + this.stringWriter.toString()));
                }
                this.stringWriter = null;
            }
        }
    }

    @Override
    protected void registerModule() throws Exception {
        if (this.customSerializers != null) {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper(this.jsonFactory);
            }
            SimpleModule simpleModule = new SimpleModule("customSerializer-module");
            for (Class aClass : this.customSerializers) {
                simpleModule.addSerializer(aClass, (JsonSerializer)aClass.newInstance());
            }
            this.objectMapper.registerModule((Module)simpleModule);
        }
    }
}

