/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.dom;

import com.fasterxml.aalto.dom.DOMOutputElement;
import com.fasterxml.aalto.out.WriterConfig;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.ri.EmptyNamespaceContext;
import org.codehaus.stax2.ri.dom.DOMWrappingWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMWriterImpl
extends DOMWrappingWriter {
    protected final WriterConfig _config;
    protected DOMOutputElement _currElem;
    protected DOMOutputElement _openElement;
    protected int[] _autoNsSeq;
    protected String _suggestedDefNs = null;
    protected String _automaticNsPrefix;
    HashMap<String, String> _suggestedPrefixes = null;

    private DOMWriterImpl(WriterConfig writerConfig, Node node) throws XMLStreamException {
        super(node, true, writerConfig.willRepairNamespaces());
        this._config = writerConfig;
        this._autoNsSeq = null;
        this._automaticNsPrefix = writerConfig.getAutomaticNsPrefix();
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                this._currElem = DOMOutputElement.createRoot();
                this._openElement = null;
                break;
            }
            case 1: {
                DOMOutputElement dOMOutputElement = DOMOutputElement.createRoot();
                Element element = (Element)node;
                this._openElement = this._currElem = dOMOutputElement.createChild(element);
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + node.getClass());
            }
        }
    }

    public static DOMWriterImpl createFrom(WriterConfig writerConfig, DOMResult dOMResult) throws XMLStreamException {
        Node node = dOMResult.getNode();
        return new DOMWriterImpl(writerConfig, node);
    }

    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this._currElem;
    }

    public String getPrefix(String string) {
        String string2;
        if (!this.mNsAware) {
            return null;
        }
        if (this.mNsContext != null && (string2 = this.mNsContext.getPrefix(string)) != null) {
            return string2;
        }
        return this._currElem.getPrefix(string);
    }

    public Object getProperty(String string) {
        return this._config.getProperty(string, false);
    }

    public void setDefaultNamespace(String string) {
        this._suggestedDefNs = string == null || string.length() == 0 ? null : string;
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (string.length() == 0) {
            this.setDefaultNamespace(string2);
            return;
        }
        if (string2 == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (string.equals("xml")) {
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                DOMWriterImpl.throwOutputError((String)("Trying to redeclare prefix 'xml' from its default URI 'http://www.w3.org/XML/1998/namespace' to \"" + string2 + "\""));
            }
        } else {
            if (string.equals("xmlns")) {
                if (!string2.equals("http://www.w3.org/2000/xmlns/")) {
                    DOMWriterImpl.throwOutputError((String)"Trying to declare prefix 'xmlns' (illegal as per NS 1.1 #4)");
                }
                return;
            }
            if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
                DOMWriterImpl.throwOutputError((String)("Trying to bind URI 'http://www.w3.org/XML/1998/namespace to prefix \"" + string + "\" (can only bind to 'xml')"));
            } else if (string2.equals("http://www.w3.org/2000/xmlns/")) {
                DOMWriterImpl.throwOutputError((String)("Trying to bind URI 'http://www.w3.org/2000/xmlns/ to prefix \"" + string + "\" (can not be explicitly bound)"));
            }
        }
        if (this._suggestedPrefixes == null) {
            this._suggestedPrefixes = new HashMap(16);
        }
        this._suggestedPrefixes.put(string2, string);
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.outputAttribute(null, null, string, string2);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.outputAttribute(string, null, string2, string3);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.outputAttribute(string2, string, string3, string4);
    }

    public void writeDefaultNamespace(String string) {
        if (this._openElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        this.setDefaultNamespace(string);
        this._openElement.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeEmptyElement(null, string);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.createStartElem(string, null, string2, true);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        if (string == null) {
            string = "";
        }
        this.createStartElem(string3, string, string2, true);
    }

    public void writeEndDocument() {
        this._openElement = null;
        this._currElem = null;
    }

    public void writeEndElement() {
        if (this._currElem == null || this._currElem.isRoot()) {
            throw new IllegalStateException("No open start element to close");
        }
        this._openElement = null;
        this._currElem = this._currElem.getParent();
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            this.writeDefaultNamespace(string2);
            return;
        }
        if (!this.mNsAware) {
            DOMWriterImpl.throwOutputError((String)"Can not write namespaces with non-namespace writer.");
        }
        this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string, string2);
        this._currElem.addPrefix(string, string2);
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElement(null, string);
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.createStartElem(string, null, string2, false);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.createStartElem(string3, string, string2, false);
    }

    public boolean isPropertySupported(String string) {
        return this._config.isPropertySupported(string);
    }

    public boolean setProperty(String string, Object object) {
        return this._config.setProperty(string, object);
    }

    public void writeDTD(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this._currElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    protected void appendLeaf(Node node) throws IllegalStateException {
        this._currElem.appendNode(node);
        this._openElement = null;
    }

    protected void createStartElem(String string, String string2, String string3, boolean bl) throws XMLStreamException {
        DOMOutputElement dOMOutputElement;
        if (!this.mNsAware) {
            if (string != null && string.length() > 0) {
                DOMWriterImpl.throwOutputError((String)"Can not specify non-empty uri/prefix in non-namespace mode");
            }
            dOMOutputElement = this._currElem.createAndAttachChild(this.mDocument.createElement(string3));
        } else if (this.mNsRepairing) {
            String string4 = this.validateElemPrefix(string2, string, this._currElem);
            if (string4 != null) {
                dOMOutputElement = string4.length() != 0 ? this._currElem.createAndAttachChild(this.mDocument.createElementNS(string, string4 + ":" + string3)) : this._currElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
            } else {
                boolean bl2;
                if (string2 == null) {
                    string2 = "";
                }
                boolean bl3 = bl2 = (string4 = this.generateElemPrefix(string2, string, this._currElem)).length() != 0;
                if (bl2) {
                    string3 = string4 + ":" + string3;
                }
                this._openElement = dOMOutputElement = this._currElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
                if (bl2) {
                    this.writeNamespace(string4, string);
                    dOMOutputElement.addPrefix(string4, string);
                } else {
                    this.writeDefaultNamespace(string);
                    dOMOutputElement.setDefaultNsUri(string);
                }
            }
        } else {
            if (string2 == null && string != null && string.length() > 0) {
                String string5 = string2 = this._suggestedPrefixes == null ? null : this._suggestedPrefixes.get(string);
                if (string2 == null) {
                    DOMWriterImpl.throwOutputError((String)("Can not find prefix for namespace \"" + string + "\""));
                }
            }
            if (string2 != null && string2.length() != 0) {
                string3 = string2 + ":" + string3;
            }
            dOMOutputElement = this._currElem.createAndAttachChild(this.mDocument.createElementNS(string, string3));
        }
        this._openElement = dOMOutputElement;
        if (!bl) {
            this._currElem = dOMOutputElement;
        }
    }

    protected void outputAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this._openElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                string2 = this.findOrCreateAttrPrefix(string2, string, this._openElement);
            }
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            this._openElement.addAttribute(string, string3, string4);
        } else {
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            this._openElement.addAttribute(string3, string4);
        }
    }

    private final String validateElemPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            String string3 = dOMOutputElement.getDefaultNsUri();
            if (string3 == null || string3.length() == 0) {
                return "";
            }
            return null;
        }
        int n = dOMOutputElement.isPrefixValid(string, string2, true);
        if (n == 1) {
            return string;
        }
        return null;
    }

    protected final String findElemPrefix(String string, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string == null || string.length() == 0) {
            String string2 = dOMOutputElement.getDefaultNsUri();
            if (string2 != null && string2.length() > 0) {
                return null;
            }
            return "";
        }
        return this._currElem.getPrefix(string);
    }

    protected final String generateElemPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        if (string2 == null || string2.length() == 0) {
            return "";
        }
        if (string == null) {
            if (this._suggestedDefNs != null && this._suggestedDefNs.equals(string2)) {
                string = "";
            } else {
                String string3 = string = this._suggestedPrefixes == null ? null : this._suggestedPrefixes.get(string2);
                if (string == null) {
                    if (this._autoNsSeq == null) {
                        this._autoNsSeq = new int[1];
                        this._autoNsSeq[0] = 1;
                    }
                    string = dOMOutputElement.generateMapping(this._automaticNsPrefix, string2, this._autoNsSeq);
                }
            }
        }
        return string;
    }

    protected final String findOrCreateAttrPrefix(String string, String string2, DOMOutputElement dOMOutputElement) throws XMLStreamException {
        String string3;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string != null) {
            int n = dOMOutputElement.isPrefixValid(string, string2, false);
            if (n == 1) {
                return string;
            }
            if (n == 0) {
                dOMOutputElement.addPrefix(string, string2);
                this.writeNamespace(string, string2);
                return string;
            }
        }
        if ((string3 = dOMOutputElement.getExplicitPrefix(string2)) != null) {
            return string3;
        }
        if (string != null) {
            string3 = string;
        } else if (this._suggestedPrefixes != null) {
            string3 = this._suggestedPrefixes.get(string2);
        }
        if (string3 != null && (string3.length() == 0 || dOMOutputElement.getNamespaceURI(string3) != null)) {
            string3 = null;
        }
        if (string3 == null) {
            if (this._autoNsSeq == null) {
                this._autoNsSeq = new int[1];
                this._autoNsSeq[0] = 1;
            }
            string3 = this._currElem.generateMapping(this._automaticNsPrefix, string2, this._autoNsSeq);
        }
        dOMOutputElement.addPrefix(string3, string2);
        this.writeNamespace(string3, string2);
        return string3;
    }
}

