/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.AttributeCollector;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.FixedNsContext;
import com.fasterxml.aalto.in.NsBinding;
import com.fasterxml.aalto.in.NsDeclaration;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.EmptyIterator;
import com.fasterxml.aalto.util.IllegalCharHandler;
import com.fasterxml.aalto.util.SingletonIterator;
import com.fasterxml.aalto.util.TextBuilder;
import com.fasterxml.aalto.util.XmlChars;
import com.fasterxml.aalto.util.XmlConsts;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XmlScanner
implements XmlConsts,
XMLStreamConstants,
NamespaceContext {
    protected final String CDATA_STR = "CDATA[";
    public static final int TOKEN_EOI = -1;
    protected static final int MAX_UNICODE_CHAR = 0x10FFFF;
    protected static final int INT_NULL = 0;
    protected static final int INT_CR = 13;
    protected static final int INT_LF = 10;
    protected static final int INT_TAB = 9;
    protected static final int INT_SPACE = 32;
    protected static final int INT_HYPHEN = 45;
    protected static final int INT_QMARK = 63;
    protected static final int INT_AMP = 38;
    protected static final int INT_LT = 60;
    protected static final int INT_GT = 62;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_EXCL = 33;
    protected static final int INT_COLON = 58;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_SLASH = 47;
    protected static final int INT_EQ = 61;
    protected static final int INT_A = 65;
    protected static final int INT_F = 70;
    protected static final int INT_a = 97;
    protected static final int INT_f = 102;
    protected static final int INT_z = 122;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    private static final int BIND_MISSES_TO_ACTIVATE_CACHE = 10;
    private static final int BIND_CACHE_SIZE = 64;
    private static final int BIND_CACHE_MASK = 63;
    protected final ReaderConfig _config;
    protected final boolean _xml11;
    protected final boolean _cfgCoalescing;
    protected boolean _cfgLazyParsing;
    protected int _currToken = 7;
    protected boolean _tokenIncomplete = false;
    protected int _depth = 0;
    protected final TextBuilder _textBuilder;
    protected boolean _entityPending = false;
    protected char[] _nameBuffer = null;
    protected PName _tokenName = null;
    protected boolean _isEmptyTag = false;
    protected ElementScope _currElem;
    protected String _publicId;
    protected String _systemId;
    protected NsDeclaration _lastNsDecl = null;
    protected int _currNsCount = 0;
    protected NsBinding _defaultNs = NsBinding.createDefaultNs();
    protected NsBinding[] _nsBindings;
    protected int _nsBindingCount = 0;
    protected PName[] _nsBindingCache = null;
    protected int _nsBindMisses = 0;
    protected FixedNsContext _lastNsContext = FixedNsContext.EMPTY_CONTEXT;
    protected final AttributeCollector _attrCollector;
    protected int _attrCount = 0;
    protected int _currRow;

    protected XmlScanner(ReaderConfig readerConfig) {
        this._config = readerConfig;
        this._cfgCoalescing = readerConfig.willCoalesceText();
        this._cfgLazyParsing = readerConfig.willParseLazily();
        this._xml11 = readerConfig.isXml11();
        this._textBuilder = TextBuilder.createRecyclableBuffer(this._config);
        this._attrCollector = new AttributeCollector(readerConfig);
        this._nameBuffer = readerConfig.allocSmallCBuffer(60);
        this._currRow = 0;
    }

    public final void close(boolean bl) throws XMLStreamException {
        this._releaseBuffers();
        if (bl || this._config.willAutoCloseInput()) {
            try {
                this._closeSource();
            }
            catch (IOException iOException) {
                throw new IoStreamException(iOException);
            }
        }
    }

    protected void _releaseBuffers() {
        this._textBuilder.recycle(true);
        if (this._nameBuffer != null) {
            char[] cArray = this._nameBuffer;
            this._nameBuffer = null;
            this._config.freeSmallCBuffer(cArray);
        }
    }

    protected abstract void _closeSource() throws IOException;

    public ReaderConfig getConfig() {
        return this._config;
    }

    public AttributeCollector getAttrCollector() {
        return this._attrCollector;
    }

    public abstract int nextFromProlog(boolean var1) throws XMLStreamException;

    public abstract int nextFromTree() throws XMLStreamException;

    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                throw new Error("Internal error, unexpected incomplete token type " + ErrorConsts.tokenTypeDesc(this._currToken));
            }
        }
    }

    protected final boolean skipToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.skipPI();
                break;
            }
            case 4: {
                if (this.skipCharacters()) {
                    this._currToken = 9;
                    return true;
                }
                if (!this._cfgCoalescing || !this.skipCoalescedText()) break;
                this._currToken = 9;
                return true;
            }
            case 5: {
                this.skipComment();
                break;
            }
            case 6: {
                this.skipSpace();
                break;
            }
            case 12: {
                this.skipCData();
                if (!this._cfgCoalescing) break;
                this.skipCoalescedText();
                if (!this._entityPending) break;
                this._currToken = 9;
                return true;
            }
            case 11: {
                this.finishDTD(false);
                break;
            }
            default: {
                throw new Error("Internal error, unexpected incomplete token type " + ErrorConsts.tokenTypeDesc(this._currToken));
            }
        }
        return false;
    }

    public abstract XMLStreamLocation2 getCurrentLocation();

    public XMLStreamLocation2 getStartLocation() {
        return this.getCurrentLocation();
    }

    public XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this.getCurrentLocation();
    }

    public abstract int getCurrentLineNr();

    public abstract int getCurrentColumnNr();

    public final String getInputSystemId() {
        return this._config.getSystemId();
    }

    public final String getInputPublicId() {
        return this._config.getPublicId();
    }

    public final boolean hasEmptyStack() {
        return this._depth == 0;
    }

    public final int getDepth() {
        return this._depth;
    }

    public final boolean isEmptyTag() {
        return this._isEmptyTag;
    }

    public final PName getName() {
        return this._tokenName;
    }

    public final QName getQName() {
        return this._tokenName.constructQName(this._defaultNs);
    }

    public final String getDTDPublicId() {
        return this._publicId;
    }

    public final String getDTDSystemId() {
        return this._systemId;
    }

    public final String getText() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsAsString();
    }

    public final int getTextLength() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.size();
    }

    public final char[] getTextCharacters() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.getTextBuffer();
    }

    public final int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsToArray(n, cArray, n2, n3);
    }

    public final int getText(Writer writer, boolean bl) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.rawContentsTo(writer);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public final boolean isTextWhitespace() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.isAllWhitespace();
    }

    public final int decodeElements(TypedArrayDecoder typedArrayDecoder, boolean bl) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.decodeElements(typedArrayDecoder, bl);
        }
        catch (TypedXMLStreamException typedXMLStreamException) {
            XMLStreamLocation2 xMLStreamLocation2 = this.getCurrentLocation();
            String string = typedXMLStreamException.getLexical();
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)typedXMLStreamException.getCause();
            throw new TypedXMLStreamException(string, typedXMLStreamException.getMessage(), (Location)xMLStreamLocation2, illegalArgumentException);
        }
    }

    public final void resetForDecoding(Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, boolean bl) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        this._textBuilder.resetForBinaryDecode(base64Variant, charArrayBase64Decoder, bl);
    }

    public void fireSaxStartElement(ContentHandler contentHandler, Attributes attributes) throws SAXException {
        if (contentHandler != null) {
            String string;
            Object object;
            int n = this._depth - 1;
            for (NsDeclaration nsDeclaration = this._lastNsDecl; nsDeclaration != null && nsDeclaration.getLevel() == n; nsDeclaration = nsDeclaration.getPrev()) {
                object = nsDeclaration.getPrefix();
                string = nsDeclaration.getCurrNsURI();
                contentHandler.startPrefixMapping((String)(object == null ? "" : object), string);
            }
            object = this.getName();
            string = ((PName)object).getNsUri();
            contentHandler.startElement(string == null ? "" : string, ((PName)object).getLocalName(), ((PName)object).getPrefixedName(), attributes);
        }
    }

    public void fireSaxEndElement(ContentHandler contentHandler) throws SAXException {
        if (contentHandler != null) {
            PName pName = this.getName();
            String string = pName.getNsUri();
            contentHandler.endElement(string == null ? "" : string, pName.getLocalName(), pName.getPrefixedName());
            int n = this._depth;
            for (NsDeclaration nsDeclaration = this._lastNsDecl; nsDeclaration != null && nsDeclaration.getLevel() == n; nsDeclaration = nsDeclaration.getPrev()) {
                String string2 = nsDeclaration.getPrefix();
                contentHandler.endPrefixMapping(string2 == null ? "" : string2);
            }
        }
    }

    public void fireSaxCharacterEvents(ContentHandler contentHandler) throws XMLStreamException, SAXException {
        if (contentHandler != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCharacterEvents(contentHandler);
        }
    }

    public void fireSaxSpaceEvents(ContentHandler contentHandler) throws XMLStreamException, SAXException {
        if (contentHandler != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxSpaceEvents(contentHandler);
        }
    }

    public void fireSaxCommentEvent(LexicalHandler lexicalHandler) throws XMLStreamException, SAXException {
        if (lexicalHandler != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCommentEvent(lexicalHandler);
        }
    }

    public void fireSaxPIEvent(ContentHandler contentHandler) throws XMLStreamException, SAXException {
        if (contentHandler != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            contentHandler.processingInstruction(this._tokenName.getLocalName(), this.getText());
        }
    }

    public final int getAttrCount() {
        return this._attrCount;
    }

    public final String getAttrLocalName(int n) {
        return this._attrCollector.getName(n).getLocalName();
    }

    public final QName getAttrQName(int n) {
        return this._attrCollector.getQName(n);
    }

    public final String getAttrPrefixedName(int n) {
        return this._attrCollector.getName(n).getPrefixedName();
    }

    public final String getAttrNsURI(int n) {
        return this._attrCollector.getName(n).getNsUri();
    }

    public final String getAttrPrefix(int n) {
        return this._attrCollector.getName(n).getPrefix();
    }

    public final String getAttrValue(int n) {
        return this._attrCollector.getValue(n);
    }

    public final String getAttrValue(String string, String string2) {
        if (this._attrCount < 1) {
            return null;
        }
        return this._attrCollector.getValue(string, string2);
    }

    public final void decodeAttrValue(int n, TypedValueDecoder typedValueDecoder) throws XMLStreamException {
        this._attrCollector.decodeValue(n, typedValueDecoder);
    }

    public final int decodeAttrValues(int n, TypedArrayDecoder typedArrayDecoder) throws XMLStreamException {
        return this._attrCollector.decodeValues(n, typedArrayDecoder, this);
    }

    public final byte[] decodeAttrBinaryValue(int n, Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder) throws XMLStreamException {
        return this._attrCollector.decodeBinaryValue(n, base64Variant, charArrayBase64Decoder, this);
    }

    public final int findAttrIndex(String string, String string2) {
        if (this._attrCount < 1) {
            return -1;
        }
        return this._attrCollector.findIndex(string, string2);
    }

    public final String getAttrType(int n) {
        return "CDATA";
    }

    public final boolean isAttrSpecified(int n) {
        return true;
    }

    public final int getNsCount() {
        if (this._currToken == 1) {
            return this._currNsCount;
        }
        return this._lastNsDecl == null ? 0 : this._lastNsDecl.countDeclsOnLevel(this._depth);
    }

    public final String getNamespacePrefix(int n) {
        return this.findCurrNsDecl((int)n).getBinding().mPrefix;
    }

    public final String getNamespaceURI(int n) {
        return this.findCurrNsDecl((int)n).getBinding().mURI;
    }

    private NsDeclaration findCurrNsDecl(int n) {
        int n2;
        NsDeclaration nsDeclaration = this._lastNsDecl;
        int n3 = this._depth;
        if (this._currToken == 1) {
            n2 = this._currNsCount - 1 - n;
            --n3;
        } else {
            n2 = n;
        }
        while (nsDeclaration != null && nsDeclaration.getLevel() == n3) {
            if (n2 == 0) {
                return nsDeclaration;
            }
            --n2;
            nsDeclaration = nsDeclaration.getPrev();
        }
        this.reportInvalidNsIndex(n);
        return null;
    }

    public final String getNamespaceURI() {
        String string = this._tokenName.getNsUri();
        return string == null ? this._defaultNs.mURI : string;
    }

    public final NamespaceContext getNonTransientNamespaceContext() {
        this._lastNsContext = this._lastNsContext.reuseOrCreate(this._lastNsDecl);
        return this._lastNsContext;
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (string.length() == 0) {
            String string2 = this._defaultNs.mURI;
            return string2 == null ? "" : string2;
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (NsDeclaration nsDeclaration = this._lastNsDecl; nsDeclaration != null; nsDeclaration = nsDeclaration.getPrev()) {
            if (!nsDeclaration.hasPrefix(string)) continue;
            return nsDeclaration.getCurrNsURI();
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (string.equals(this._defaultNs.mURI)) {
            return "";
        }
        block0: for (NsDeclaration nsDeclaration = this._lastNsDecl; nsDeclaration != null; nsDeclaration = nsDeclaration.getPrev()) {
            String string2;
            if (!nsDeclaration.hasNsURI(string) || (string2 = nsDeclaration.getPrefix()) == null) continue;
            for (NsDeclaration nsDeclaration2 = this._lastNsDecl; nsDeclaration2 != nsDeclaration; nsDeclaration2 = nsDeclaration2.getPrev()) {
                if (nsDeclaration2.hasPrefix(string2)) continue block0;
            }
            return string2;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        ArrayList<String> arrayList = null;
        if (string.equals(this._defaultNs.mURI)) {
            arrayList = new ArrayList<String>();
            arrayList.add("");
        }
        block0: for (NsDeclaration nsDeclaration = this._lastNsDecl; nsDeclaration != null; nsDeclaration = nsDeclaration.getPrev()) {
            String string2;
            if (!nsDeclaration.hasNsURI(string) || (string2 = nsDeclaration.getPrefix()) == null) continue;
            for (NsDeclaration nsDeclaration2 = this._lastNsDecl; nsDeclaration2 != nsDeclaration; nsDeclaration2 = nsDeclaration2.getPrev()) {
                if (nsDeclaration2.hasPrefix(string2)) continue block0;
            }
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(string2);
        }
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        if (arrayList.size() == 1) {
            return new SingletonIterator((String)arrayList.get(0));
        }
        return arrayList.iterator();
    }

    protected abstract void finishCharacters() throws XMLStreamException;

    protected abstract void finishCData() throws XMLStreamException;

    protected abstract void finishComment() throws XMLStreamException;

    protected abstract void finishDTD(boolean var1) throws XMLStreamException;

    protected abstract void finishPI() throws XMLStreamException;

    protected abstract void finishSpace() throws XMLStreamException;

    protected abstract boolean skipCharacters() throws XMLStreamException;

    protected abstract void skipCData() throws XMLStreamException;

    protected abstract void skipComment() throws XMLStreamException;

    protected abstract void skipPI() throws XMLStreamException;

    protected abstract void skipSpace() throws XMLStreamException;

    protected abstract boolean skipCoalescedText() throws XMLStreamException;

    protected abstract boolean loadMore() throws XMLStreamException;

    protected final PName bindName(PName pName, String string) {
        PName pName2;
        if (this._nsBindingCache != null && (pName2 = this._nsBindingCache[pName.unboundHashCode() & 0x3F]) != null && pName2.unboundEquals(pName)) {
            return pName2;
        }
        int n = this._nsBindingCount;
        for (int i = 0; i < n; ++i) {
            NsBinding nsBinding = this._nsBindings[i];
            if (nsBinding.mPrefix != string) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = nsBinding;
            }
            PName pName3 = pName.createBoundName(nsBinding);
            if (this._nsBindingCache == null) {
                if (++this._nsBindMisses < 10) {
                    return pName3;
                }
                this._nsBindingCache = new PName[64];
            }
            this._nsBindingCache[pName3.unboundHashCode() & 0x3F] = pName3;
            return pName3;
        }
        if (string == "xml") {
            return pName.createBoundName(NsBinding.XML_BINDING);
        }
        ++this._nsBindMisses;
        NsBinding nsBinding = new NsBinding(string);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = nsBinding;
        ++this._nsBindingCount;
        return pName.createBoundName(nsBinding);
    }

    protected final NsBinding findOrCreateBinding(String string) throws XMLStreamException {
        int n = this._nsBindingCount;
        for (int i = 0; i < n; ++i) {
            NsBinding nsBinding = this._nsBindings[i];
            if (nsBinding.mPrefix != string) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = nsBinding;
            }
            return nsBinding;
        }
        if (string == "xml") {
            return NsBinding.XML_BINDING;
        }
        if (string == "xmlns") {
            return NsBinding.XMLNS_BINDING;
        }
        NsBinding nsBinding = new NsBinding(string);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = nsBinding;
        ++this._nsBindingCount;
        return nsBinding;
    }

    protected final void bindNs(PName pName, String string) throws XMLStreamException {
        NsBinding nsBinding;
        String string2 = pName.getPrefix();
        if (string2 == null) {
            nsBinding = this._defaultNs;
        } else {
            string2 = pName.getLocalName();
            nsBinding = this.findOrCreateBinding(string2);
            if (nsBinding.isImmutable()) {
                this.checkImmutableBinding(string2, string);
            }
        }
        if (!nsBinding.isImmutable()) {
            if (string == "http://www.w3.org/XML/1998/namespace") {
                this.reportIllegalNsDecl("xml", "http://www.w3.org/XML/1998/namespace");
            } else if (string == "http://www.w3.org/2000/xmlns/") {
                this.reportIllegalNsDecl("xmlns", "http://www.w3.org/2000/xmlns/");
            }
        }
        if (this._lastNsDecl != null && this._lastNsDecl.alreadyDeclared(string2, this._depth)) {
            this.reportDuplicateNsDecl(string2);
        }
        this._lastNsDecl = new NsDeclaration(nsBinding, string, this._lastNsDecl, this._depth);
    }

    protected final void checkImmutableBinding(String string, String string2) throws XMLStreamException {
        if (string != "xml" || !string2.equals("http://www.w3.org/XML/1998/namespace")) {
            this.reportIllegalNsDecl(string);
        }
    }

    protected final void loadMoreGuaranteed() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
    }

    protected final void loadMoreGuaranteed(int n) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n));
        }
    }

    protected final void verifyXmlChar(int n) throws XMLStreamException {
        if (n >= 55296) {
            if (n < 57344) {
                this.reportInvalidXmlChar(n);
            }
            if (n == 65534 || n == 65535) {
                this.reportInvalidXmlChar(n);
            }
        } else if (!(n >= 32 || n == 10 || n == 13 || n == 9 || this._xml11 && n != 0)) {
            this.reportInvalidXmlChar(n);
        }
    }

    protected void reportInputProblem(String string) throws XMLStreamException {
        throw new WFCException(string, (Location)this.getCurrentLocation());
    }

    protected void reportUnexpandedEntityInAttr(PName pName, boolean bl) throws XMLStreamException {
        this.reportInputProblem("Unexpanded ENTITY_REFERENCE (" + this._tokenName + ") in " + (bl ? "namespace declaration" : "attribute value"));
    }

    protected void reportPrologUnexpChar(boolean bl, int n, String string) throws XMLStreamException {
        String string2;
        String string3 = string2 = bl ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        if (string == null) {
            if (n == 38) {
                this.throwUnexpectedChar(n, string2 + "; no entities allowed");
            }
        } else {
            string2 = string2 + string;
        }
        this.throwUnexpectedChar(n, string2);
    }

    protected void reportPrologProblem(boolean bl, String string) throws XMLStreamException {
        String string2 = bl ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        this.reportInputProblem(string2 + ": " + string);
    }

    protected void reportTreeUnexpChar(int n, String string) throws XMLStreamException {
        String string2 = ErrorConsts.SUFFIX_IN_TREE;
        if (string != null) {
            string2 = string2 + string;
        }
        this.throwUnexpectedChar(n, string2);
    }

    protected void reportInvalidNameChar(int n, int n2) throws XMLStreamException {
        if (n == 58) {
            this.reportInputProblem("Invalid colon in name: at most one colon allowed in element/attribute names, and none in PI target or entity names");
        }
        if (n2 == 0) {
            this.reportInputProblem("Invalid name start character (0x" + Integer.toHexString(n) + ")");
        }
        this.reportInputProblem("Invalid name character (0x" + Integer.toHexString(n) + ")");
    }

    protected void reportInvalidXmlChar(int n) throws XMLStreamException {
        if (n == 0) {
            this.reportInputProblem("Invalid null character");
        }
        if (n < 32) {
            this.reportInputProblem("Invalid white space character (0x" + Integer.toHexString(n) + ")");
        }
        this.reportInputProblem("Invalid xml content character (0x" + Integer.toHexString(n) + ")");
    }

    protected void reportEofInName(char[] cArray, int n) throws XMLStreamException {
        this.reportInputProblem("Unexpected end-of-input in name (parsing " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    protected void reportMissingPISpace(int n) throws XMLStreamException {
        this.throwUnexpectedChar(n, ": expected either white space, or closing '?>'");
    }

    protected void reportDoubleHyphenInComments() throws XMLStreamException {
        this.reportInputProblem("String '--' not allowed in comment (missing '>'?)");
    }

    protected void reportMultipleColonsInName() throws XMLStreamException {
        this.reportInputProblem("Multiple colons not allowed in names");
    }

    protected void reportEntityOverflow() throws XMLStreamException {
        this.reportInputProblem("Illegal character entity: value higher than max allowed (0x" + Integer.toHexString(0x10FFFF) + ")");
    }

    protected void reportInvalidNsIndex(int n) {
        throw new IndexOutOfBoundsException("Illegal namespace declaration index, " + n + ", current START_ELEMENT/END_ELEMENT has " + this.getNsCount() + " declarations");
    }

    protected void reportUnboundPrefix(PName pName, boolean bl) throws XMLStreamException {
        this.reportInputProblem("Unbound namespace prefix '" + pName.getPrefix() + "' (for " + (bl ? "attribute" : "element") + " name '" + pName.getPrefixedName() + "')");
    }

    protected void reportDuplicateNsDecl(String string) throws XMLStreamException {
        if (string == null) {
            this.reportInputProblem("Duplicate namespace declaration for the default namespace");
        } else {
            this.reportInputProblem("Duplicate namespace declaration for prefix '" + string + "'");
        }
    }

    protected void reportIllegalNsDecl(String string) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not re-bind prefix '" + string + "'");
    }

    protected void reportIllegalNsDecl(String string, String string2) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not bind URI '" + string2 + "' to prefix other than '" + string + "'");
    }

    protected void reportUnexpectedEndTag(String string) throws XMLStreamException {
        this.reportInputProblem("Unexpected end tag: expected </" + string + ">");
    }

    protected void reportIllegalCDataEnd() throws XMLStreamException {
        this.reportInputProblem("String ']]>' not allowed in textual content, except as the end marker of CDATA section");
    }

    protected void throwUnexpectedChar(int n, String string) throws XMLStreamException {
        if (n < 32 && n != 13 && n != 10 && n != 9) {
            this.throwInvalidSpace(n);
        }
        char c = (char)n;
        String string2 = "Unexpected character " + XmlChars.getCharDesc(c) + string;
        this.reportInputProblem(string2);
    }

    protected void throwNullChar() throws XMLStreamException {
        this.reportInputProblem("Illegal character (NULL, unicode 0) encountered: not valid in any content");
    }

    protected char handleInvalidXmlChar(int n) throws XMLStreamException {
        IllegalCharHandler illegalCharHandler = this._config.getIllegalCharHandler();
        if (illegalCharHandler != null) {
            return illegalCharHandler.convertIllegalChar(n);
        }
        char c = (char)n;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        String string = "Illegal XML character (" + XmlChars.getCharDesc(c) + ")";
        if (this._xml11 && n < 32) {
            string = string + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(string);
        return (char)n;
    }

    protected void throwInvalidSpace(int n) throws XMLStreamException {
        char c = (char)n;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        String string = "Illegal character (" + XmlChars.getCharDesc(c) + ")";
        if (this._xml11 && n < 32) {
            string = string + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(string);
    }
}

