/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameFactory;
import com.fasterxml.aalto.util.NameTable;
import javax.xml.stream.XMLStreamException;

public final class WNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    final WNameFactory mNameFactory;
    final WNameTable mParent;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private WName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    protected WNameTable(int n) {
        this.mNameFactory = null;
        this.mParent = null;
        if (n < 16) {
            n = 16;
        } else if ((n & n - 1) != 0) {
            int n2;
            for (n2 = 16; n2 < n; n2 += n2) {
            }
            n = n2;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = n - 1;
        this.mMainHash = new int[n];
        this.mMainNames = new WName[n];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    private WNameTable(WNameTable wNameTable, WNameFactory wNameFactory) {
        this.mParent = wNameTable;
        this.mNameFactory = wNameFactory;
        this.mCount = wNameTable.mCount;
        this.mMainHashMask = wNameTable.mMainHashMask;
        this.mMainHash = wNameTable.mMainHash;
        this.mMainNames = wNameTable.mMainNames;
        this.mCollList = wNameTable.mCollList;
        this.mCollCount = wNameTable.mCollCount;
        this.mCollEnd = wNameTable.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    protected synchronized WNameTable createChild(WNameFactory wNameFactory) {
        return new WNameTable(this, wNameFactory);
    }

    public boolean mergeToParent() {
        boolean bl = this.mParent.mergeFromChild(this);
        this.markAsShared();
        return bl;
    }

    private synchronized boolean mergeFromChild(WNameTable wNameTable) {
        if (wNameTable.mCount <= this.mCount) {
            return false;
        }
        this.mCount = wNameTable.mCount;
        this.mMainHashMask = wNameTable.mMainHashMask;
        this.mMainHash = wNameTable.mMainHash;
        this.mMainNames = wNameTable.mMainNames;
        this.mCollList = wNameTable.mCollList;
        this.mCollCount = wNameTable.mCollCount;
        this.mCollEnd = wNameTable.mCollEnd;
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public void nuke() {
        this.mMainHash = null;
        this.mMainNames = null;
        this.mCollList = null;
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public WName findSymbol(String string) throws XMLStreamException {
        WName wName;
        Object object;
        int n = string.hashCode();
        int n2 = n & this.mMainHashMask;
        int n3 = this.mMainHash[n2];
        if ((n3 >> 8 ^ n) << 8 == 0 && (object = this.mMainNames[n2]) != null && ((WName)object).hasName(string)) {
            return object;
        }
        if (n3 != 0 && (n3 &= 0xFF) > 0 && (object = this.mCollList[--n3]) != null && (wName = ((Bucket)object).find(string)) != null) {
            return wName;
        }
        object = this.mNameFactory.constructName(string);
        this.addSymbol((WName)object);
        return object;
    }

    public WName findSymbol(String string, String string2) throws XMLStreamException {
        WName wName;
        Object object;
        int n = string2.hashCode() ^ string.hashCode();
        int n2 = n & this.mMainHashMask;
        int n3 = this.mMainHash[n2];
        if ((n3 >> 8 ^ n) << 8 == 0 && (object = this.mMainNames[n2]) != null && ((WName)object).hasName(string, string2)) {
            return object;
        }
        if (n3 != 0 && (n3 &= 0xFF) > 0 && (object = this.mCollList[--n3]) != null && (wName = ((Bucket)object).find(string, string2)) != null) {
            return wName;
        }
        object = this.mNameFactory.constructName(string, string2);
        this.addSymbol((WName)object);
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[WNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.mCollCount);
        stringBuilder.append(" coll; avg length: ");
        int n = this.mCount;
        for (int i = 0; i < this.mCollEnd; ++i) {
            int n2 = this.mCollList[i].length();
            for (int j = 1; j <= n2; ++j) {
                n += j;
            }
        }
        double d = this.mCount == 0 ? 0.0 : (double)n / (double)this.mCount;
        stringBuilder.append(d);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toDebugString() {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[WNameTable, size: ");
        stringBuilder.append(this.mCount);
        stringBuilder.append('/');
        stringBuilder.append(this.mMainHash.length);
        stringBuilder.append(" -> ");
        for (n = 0; n < this.mMainHash.length; ++n) {
            stringBuilder.append("\n#");
            stringBuilder.append(n);
            stringBuilder.append(": 0x");
            stringBuilder.append(Integer.toHexString(this.mMainHash[n]));
            stringBuilder.append(" == ");
            object = this.mMainNames[n];
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append('\"');
            stringBuilder.append(((WName)object).toString());
            stringBuilder.append('\"');
        }
        stringBuilder.append("\nSpill(");
        stringBuilder.append(this.mCollEnd);
        stringBuilder.append("):");
        for (n = 0; n < this.mCollEnd; ++n) {
            object = this.mCollList[n];
            stringBuilder.append("\nsp#");
            stringBuilder.append(n);
            stringBuilder.append(": ");
            stringBuilder.append(((Bucket)object).toDebugString());
        }
        return stringBuilder.toString();
    }

    private void addSymbol(WName wName) {
        int n;
        int n2;
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        int n3 = wName.hashCode();
        ++this.mCount;
        int n4 = n3 & this.mMainHashMask;
        if (this.mMainNames[n4] == null) {
            this.mMainHash[n4] = n3 << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[n4] = wName;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            n2 = this.mMainHash[n4];
            n = n2 & 0xFF;
            if (n == 0) {
                if (this.mCollEnd <= 254) {
                    if ((n = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    n = this.findBestBucket();
                }
                this.mMainHash[n4] = n2 & 0xFFFFFF00 | n + 1;
            } else {
                --n;
            }
            this.mCollList[n] = new Bucket(wName, this.mCollList[n]);
        }
        n2 = this.mMainHash.length;
        if (this.mCount > n2 >> 1) {
            n = n2 >> 2;
            if (this.mCount > n2 - n) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= n) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        int n;
        Bucket[] bucketArray;
        int n2;
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int n3 = 0;
        int[] nArray = this.mMainHash;
        int n4 = nArray.length;
        this.mMainHash = new int[n4 + n4];
        this.mMainHashMask = n4 + n4 - 1;
        WName[] wNameArray = this.mMainNames;
        this.mMainNames = new WName[n4 + n4];
        for (n2 = 0; n2 < n4; ++n2) {
            bucketArray = wNameArray[n2];
            if (bucketArray == null) continue;
            ++n3;
            n = bucketArray.hashCode();
            int n5 = n & this.mMainHashMask;
            this.mMainNames[n5] = bucketArray;
            this.mMainHash[n5] = n << 8;
        }
        n2 = this.mCollEnd;
        if (n2 == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        bucketArray = this.mCollList;
        this.mCollList = new Bucket[bucketArray.length];
        for (n = 0; n < n2; ++n) {
            Bucket bucket = bucketArray[n];
            while (bucket != null) {
                ++n3;
                WName wName = bucket.mName;
                int n6 = wName.hashCode();
                int n7 = n6 & this.mMainHashMask;
                int n8 = this.mMainHash[n7];
                if (this.mMainNames[n7] == null) {
                    this.mMainHash[n7] = n6 << 8;
                    this.mMainNames[n7] = wName;
                } else {
                    ++this.mCollCount;
                    int n9 = n8 & 0xFF;
                    if (n9 == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((n9 = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n9 = this.findBestBucket();
                        }
                        this.mMainHash[n7] = n8 & 0xFFFFFF00 | n9 + 1;
                    } else {
                        --n9;
                    }
                    this.mCollList[n9] = new Bucket(wName, this.mCollList[n9]);
                }
                bucket = bucket.mNext;
            }
        }
        if (n3 != this.mCount) {
            throw new Error("Internal error: count after rehash " + n3 + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this.mCollList;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = this.mCollEnd;
        for (int i = 0; i < n3; ++i) {
            int n4 = bucketArray[i].length();
            if (n4 >= n) continue;
            if (n4 == 1) {
                return i;
            }
            n = n4;
            n2 = i;
        }
        return n2;
    }

    private void unshareMain() {
        int[] nArray = this.mMainHash;
        int n = this.mMainHash.length;
        this.mMainHash = new int[n];
        System.arraycopy(nArray, 0, this.mMainHash, 0, n);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this.mCollList;
        if (bucketArray == null) {
            this.mCollList = new Bucket[32];
        } else {
            int n = bucketArray.length;
            this.mCollList = new Bucket[n];
            System.arraycopy(bucketArray, 0, this.mCollList, 0, n);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        WName[] wNameArray = this.mMainNames;
        int n = wNameArray.length;
        this.mMainNames = new WName[n];
        System.arraycopy(wNameArray, 0, this.mMainNames, 0, n);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this.mCollList;
        int n = bucketArray.length;
        this.mCollList = new Bucket[n + n];
        System.arraycopy(bucketArray, 0, this.mCollList, 0, n);
    }

    static final class Bucket {
        final WName mName;
        final Bucket mNext;

        Bucket(WName wName, Bucket bucket) {
            this.mName = wName;
            this.mNext = bucket;
        }

        public int length() {
            int n = 1;
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ++n;
                bucket = bucket.mNext;
            }
            return n;
        }

        public WName find(String string) {
            if (this.mName.hasName(string)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                WName wName = bucket.mName;
                if (wName.hasName(string)) {
                    return wName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public WName find(String string, String string2) {
            if (this.mName.hasName(string, string2)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                WName wName = bucket.mName;
                if (wName.hasName(string, string2)) {
                    return wName;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public String toDebugString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[Bucket(");
            stringBuilder.append(this.length());
            stringBuilder.append("): ");
            Bucket bucket = this;
            while (bucket != null) {
                stringBuilder.append('\"');
                stringBuilder.append(bucket.mName.toString());
                stringBuilder.append("\" -> ");
                bucket = bucket.mNext;
            }
            stringBuilder.append("NULL]");
            return stringBuilder.toString();
        }
    }
}

