/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.producer.AbstractProducer;
import org.jboss.weld.injection.producer.DefaultInjector;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.DefaultLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class BasicInjectionTarget<T>
extends AbstractProducer<T>
implements InjectionTarget<T> {
    protected final BeanManagerImpl beanManager;
    private final SlimAnnotatedType<T> type;
    private final Set<InjectionPoint> injectionPoints;
    private Instantiator<T> instantiator;
    private final Injector<T> injector;
    private final LifecycleCallbackInvoker<T> invoker;

    public BasicInjectionTarget(EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
        this(type, null, beanManager);
    }

    public BasicInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.type = type.slim();
        HashSet<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
        this.checkType(type);
        this.injector = this.initInjector(type, bean, beanManager);
        this.injector.registerInjectionPoints(injectionPoints);
        this.instantiator = this.initInstantiator(type, bean, beanManager, injectionPoints);
        this.injectionPoints = WeldCollections.immutableSet(injectionPoints);
        this.checkDelegateInjectionPoints();
        this.invoker = this.initInvoker(type);
    }

    protected void checkType(EnhancedAnnotatedType<T> type) {
        if (Reflections.isNonStaticInnerClass(type.getJavaClass())) {
            throw BeanLogger.LOG.simpleBeanAsNonStaticInnerClassNotAllowed(type);
        }
    }

    public T produce(CreationalContext<T> ctx) {
        return this.instantiator.newInstance(ctx, this.beanManager);
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.injector.inject(instance, ctx, this.beanManager, this.type, this);
    }

    public void postConstruct(T instance) {
        this.invoker.postConstruct(instance, this.instantiator);
    }

    public void preDestroy(T instance) {
        this.invoker.preDestroy(instance, this.instantiator);
    }

    public void dispose(T instance) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected SlimAnnotatedType<T> getType() {
        return this.type;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public Instantiator<T> getInstantiator() {
        return this.instantiator;
    }

    public void setInstantiator(Instantiator<T> instantiator) {
        this.instantiator = instantiator;
    }

    public boolean hasInterceptors() {
        return this.instantiator.hasInterceptorSupport();
    }

    public boolean hasDecorators() {
        return this.instantiator.hasDecoratorSupport();
    }

    protected void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
    }

    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type, bean, beanManager);
        injectionPoints.addAll(instantiator.getParameterInjectionPoints());
        return instantiator;
    }

    protected Injector<T> initInjector(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        return new DefaultInjector<T>(type, bean, beanManager);
    }

    protected LifecycleCallbackInvoker<T> initInvoker(EnhancedAnnotatedType<T> type) {
        return new DefaultLifecycleCallbackInvoker<T>(type);
    }

    public AnnotatedType<T> getAnnotated() {
        return this.type;
    }

    public Injector<T> getInjector() {
        return this.injector;
    }

    public LifecycleCallbackInvoker<T> getLifecycleCallbackInvoker() {
        return this.invoker;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("InjectionTarget for ");
        if (this.getBean() == null) {
            result.append(this.getAnnotated());
        } else {
            result.append(this.getBean());
        }
        return result.toString();
    }

    @Override
    public Bean<T> getBean() {
        return null;
    }
}

