/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;

public abstract class ByteBasedScanner
extends XmlScanner {
    protected static final byte BYTE_NULL = 0;
    protected static final byte BYTE_SPACE = 32;
    protected static final byte BYTE_LF = 10;
    protected static final byte BYTE_CR = 13;
    protected static final byte BYTE_TAB = 9;
    protected static final byte BYTE_LT = 60;
    protected static final byte BYTE_GT = 62;
    protected static final byte BYTE_AMP = 38;
    protected static final byte BYTE_HASH = 35;
    protected static final byte BYTE_EXCL = 33;
    protected static final byte BYTE_HYPHEN = 45;
    protected static final byte BYTE_QMARK = 63;
    protected static final byte BYTE_SLASH = 47;
    protected static final byte BYTE_EQ = 61;
    protected static final byte BYTE_QUOT = 34;
    protected static final byte BYTE_APOS = 39;
    protected static final byte BYTE_LBRACKET = 91;
    protected static final byte BYTE_RBRACKET = 93;
    protected static final byte BYTE_SEMICOLON = 59;
    protected static final byte BYTE_a = 97;
    protected static final byte BYTE_g = 103;
    protected static final byte BYTE_l = 108;
    protected static final byte BYTE_m = 109;
    protected static final byte BYTE_o = 111;
    protected static final byte BYTE_p = 112;
    protected static final byte BYTE_q = 113;
    protected static final byte BYTE_s = 115;
    protected static final byte BYTE_t = 116;
    protected static final byte BYTE_u = 117;
    protected static final byte BYTE_x = 120;
    protected static final byte BYTE_A = 65;
    protected static final byte BYTE_C = 67;
    protected static final byte BYTE_D = 68;
    protected static final byte BYTE_P = 80;
    protected static final byte BYTE_S = 83;
    protected static final byte BYTE_T = 84;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int[] _quadBuffer = new int[32];
    protected final ByteBasedPNameTable _symbols;
    protected final XmlCharTypes _charTypes;
    protected int _pastBytes;
    protected int _rowStartOffset;
    protected int _tmpChar = 0;

    protected ByteBasedScanner(ReaderConfig readerConfig) {
        super(readerConfig);
        this._symbols = readerConfig.getBBSymbols();
        this._charTypes = readerConfig.getCharTypes();
        this._pastBytes = 0;
        this._rowStartOffset = 0;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateBBSymbols(this._symbols);
        }
    }

    @Override
    protected abstract void _closeSource() throws IOException;

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._pastBytes + this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    @Override
    public int getCurrentLineNr() {
        return this._currRow + 1;
    }

    @Override
    public int getCurrentColumnNr() {
        return this._inputPtr - this._rowStartOffset;
    }

    protected final void markLF(int n) {
        this._rowStartOffset = n;
        ++this._currRow;
    }

    protected final void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    protected abstract int decodeCharForError(byte var1) throws XMLStreamException;

    protected abstract PName addPName(int var1, int[] var2, int var3, int var4) throws XMLStreamException;

    protected final PName addUtfPName(XmlCharTypes xmlCharTypes, int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        int n4;
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n7 = nArray[n2 - 1];
            nArray[n2 - 1] = n7 << (4 - n3 << 3);
        } else {
            n7 = 0;
        }
        int n9 = nArray[0] >>> 24;
        int n10 = 1;
        char[] cArray = this._nameBuffer;
        int n11 = 0;
        int[] nArray2 = xmlCharTypes.NAME_CHARS;
        switch (nArray2[n9]) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                if ((n9 & 0xE0) == 192) {
                    n9 &= 0x1F;
                    n6 = 1;
                } else if ((n9 & 0xF0) == 224) {
                    n9 &= 0xF;
                    n6 = 2;
                } else if ((n9 & 0xF8) == 240) {
                    n9 &= 7;
                    n6 = 3;
                } else {
                    this.reportInvalidInitial(n9);
                    n9 = 1;
                    n6 = 1;
                }
                if (n10 + n6 > n8) {
                    this.reportEofInName(cArray, 0);
                }
                n10 += n6;
                n5 = nArray[0];
                n4 = n5 >> 16 & 0xFF;
                if ((n4 & 0xC0) != 128) {
                    this.reportInvalidOther(n4);
                }
                n9 = n9 << 6 | n4 & 0x3F;
                if (n6 > 1) {
                    n4 = n5 >> 8 & 0xFF;
                    if ((n4 & 0xC0) != 128) {
                        this.reportInvalidOther(n4);
                    }
                    n9 = n9 << 6 | n4 & 0x3F;
                    if (n6 > 2) {
                        n4 = n5 & 0xFF;
                        if ((n4 & 0xC0) != 128) {
                            this.reportInvalidOther(n4 & 0xFF);
                        }
                        n9 = n9 << 6 | n4 & 0x3F;
                    }
                }
                bl = XmlChars.is10NameStartChar(n9);
                if (n6 <= 2) break;
                cArray[n11++] = (char)(55296 + ((n9 -= 65536) >> 10));
                n9 = 0xDC00 | n9 & 0x3FF;
            }
        }
        if (!bl) {
            this.reportInvalidNameChar(n9, 0);
        }
        cArray[n11++] = (char)n9;
        n6 = -1;
        while (n10 < n8) {
            n9 = nArray[n10 >> 2];
            n5 = n10 & 3;
            n9 = n9 >> (3 - n5 << 3) & 0xFF;
            ++n10;
            switch (nArray2[n9]) {
                case 0: 
                case 4: {
                    bl = false;
                    break;
                }
                case 1: {
                    if (n6 >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    n6 = n11;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    if ((n9 & 0xE0) == 192) {
                        n9 &= 0x1F;
                        n4 = 1;
                    } else if ((n9 & 0xF0) == 224) {
                        n9 &= 0xF;
                        n4 = 2;
                    } else if ((n9 & 0xF8) == 240) {
                        n9 &= 7;
                        n4 = 3;
                    } else {
                        this.reportInvalidInitial(n9);
                        n9 = 1;
                        n4 = 1;
                    }
                    if (n10 + n4 > n8) {
                        this.reportEofInName(cArray, n11);
                    }
                    int n12 = nArray[n10 >> 2];
                    n5 = n10 & 3;
                    ++n10;
                    if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                        this.reportInvalidOther(n12);
                    }
                    n9 = n9 << 6 | n12 & 0x3F;
                    if (n4 > 1) {
                        n12 = nArray[n10 >> 2];
                        n5 = n10 & 3;
                        ++n10;
                        if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                            this.reportInvalidOther(n12);
                        }
                        n9 = n9 << 6 | n12 & 0x3F;
                        if (n4 > 2) {
                            n12 = nArray[n10 >> 2];
                            n5 = n10 & 3;
                            ++n10;
                            if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                                this.reportInvalidOther(n12 & 0xFF);
                            }
                            n9 = n9 << 6 | n12 & 0x3F;
                        }
                    }
                    bl = XmlChars.is10NameChar(n9);
                    if (n4 <= 2) break;
                    n9 -= 65536;
                    if (n11 >= cArray.length) {
                        this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                    }
                    cArray[n11++] = (char)(55296 + (n9 >> 10));
                    n9 = 0xDC00 | n9 & 0x3FF;
                }
            }
            if (!bl) {
                this.reportInvalidNameChar(n9, n11);
            }
            if (n11 >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n11++] = (char)n9;
        }
        String string = new String(cArray, 0, n11);
        if (n3 < 4) {
            nArray[n2 - 1] = n7;
        }
        return this._symbols.addSymbol(n, string, n6, nArray, n2);
    }

    protected void reportInvalidInitial(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void reportInvalidOther(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }
}

