/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.ValidationException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.impl.StreamExceptionBase;
import com.fasterxml.aalto.out.OutputElement;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.TextUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.ri.Stax2WriterImpl;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import org.codehaus.stax2.ri.typed.ValueEncoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.ValidatorPair;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationProblem;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public abstract class StreamWriterBase
extends Stax2WriterImpl
implements NamespaceContext,
ValidationContext {
    protected final WriterConfig _config;
    protected NamespaceContext _rootNsContext;
    protected boolean _cfgCheckStructure;
    protected boolean _cfgCheckContent;
    protected boolean _cfgCheckAttrs;
    protected final boolean _cfgCDataAsText;
    protected WNameTable _symbols;
    protected final XmlWriter _xmlWriter;
    protected ValueEncoderFactory _valueEncoderFactory;
    protected XMLValidator _validator = null;
    protected int _vldContent = 4;
    protected ValidationProblemHandler _vldProblemHandler = null;
    protected State _state = State.PROLOG;
    protected OutputElement _currElem = OutputElement.createRoot();
    protected boolean _stateAnyOutput = false;
    protected boolean _stateStartElementOpen = false;
    protected boolean _stateEmptyElement = false;
    protected String _dtdRootElemName = null;
    protected OutputElement _outputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    protected int _poolSize = 0;

    protected StreamWriterBase(WriterConfig writerConfig, XmlWriter xmlWriter, WNameTable wNameTable) {
        this._config = writerConfig;
        this._xmlWriter = xmlWriter;
        this._symbols = wNameTable;
        this._cfgCheckStructure = writerConfig.willCheckStructure();
        this._cfgCheckContent = writerConfig.willCheckContent();
        this._cfgCheckAttrs = writerConfig.willCheckAttributes();
        this._cfgCDataAsText = false;
    }

    public void close() throws XMLStreamException {
        this._finishDocument(false);
    }

    public void flush() throws XMLStreamException {
        try {
            this._xmlWriter.flush();
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public final NamespaceContext getNamespaceContext() {
        return this;
    }

    public Object getProperty(String string) {
        return this._config.getProperty(string, true);
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        if (this._state != State.PROLOG) {
            StreamWriterBase.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this._rootNsContext = namespaceContext;
    }

    public final void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            this.setDefaultNamespace(string2);
            return;
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string.equals("xml")) {
            if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, string2);
            }
        } else if (string.equals("xmlns")) {
            if (!string2.equals("http://www.w3.org/2000/xmlns/")) {
                StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, string2);
            }
        } else if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, string);
        } else if (string2.equals("http://www.w3.org/2000/xmlns/")) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, string);
        }
        if (string2.length() == 0 && !this._config.isXml11()) {
            StreamWriterBase.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this._setPrefix(string, string2);
    }

    protected abstract void _setPrefix(String var1, String var2);

    public final void writeAttribute(String string, String string2) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            StreamWriterBase.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this._writeAttribute(this._symbols.findSymbol(string), string2);
    }

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeCData(String string) throws XMLStreamException {
        if (this._cfgCDataAsText) {
            this.writeCharacters(string);
            return;
        }
        this._verifyWriteCData();
        if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(string, false);
        }
        try {
            int n = this._xmlWriter.writeCData(string);
            if (n >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, n);
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(cArray, n, n2);
            return;
        }
        if (this._vldContent <= 1) {
            if (this._vldContent == 0) {
                this._reportInvalidContent(4);
            } else if (!TextUtil.isAllWhitespace(cArray, n, n2, this._config.isXml11())) {
                this._reportInvalidContent(4);
            }
        } else if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(cArray, n, n2, false);
        }
        if (n2 > 0) {
            try {
                this._xmlWriter.writeCharacters(cArray, n, n2);
            }
            catch (IOException iOException) {
                throw new IoStreamException(iOException);
            }
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this.inPrologOrEpilog()) {
            this.writeSpace(string);
            return;
        }
        if (this._vldContent <= 1) {
            if (this._vldContent == 0) {
                this._reportInvalidContent(4);
            } else if (!TextUtil.isAllWhitespace(string, this._config.isXml11())) {
                this._reportInvalidContent(4);
            }
        } else if (this._vldContent == 3 && this._validator != null) {
            this._validator.validateText(string, false);
        }
        try {
            this._xmlWriter.writeCharacters(string);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeComment(String string) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(5);
        }
        try {
            int n = this._xmlWriter.writeComment(string);
            if (n >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_COMMENT_CONTENT, n);
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public final void writeDTD(String string) throws XMLStreamException {
        this._verifyWriteDTD();
        this._dtdRootElemName = "";
        try {
            this._xmlWriter.writeDTD(string);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this._verifyStartElement(null, string);
        WName wName = this._symbols.findSymbol(string);
        if (this._validator != null) {
            this._validator.validateElementStart(string, "", "");
        }
        this._writeStartTag(wName, true);
    }

    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    public void writeEndDocument() throws XMLStreamException {
        this._finishDocument(false);
    }

    public void writeEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        if (this._state != State.TREE) {
            StreamWriterBase._reportNwfStructure("No open start element, when trying to write end element");
        }
        OutputElement outputElement = this._currElem;
        this._currElem = outputElement.getParent();
        if (this._poolSize < 8) {
            outputElement.addToPool(this._outputElemPool);
            this._outputElemPool = outputElement;
            ++this._poolSize;
        }
        if (this._cfgCheckStructure) {
            // empty if block
        }
        try {
            if (this._stateStartElementOpen) {
                this._stateStartElementOpen = false;
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeEndTag(outputElement.getName());
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        if (this._currElem.isRoot()) {
            this._state = State.EPILOG;
        }
        if (this._validator != null) {
            this._vldContent = this._validator.validateElementEnd(outputElement.getLocalName(), outputElement.getNonNullPrefix(), outputElement.getNonNullNamespaceURI());
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._cfgCheckStructure && this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_ENTITY);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(9);
        }
        try {
            this._xmlWriter.writeEntityReference(this._symbols.findSymbol(string));
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, null);
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._vldContent == 0) {
            this._reportInvalidContent(3);
        }
        try {
            int n = this._xmlWriter.writePI(this._symbols.findSymbol(string), string2);
            if (n >= 0) {
                StreamWriterBase._reportNwfContent(ErrorConsts.WERR_PI_CONTENT, n);
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        String string = this._config.getActualEncoding();
        if (string == null) {
            string = "UTF-8";
            this._config.setActualEncodingIfNotSet(string);
        }
        this._writeStartDocument("1.0", string, null);
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this._writeStartDocument(string, this._config.getActualEncoding(), null);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this._writeStartDocument(string2, string, null);
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this._verifyStartElement(null, string);
        WName wName = this._symbols.findSymbol(string);
        if (this._validator != null) {
            this._validator.validateElementStart(string, "", "");
        }
        this._writeStartTag(wName, false);
    }

    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public String getNamespaceURI(String string) {
        String string2 = this._currElem.getNamespaceURI(string);
        if (string2 == null && this._rootNsContext != null) {
            string2 = this._rootNsContext.getNamespaceURI(string);
        }
        return string2;
    }

    @Override
    public String getPrefix(String string) {
        String string2 = this._currElem.getPrefix(string);
        if (string2 == null && this._rootNsContext != null) {
            string2 = this._rootNsContext.getPrefix(string);
        }
        return string2;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return this._currElem.getPrefixes(string, this._rootNsContext);
    }

    public void writeBoolean(boolean bl) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(bl ? "true" : "false"));
    }

    public void writeInt(int n) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(n));
    }

    public void writeLong(long l) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(l));
    }

    public void writeFloat(float f) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(f));
    }

    public void writeDouble(double d) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(d));
    }

    public void writeInteger(BigInteger bigInteger) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(bigInteger.toString()));
    }

    public void writeDecimal(BigDecimal bigDecimal) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(bigDecimal.toString()));
    }

    public void writeQName(QName qName) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(this._serializeQName(qName)));
    }

    public final void writeIntArray(int[] nArray, int n, int n2) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(nArray, n, n2));
    }

    public void writeLongArray(long[] lArray, int n, int n2) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(lArray, n, n2));
    }

    public void writeFloatArray(float[] fArray, int n, int n2) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(fArray, n, n2));
    }

    public void writeDoubleArray(double[] dArray, int n, int n2) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(dArray, n, n2));
    }

    public void writeBinary(byte[] byArray, int n, int n2) throws XMLStreamException {
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(base64Variant, byArray, n, n2));
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws XMLStreamException {
        this.writeTypedElement((AsciiValueEncoder)this.valueEncoderFactory().getEncoder(base64Variant, byArray, n, n2));
    }

    private final void writeTypedElement(AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeTypedValue(asciiValueEncoder);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public final void writeBooleanAttribute(String string, String string2, String string3, boolean bl) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(bl));
    }

    public final void writeIntAttribute(String string, String string2, String string3, int n) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(n));
    }

    public final void writeLongAttribute(String string, String string2, String string3, long l) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(l));
    }

    public final void writeFloatAttribute(String string, String string2, String string3, float f) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(f));
    }

    public final void writeDoubleAttribute(String string, String string2, String string3, double d) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(d));
    }

    public final void writeIntegerAttribute(String string, String string2, String string3, BigInteger bigInteger) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(bigInteger.toString()));
    }

    public final void writeDecimalAttribute(String string, String string2, String string3, BigDecimal bigDecimal) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getScalarEncoder(bigDecimal.toString()));
    }

    public final void writeQNameAttribute(String string, String string2, String string3, QName qName) throws XMLStreamException {
        this.writeAttribute(string, string2, string3, this._serializeQName(qName));
    }

    public void writeIntArrayAttribute(String string, String string2, String string3, int[] nArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(nArray, 0, nArray.length));
    }

    public void writeLongArrayAttribute(String string, String string2, String string3, long[] lArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(lArray, 0, lArray.length));
    }

    public void writeFloatArrayAttribute(String string, String string2, String string3, float[] fArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(fArray, 0, fArray.length));
    }

    public void writeDoubleArrayAttribute(String string, String string2, String string3, double[] dArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(dArray, 0, dArray.length));
    }

    public void writeBinaryAttribute(String string, String string2, String string3, byte[] byArray) throws XMLStreamException {
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(base64Variant, byArray, 0, byArray.length));
    }

    public void writeBinaryAttribute(Base64Variant base64Variant, String string, String string2, String string3, byte[] byArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, (AsciiValueEncoder)this.valueEncoderFactory().getEncoder(base64Variant, byArray, 0, byArray.length));
    }

    public abstract void writeTypedAttribute(String var1, String var2, String var3, AsciiValueEncoder var4) throws XMLStreamException;

    protected abstract String _serializeQName(QName var1) throws XMLStreamException;

    public void writeSpace(String string) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(string);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeSpace(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            this._xmlWriter.writeSpace(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void closeCompletely() throws XMLStreamException {
        this._finishDocument(true);
    }

    public boolean isPropertySupported(String string) {
        return this._config.isPropertySupported(string);
    }

    public boolean setProperty(String string, Object object) {
        return this._config.setProperty(string, object);
    }

    public XMLValidator validateAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        XMLValidator xMLValidator = xMLValidationSchema.createValidator((ValidationContext)this);
        if (this._validator == null) {
            this._cfgCheckStructure = true;
            this._cfgCheckAttrs = true;
            this._validator = xMLValidator;
        } else {
            this._validator = new ValidatorPair(this._validator, xMLValidator);
        }
        return xMLValidator;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        XMLValidator xMLValidator = null;
        if (ValidatorPair.removeValidator((XMLValidator)this._validator, (XMLValidationSchema)xMLValidationSchema, (XMLValidator[])xMLValidatorArray)) {
            xMLValidator = xMLValidatorArray[0];
            this._validator = xMLValidatorArray[1];
            xMLValidator.validationCompleted(false);
            if (this._validator == null) {
                this.resetValidationFlags();
            }
        }
        return xMLValidator;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator xMLValidator) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        XMLValidator xMLValidator2 = null;
        if (ValidatorPair.removeValidator((XMLValidator)this._validator, (XMLValidator)xMLValidator, (XMLValidator[])xMLValidatorArray)) {
            xMLValidator2 = xMLValidatorArray[0];
            this._validator = xMLValidatorArray[1];
            xMLValidator2.validationCompleted(false);
            if (this._validator == null) {
                this.resetValidationFlags();
            }
        }
        return xMLValidator2;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler validationProblemHandler) {
        ValidationProblemHandler validationProblemHandler2 = this._vldProblemHandler;
        this._vldProblemHandler = validationProblemHandler;
        return validationProblemHandler2;
    }

    private void resetValidationFlags() {
        this._cfgCheckStructure = this._config.willCheckStructure();
        this._cfgCheckAttrs = this._config.willCheckAttributes();
    }

    public XMLStreamLocation2 getLocation() {
        return new LocationImpl(null, null, this._xmlWriter.getAbsOffset(), this._xmlWriter.getRow(), this._xmlWriter.getColumn());
    }

    public String getEncoding() {
        return this._config.getActualEncoding();
    }

    public void writeCData(char[] cArray, int n, int n2) throws XMLStreamException {
        int n3;
        if (this._cfgCDataAsText) {
            this.writeCharacters(cArray, n, n2);
            return;
        }
        this._verifyWriteCData();
        try {
            n3 = this._xmlWriter.writeCData(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        if (n3 >= 0) {
            StreamWriterBase._reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, n3);
        }
    }

    public void writeDTD(DTDInfo dTDInfo) throws XMLStreamException {
        this.writeDTD(dTDInfo.getDTDRootName(), dTDInfo.getDTDSystemId(), dTDInfo.getDTDPublicId(), dTDInfo.getDTDInternalSubset());
    }

    public void writeDTD(String string, String string2, String string3, String string4) throws XMLStreamException {
        this._verifyWriteDTD();
        this._dtdRootElemName = string;
        try {
            this._xmlWriter.writeDTD(this._symbols.findSymbol(string), string2, string3, string4);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeFullEndElement() throws XMLStreamException {
        if (this._stateStartElementOpen && this._stateEmptyElement) {
            this._stateEmptyElement = false;
            this._closeStartElement(true);
        }
        this.writeEndElement();
    }

    public void writeStartDocument(String string, String string2, boolean bl) throws XMLStreamException {
        this._writeStartDocument(string, string2, bl ? "yes" : "no");
    }

    public void writeRaw(String string) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(string, 0, string.length());
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeRaw(String string, int n, int n2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(string, n, n2);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public void writeRaw(char[] cArray, int n, int n2) throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        try {
            this._xmlWriter.writeRaw(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public String getXmlVersion() {
        return this._config.isXml11() ? "1.1" : "1.0";
    }

    public QName getCurrentElementName() {
        return this._currElem.getQName();
    }

    public String getBaseUri() {
        return null;
    }

    public Location getValidationLocation() {
        return this.getLocation();
    }

    public void reportProblem(XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        if (this._vldProblemHandler != null) {
            this._vldProblemHandler.reportProblem(xMLValidationProblem);
            return;
        }
        if (xMLValidationProblem.getSeverity() >= 2) {
            throw ValidationException.create(xMLValidationProblem);
        }
    }

    public int addDefaultAttribute(String string, String string2, String string3, String string4) {
        return -1;
    }

    public boolean isNotationDeclared(String string) {
        return false;
    }

    public boolean isUnparsedEntityDeclared(String string) {
        return false;
    }

    public int getAttributeCount() {
        return 0;
    }

    public String getAttributeLocalName(int n) {
        return null;
    }

    public String getAttributeNamespace(int n) {
        return null;
    }

    public String getAttributePrefix(int n) {
        return null;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public String getAttributeValue(String string, String string2) {
        return null;
    }

    public String getAttributeType(int n) {
        return "";
    }

    public int findAttributeIndex(String string, String string2) {
        return -1;
    }

    protected void _closeStartElement(boolean bl) throws XMLStreamException {
        this._stateStartElementOpen = false;
        try {
            if (bl) {
                this._xmlWriter.writeStartTagEmptyEnd();
            } else {
                this._xmlWriter.writeStartTagEnd();
            }
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        if (bl) {
            OutputElement outputElement = this._currElem;
            this._currElem = outputElement.getParent();
            if (this._currElem.isRoot()) {
                this._state = State.EPILOG;
            }
            if (this._poolSize < 8) {
                outputElement.addToPool(this._outputElemPool);
                this._outputElemPool = outputElement;
                ++this._poolSize;
            }
        }
    }

    protected final boolean inPrologOrEpilog() {
        return this._state != State.TREE;
    }

    protected final ValueEncoderFactory valueEncoderFactory() {
        if (this._valueEncoderFactory == null) {
            this._valueEncoderFactory = new ValueEncoderFactory();
        }
        return this._valueEncoderFactory;
    }

    protected final void _writeAttribute(WName wName, String string) throws XMLStreamException {
        if (this._cfgCheckAttrs) {
            this._verifyWriteAttr(wName);
        }
        try {
            this._xmlWriter.writeAttribute(wName, string);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final void _writeAttribute(WName wName, AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        if (this._cfgCheckAttrs) {
            this._verifyWriteAttr(wName);
        }
        try {
            this._xmlWriter.writeAttribute(wName, asciiValueEncoder);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final void _writeDefaultNamespace(String string) throws XMLStreamException {
        WName wName = this._symbols.findSymbol("xmlns");
        try {
            this._xmlWriter.writeAttribute(wName, string);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final void _writeNamespace(String string, String string2) throws XMLStreamException {
        WName wName = this._symbols.findSymbol("xmlns", string);
        try {
            this._xmlWriter.writeAttribute(wName, string2);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected void _writeStartDocument(String string, String string2, String string3) throws XMLStreamException {
        if (this._cfgCheckStructure && this._stateAnyOutput) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_DUP_XML_DECL);
        }
        this._stateAnyOutput = true;
        if (this._cfgCheckContent && string != null && string.length() > 0 && !string.equals("1.0") && !string.equals("1.1")) {
            StreamWriterBase._reportNwfContent("Illegal version argument ('" + string + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (string == null || string.length() == 0) {
            string = "1.0";
        }
        if ("1.1".equals(string)) {
            this._config.enableXml11();
            this._xmlWriter.enableXml11();
        }
        if (string2 != null && string2.length() > 0) {
            this._config.setActualEncodingIfNotSet(string2);
        }
        try {
            this._xmlWriter.writeXmlDeclaration(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected void _writeStartTag(WName wName, boolean bl) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (this._outputElemPool != null) {
            OutputElement outputElement = this._outputElemPool;
            this._outputElemPool = outputElement.reuseAsChild(this._currElem, wName);
            --this._poolSize;
            this._currElem = outputElement;
        } else {
            this._currElem = this._currElem.createChild(wName);
        }
        try {
            this._xmlWriter.writeStartTagStart(wName);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        this._stateEmptyElement = bl;
    }

    protected void _writeStartTag(WName wName, boolean bl, String string) throws XMLStreamException {
        this._stateAnyOutput = true;
        this._stateStartElementOpen = true;
        if (string == null) {
            string = "";
        }
        if (this._outputElemPool != null) {
            OutputElement outputElement = this._outputElemPool;
            this._outputElemPool = outputElement.reuseAsChild(this._currElem, wName, string);
            --this._poolSize;
            this._currElem = outputElement;
        } else {
            this._currElem = this._currElem.createChild(wName, string);
        }
        try {
            this._xmlWriter.writeStartTagStart(wName);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        this._stateEmptyElement = bl;
    }

    protected final void _verifyWriteAttr(WName wName) {
    }

    protected void _verifyStartElement(String string, String string2) throws XMLStreamException {
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        } else if (this._state == State.PROLOG) {
            this._verifyRootElement(string, string2);
        } else if (this._state == State.EPILOG) {
            if (this._cfgCheckStructure) {
                String string3 = string == null ? string2 : string + ":" + string2;
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, string3);
            }
            this._state = State.TREE;
        }
    }

    protected final void _verifyWriteCData() throws XMLStreamException {
        this._stateAnyOutput = true;
        if (this._stateStartElementOpen) {
            this._closeStartElement(this._stateEmptyElement);
        }
        if (this._cfgCheckStructure && this.inPrologOrEpilog()) {
            StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
        }
    }

    protected final void _verifyWriteDTD() throws XMLStreamException {
        if (this._cfgCheckStructure) {
            if (this._state != State.PROLOG) {
                throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + (Object)((Object)this._state) + "; start element(s) written)");
            }
            if (this._dtdRootElemName != null) {
                throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
            }
        }
    }

    protected void _verifyRootElement(String string, String string2) throws XMLValidationException {
        this._state = State.TREE;
    }

    protected static void throwOutputError(String string) throws XMLStreamException {
        throw new StreamExceptionBase(string);
    }

    protected static void throwOutputError(String string, Object object) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object);
        StreamWriterBase.throwOutputError(string2);
    }

    protected static void reportIllegalMethod(String string) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string);
    }

    protected static void _reportNwfStructure(String string) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string);
    }

    protected static void _reportNwfStructure(String string, Object object) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string, object);
    }

    protected static void _reportNwfContent(String string) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string);
    }

    protected static void _reportNwfContent(String string, Object object) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string, object);
    }

    protected static void _reportNwfAttr(String string) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string);
    }

    protected static void _reportNwfAttr(String string, Object object) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string, object);
    }

    protected static void _reportNwfName(String string) throws XMLStreamException {
        StreamWriterBase.throwOutputError(string);
    }

    protected static void throwFromIOE(IOException iOException) throws XMLStreamException {
        throw new IoStreamException(iOException);
    }

    protected static void reportIllegalArg(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    protected void _reportInvalidContent(int n) throws XMLStreamException {
        switch (this._vldContent) {
            case 0: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_EMPTY, this._currElem.getNameDesc(), ErrorConsts.tokenTypeDesc(n)));
                break;
            }
            case 1: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_NON_MIXED, this._currElem.getNameDesc()));
                break;
            }
            case 3: 
            case 4: {
                this._reportValidationProblem(MessageFormat.format(ErrorConsts.VERR_ANY, this._currElem.getNameDesc(), ErrorConsts.tokenTypeDesc(n)));
                break;
            }
            default: {
                this._reportValidationProblem("Internal error: trying to report invalid content for " + n);
            }
        }
    }

    public void _reportValidationProblem(String string) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), string, 2));
    }

    private final void _finishDocument(boolean bl) throws XMLStreamException {
        if (this._state != State.EPILOG) {
            if (this._cfgCheckStructure && this._state == State.PROLOG) {
                StreamWriterBase._reportNwfStructure(ErrorConsts.WERR_PROLOG_NO_ROOT);
            }
            if (this._stateStartElementOpen) {
                this._closeStartElement(this._stateEmptyElement);
            }
            while (this._state != State.EPILOG) {
                this.writeEndElement();
            }
        }
        if (this._symbols.maybeDirty()) {
            this._symbols.mergeToParent();
        }
        try {
            this._xmlWriter.close(bl);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    public String toString() {
        return "[StreamWriter: " + this.getClass() + ", underlying outputter: " + (this._xmlWriter == null ? "NULL" : this._xmlWriter.toString());
    }

    protected static enum State {
        PROLOG,
        TREE,
        EPILOG;

    }
}

