/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.sax;

import com.fasterxml.aalto.in.AttributeCollector;
import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.sax.SAXFeature;
import com.fasterxml.aalto.sax.SAXProperty;
import com.fasterxml.aalto.sax.SAXUtil;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

class SAXParserImpl
extends SAXParser
implements Parser,
XMLReader,
Attributes2,
Locator2 {
    final InputFactoryImpl _staxFactory;
    protected XmlScanner _scanner;
    protected AttributeCollector _attrCollector;
    protected ContentHandler _contentHandler;
    protected DTDHandler _dtdHandler;
    private EntityResolver _entityResolver;
    private ErrorHandler _errorHandler;
    private LexicalHandler _lexicalHandler;
    private DeclHandler _declHandler;
    private int _attrCount;

    SAXParserImpl(InputFactoryImpl inputFactoryImpl) {
        this._staxFactory = inputFactoryImpl;
    }

    @Override
    public final Parser getParser() {
        return this;
    }

    @Override
    public final XMLReader getXMLReader() {
        return this;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty sAXProperty = SAXUtil.findStdProperty(string);
        if (sAXProperty != null) {
            switch (sAXProperty) {
                case DECLARATION_HANDLER: {
                    return this._declHandler;
                }
                case DOCUMENT_XML_VERSION: {
                    return this._scanner.getConfig().getXmlDeclVersion();
                }
                case DOM_NODE: {
                    return null;
                }
                case LEXICAL_HANDLER: {
                    return this._lexicalHandler;
                }
                case XML_STRING: {
                    return null;
                }
            }
        }
        SAXUtil.reportUnknownProperty(string);
        return null;
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty sAXProperty = SAXUtil.findStdProperty(string);
        if (sAXProperty != null) {
            switch (sAXProperty) {
                case DECLARATION_HANDLER: {
                    this._declHandler = (DeclHandler)object;
                    return;
                }
                case DOCUMENT_XML_VERSION: {
                    this._scanner.getConfig().setXmlVersion(object == null ? null : String.valueOf(object));
                    return;
                }
                case DOM_NODE: {
                    return;
                }
                case LEXICAL_HANDLER: {
                    this._lexicalHandler = (LexicalHandler)object;
                    return;
                }
                case XML_STRING: {
                    return;
                }
            }
        }
        SAXUtil.reportUnknownFeature(string);
    }

    @Override
    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        if (handlerBase != null) {
            if (this._contentHandler == null) {
                this.setDocumentHandler(handlerBase);
            }
            if (this._entityResolver == null) {
                this.setEntityResolver(handlerBase);
            }
            if (this._errorHandler == null) {
                this.setErrorHandler(handlerBase);
            }
            if (this._dtdHandler == null) {
                this.setDTDHandler(handlerBase);
            }
        }
        this.parse(inputSource);
    }

    @Override
    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (defaultHandler != null) {
            if (this._contentHandler == null) {
                this.setContentHandler(defaultHandler);
            }
            if (this._entityResolver == null) {
                this.setEntityResolver(defaultHandler);
            }
            if (this._errorHandler == null) {
                this.setErrorHandler(defaultHandler);
            }
            if (this._dtdHandler == null) {
                this.setDTDHandler(defaultHandler);
            }
        }
        this.parse(inputSource);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature != null) {
            Boolean bl = SAXUtil.getFixedStdFeatureValue(sAXFeature);
            if (bl != null) {
                return bl;
            }
            switch (sAXFeature) {
                case IS_STANDALONE: {
                    return true;
                }
            }
        }
        SAXUtil.reportUnknownFeature(string);
        return false;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this._contentHandler = contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature == null) {
            SAXUtil.reportUnknownFeature(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource inputSource) throws SAXException {
        String string = inputSource.getEncoding();
        String string2 = inputSource.getSystemId();
        ReaderConfig readerConfig = this._staxFactory.getNonSharedConfig(string2, inputSource.getPublicId(), string, false, false);
        readerConfig.doParseLazily(false);
        InputStream inputStream = null;
        Reader reader = inputSource.getCharacterStream();
        if (reader == null && (inputStream = inputSource.getByteStream()) == null) {
            if (string2 == null) {
                throw new SAXException("Invalid InputSource passed: neither character or byte stream passed, nor system id specified");
            }
            try {
                URL uRL = URLUtil.urlFromSystemId(string2);
                inputStream = URLUtil.inputStreamFromURL(uRL);
            }
            catch (IOException iOException) {
                SAXException sAXException = new SAXException(iOException);
                if (sAXException.getCause() == null) {
                    sAXException.initCause(iOException);
                }
                throw sAXException;
            }
        }
        if (this._contentHandler != null) {
            this._contentHandler.setDocumentLocator(this);
            this._contentHandler.startDocument();
        }
        try {
            this._scanner = reader != null ? CharSourceBootstrapper.construct(readerConfig, reader).bootstrap() : ByteSourceBootstrapper.construct(readerConfig, inputStream).bootstrap();
            this._attrCollector = this._scanner.getAttrCollector();
            this.fireEvents();
        }
        catch (XMLStreamException xMLStreamException) {
            this.throwSaxException(xMLStreamException);
        }
        finally {
            if (this._contentHandler != null) {
                this._contentHandler.endDocument();
            }
            if (this._scanner != null) {
                try {
                    this._scanner.close(false);
                }
                catch (XMLStreamException xMLStreamException) {}
                this._scanner = null;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void parse(String string) throws SAXException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
    }

    private final void fireEvents() throws SAXException, XMLStreamException {
        int n;
        while ((n = this._scanner.nextFromProlog(true)) != 1) {
            this.fireAuxEvent(n, false);
        }
        this.fireStartTag();
        int n2 = 1;
        while (true) {
            if ((n = this._scanner.nextFromTree()) == 1) {
                this.fireStartTag();
                ++n2;
                continue;
            }
            if (n == 2) {
                this.fireEndTag();
                if (--n2 >= 1) continue;
                break;
            }
            if (n == 4) {
                this._scanner.fireSaxCharacterEvents(this._contentHandler);
                continue;
            }
            this.fireAuxEvent(n, true);
        }
        while ((n = this._scanner.nextFromProlog(false)) != -1) {
            if (n == 6) continue;
            this.fireAuxEvent(n, false);
        }
    }

    private final void fireAuxEvent(int n, boolean bl) throws SAXException, XMLStreamException {
        switch (n) {
            case 5: {
                this._scanner.fireSaxCommentEvent(this._lexicalHandler);
                break;
            }
            case 12: {
                if (this._lexicalHandler != null) {
                    this._lexicalHandler.startCDATA();
                    this._scanner.fireSaxCharacterEvents(this._contentHandler);
                    this._lexicalHandler.endCDATA();
                    break;
                }
                this._scanner.fireSaxCharacterEvents(this._contentHandler);
                break;
            }
            case 11: {
                if (this._lexicalHandler == null) break;
                PName pName = this._scanner.getName();
                this._lexicalHandler.startDTD(pName.getPrefixedName(), this._scanner.getDTDPublicId(), this._scanner.getDTDSystemId());
                this._lexicalHandler.endDTD();
                break;
            }
            case 3: {
                this._scanner.fireSaxPIEvent(this._contentHandler);
                break;
            }
            case 6: {
                if (!bl) break;
                this._scanner.fireSaxSpaceEvents(this._contentHandler);
                break;
            }
            default: {
                if (n == -1) {
                    this.throwSaxException("Unexpected end-of-input in " + (bl ? "tree" : "prolog"));
                }
                throw new RuntimeException("Internal error: unexpected type, " + n);
            }
        }
    }

    private final void fireStartTag() throws SAXException {
        this._attrCount = this._scanner.getAttrCount();
        this._scanner.fireSaxStartElement(this._contentHandler, this);
    }

    private final void fireEndTag() throws SAXException {
        this._scanner.fireSaxEndElement(this._contentHandler);
    }

    @Override
    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.setContentHandler(new DocHandlerWrapper(documentHandler));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public int getIndex(String string) {
        return this._attrCollector == null ? -1 : this._attrCollector.findIndex(null, string);
    }

    @Override
    public int getIndex(String string, String string2) {
        return this._attrCollector == null ? -1 : this._attrCollector.findIndex(string, string2);
    }

    @Override
    public int getLength() {
        return this._attrCount;
    }

    @Override
    public String getLocalName(int n) {
        return n < 0 || n >= this._attrCount ? null : this._attrCollector.getName(n).getLocalName();
    }

    @Override
    public String getQName(int n) {
        return n < 0 || n >= this._attrCount ? null : this._attrCollector.getName(n).getPrefixedName();
    }

    @Override
    public String getType(int n) {
        return n < 0 || n >= this._attrCount ? null : this._scanner.getAttrType(n);
    }

    @Override
    public String getType(String string) {
        int n = this.getIndex(string);
        return n < 0 ? null : this._scanner.getAttrType(n);
    }

    @Override
    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n < 0 ? null : this._scanner.getAttrType(n);
    }

    @Override
    public String getURI(int n) {
        if (n < 0 || n >= this._attrCount) {
            return null;
        }
        String string = this._attrCollector.getName(n).getNsUri();
        return string == null ? "" : string;
    }

    @Override
    public String getValue(int n) {
        return n < 0 || n >= this._attrCount ? null : this._attrCollector.getValue(n);
    }

    @Override
    public String getValue(String string) {
        int n = this.getIndex(string);
        return n < 0 ? null : this._attrCollector.getValue(n);
    }

    @Override
    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n < 0 ? null : this._attrCollector.getValue(n);
    }

    @Override
    public boolean isDeclared(int n) {
        return false;
    }

    @Override
    public boolean isDeclared(String string) {
        return false;
    }

    @Override
    public boolean isDeclared(String string, String string2) {
        return false;
    }

    @Override
    public boolean isSpecified(int n) {
        return true;
    }

    @Override
    public boolean isSpecified(String string) {
        return true;
    }

    @Override
    public boolean isSpecified(String string, String string2) {
        return true;
    }

    @Override
    public int getColumnNumber() {
        return this._scanner != null ? this._scanner.getCurrentColumnNr() : -1;
    }

    @Override
    public int getLineNumber() {
        return this._scanner != null ? this._scanner.getCurrentLineNr() : -1;
    }

    @Override
    public String getPublicId() {
        return this._scanner != null ? this._scanner.getInputPublicId() : null;
    }

    @Override
    public String getSystemId() {
        return this._scanner != null ? this._scanner.getInputSystemId() : null;
    }

    @Override
    public String getEncoding() {
        ReaderConfig readerConfig = this._scanner.getConfig();
        String string = readerConfig.getActualEncoding();
        if (string == null && (string = readerConfig.getXmlDeclEncoding()) == null) {
            string = readerConfig.getExternalEncoding();
        }
        return string;
    }

    @Override
    public String getXMLVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    private void throwSaxException(Exception exception) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(exception.getMessage(), this, exception);
        if (sAXParseException.getCause() == null) {
            sAXParseException.initCause(exception);
        }
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    private void throwSaxException(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    static final class AttributesWrapper
    implements AttributeList {
        Attributes mAttrs;

        public void setAttributes(Attributes attributes) {
            this.mAttrs = attributes;
        }

        @Override
        public int getLength() {
            return this.mAttrs.getLength();
        }

        @Override
        public String getName(int n) {
            String string = this.mAttrs.getQName(n);
            return string == null ? this.mAttrs.getLocalName(n) : string;
        }

        @Override
        public String getType(int n) {
            return this.mAttrs.getType(n);
        }

        @Override
        public String getType(String string) {
            return this.mAttrs.getType(string);
        }

        @Override
        public String getValue(int n) {
            return this.mAttrs.getValue(n);
        }

        @Override
        public String getValue(String string) {
            return this.mAttrs.getValue(string);
        }
    }

    static final class DocHandlerWrapper
    implements ContentHandler {
        final DocumentHandler mDocHandler;
        final AttributesWrapper mAttrWrapper = new AttributesWrapper();

        DocHandlerWrapper(DocumentHandler documentHandler) {
            this.mDocHandler = documentHandler;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mDocHandler.characters(cArray, n, n2);
        }

        @Override
        public void endDocument() throws SAXException {
            this.mDocHandler.endDocument();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3 == null) {
                string3 = string2;
            }
            this.mDocHandler.endElement(string3);
        }

        @Override
        public void endPrefixMapping(String string) {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.mDocHandler.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.mDocHandler.processingInstruction(string, string2);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mDocHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String string) {
        }

        @Override
        public void startDocument() throws SAXException {
            this.mDocHandler.startDocument();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3 == null) {
                string3 = string2;
            }
            this.mAttrWrapper.setAttributes(attributes);
            this.mDocHandler.startElement(string3, this.mAttrWrapper);
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
        }
    }
}

