/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.dom.DOMWriterImpl;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.StreamExceptionBase;
import com.fasterxml.aalto.out.AsciiXmlWriter;
import com.fasterxml.aalto.out.CharXmlWriter;
import com.fasterxml.aalto.out.Latin1XmlWriter;
import com.fasterxml.aalto.out.NonRepairingStreamWriter;
import com.fasterxml.aalto.out.RepairingStreamWriter;
import com.fasterxml.aalto.out.Utf8XmlWriter;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.URLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.io.Stax2Result;
import org.codehaus.stax2.ri.Stax2EventWriterImpl;
import org.codehaus.stax2.ri.Stax2WriterAdapter;

public final class OutputFactoryImpl
extends XMLOutputFactory2 {
    protected final WriterConfig _config = new WriterConfig();

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(outputStream, null, string, false));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, writer, null, false));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return this.createSW(outputStream, null, string, false);
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createSW(null, writer, null, false);
    }

    public Object getProperty(String string) {
        return this._config.getProperty(string, true);
    }

    public boolean isPropertySupported(String string) {
        return this._config.isPropertySupported(string);
    }

    public void setProperty(String string, Object object) {
        this._config.setProperty(string, object);
    }

    public XMLEventWriter createXMLEventWriter(Writer writer, String string) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, writer, string, false));
    }

    public XMLEventWriter createXMLEventWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter2 xMLStreamWriter2 = Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)xMLStreamWriter);
        return new Stax2EventWriterImpl(xMLStreamWriter2);
    }

    public XMLStreamWriter2 createXMLStreamWriter(Writer writer, String string) throws XMLStreamException {
        return this.createSW(null, writer, string, false);
    }

    public void configureForXmlConformance() {
        this._config.configureForXmlConformance();
    }

    public void configureForRobustness() {
        this._config.configureForRobustness();
    }

    public void configureForSpeed() {
        this._config.configureForSpeed();
    }

    private XMLStreamWriter2 createSW(OutputStream outputStream, Writer writer, String string, boolean bl) throws XMLStreamException {
        WNameTable wNameTable;
        XmlWriter xmlWriter;
        WriterConfig writerConfig = this._config.createNonShared();
        if (bl) {
            writerConfig.doAutoCloseOutput(true);
        }
        if (writer == null) {
            if (string == null) {
                string = "UTF-8";
            } else if (string != "UTF-8" && string != "ISO-8859-1" && string != "US-ASCII") {
                string = CharsetNames.normalize(string);
            }
            writerConfig.setActualEncodingIfNotSet(string);
            try {
                if (string == "UTF-8") {
                    xmlWriter = new Utf8XmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getUtf8Symbols(xmlWriter);
                }
                if (string == "ISO-8859-1") {
                    xmlWriter = new Latin1XmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getLatin1Symbols(xmlWriter);
                }
                if (string == "US-ASCII") {
                    xmlWriter = new AsciiXmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getAsciiSymbols(xmlWriter);
                }
                writer = new OutputStreamWriter(outputStream, string);
                xmlWriter = new CharXmlWriter(writerConfig, writer);
                wNameTable = this._config.getCharSymbols(xmlWriter);
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        } else {
            if (string == null) {
                string = CharsetNames.findEncodingFor(writer);
            }
            if (string != null) {
                writerConfig.setActualEncodingIfNotSet(string);
            }
            xmlWriter = new CharXmlWriter(writerConfig, writer);
            wNameTable = this._config.getCharSymbols(xmlWriter);
        }
        if (writerConfig.willRepairNamespaces()) {
            return new RepairingStreamWriter(writerConfig, xmlWriter, wNameTable);
        }
        return new NonRepairingStreamWriter(writerConfig, xmlWriter, wNameTable);
    }

    private XMLStreamWriter2 createSW(Result result) throws XMLStreamException {
        boolean bl;
        Object object;
        OutputStream outputStream = null;
        Writer writer = null;
        String string = null;
        String string2 = null;
        if (result instanceof Stax2Result) {
            object = (Stax2Result)result;
            try {
                outputStream = object.constructOutputStream();
                if (outputStream == null) {
                    writer = object.constructWriter();
                }
            }
            catch (IOException iOException) {
                throw new StreamExceptionBase(iOException);
            }
            bl = true;
        } else if (result instanceof StreamResult) {
            object = (StreamResult)result;
            string2 = ((StreamResult)object).getSystemId();
            outputStream = ((StreamResult)object).getOutputStream();
            if (outputStream == null) {
                writer = ((StreamResult)object).getWriter();
            }
            bl = false;
        } else if (result instanceof SAXResult) {
            object = (SAXResult)result;
            string2 = ((SAXResult)object).getSystemId();
            if (string2 == null || string2.length() == 0) {
                throw new StreamExceptionBase("Can not create a stream writer for a SAXResult that does not have System Id (support for using SAX input source not implemented)");
            }
            bl = true;
        } else {
            if (result instanceof DOMResult) {
                return DOMWriterImpl.createFrom(this._config.createNonShared(), (DOMResult)result);
            }
            throw new IllegalArgumentException("Can not create XMLStreamWriter for Result type " + result.getClass() + " (unrecognized type)");
        }
        if (outputStream != null) {
            return this.createSW(outputStream, null, string, bl);
        }
        if (writer != null) {
            return this.createSW(null, writer, string, bl);
        }
        if (string2 != null && string2.length() > 0) {
            bl = true;
            try {
                outputStream = URLUtil.outputStreamFromURL(URLUtil.urlFromSystemId(string2));
            }
            catch (IOException iOException) {
                throw new IoStreamException(iOException);
            }
            return this.createSW(outputStream, null, string, bl);
        }
        throw new StreamExceptionBase("Can not create XMLStreamWriter for passed-in Result -- neither writer, output stream nor system id (to create one) was accessible");
    }
}

