/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;
    private Expression limitExpr;
    private final ArrayList<Column> columns = New.arrayList();
    private final HashMap<Column, Expression> expressionMap = New.hashMap();

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.expressionMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.columns.add(column);
        this.expressionMap.put(column, expression);
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        RowList rowList = new RowList(this.session);
        try {
            Row row;
            Object object;
            Table table = this.tableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            int n = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int n2 = 0;
            Column[] columnArray = table.getColumns();
            int n3 = -1;
            if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = ((Value)object).getInt();
            }
            while (this.tableFilter.next()) {
                int n4;
                this.setCurrentRowNumber(n2 + 1);
                if (n3 >= 0 && n2 >= n3) break;
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                object = this.tableFilter.get();
                row = table.getTemplateRow();
                for (n4 = 0; n4 < n; ++n4) {
                    Column column;
                    Value value;
                    Expression expression = this.expressionMap.get(columnArray[n4]);
                    if (expression == null) {
                        value = ((Row)object).getValue(n4);
                    } else if (expression == ValueExpression.getDefault()) {
                        column = table.getColumn(n4);
                        value = table.getDefaultValue(this.session, column);
                    } else {
                        column = table.getColumn(n4);
                        value = column.convert(expression.getValue(this.session));
                    }
                    row.setValue(n4, value);
                }
                table.validateConvertUpdateSequence(this.session, row);
                n4 = 0;
                if (table.fireRow()) {
                    n4 = table.fireBeforeRow(this.session, (Row)object, row) ? 1 : 0;
                }
                if (n4 == 0) {
                    rowList.add((Row)object);
                    rowList.add(row);
                }
                ++n2;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.invalidateCache();
                rowList.reset();
                while (rowList.hasNext()) {
                    object = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, (Row)object, row, false);
                }
            }
            table.fire(this.session, 2, false);
            int n5 = n2;
            return n5;
        }
        finally {
            rowList.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.tableFilter.getPlanSQL(false)).append("\nSET\n    ");
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            Column column = this.columns.get(i);
            Expression expression = this.expressionMap.get(column);
            statementBuilder.appendExceptFirst(",\n    ");
            statementBuilder.append(column.getName()).append(" = ").append(expression.getSQL());
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            Column column = this.columns.get(i);
            Expression expression = this.expressionMap.get(column);
            expression.mapColumns(this.tableFilter, 0);
            this.expressionMap.put(column, expression.optimize(this.session));
        }
        PlanItem planItem = this.tableFilter.getBestPlanItem(this.session, 1);
        this.tableFilter.setPlanItem(planItem);
        this.tableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

