/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.NoMappingJsonFactoryObjectFactory;

public final class MappingJsonFactoryObjectFactory
implements ObjectFactory {
    private volatile MappingJsonFactory jsonFactoryCached;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        MappingJsonFactory jsonFactory = this.jsonFactoryCached;
        if (jsonFactory == null) {
            MappingJsonFactoryObjectFactory mappingJsonFactoryObjectFactory = this;
            synchronized (mappingJsonFactoryObjectFactory) {
                Object deserializationProblemHandlers;
                Object serializationFeatures;
                Object deserializationFeatures;
                Object mapperFeatures;
                jsonFactory = this.jsonFactoryCached;
                if (jsonFactory == null) {
                    this.jsonFactoryCached = jsonFactory = new MappingJsonFactory();
                }
                ClassLoader classLoader = MappingJsonFactoryObjectFactory.class.getClassLoader();
                ObjectMapper objectMapper = jsonFactory.getCodec();
                Object jsonFactoryFeatures = environment.get("jsonFactoryFeatures");
                if (jsonFactoryFeatures != null) {
                    NoMappingJsonFactoryObjectFactory.configureJsonFactoryFeatures((JsonFactory)jsonFactory, (String)jsonFactoryFeatures);
                }
                if ((mapperFeatures = environment.get("mapperFeatures")) != null) {
                    MappingJsonFactoryObjectFactory.configureMapperFeatures(objectMapper, (String)mapperFeatures);
                }
                if ((deserializationFeatures = environment.get("deserializationFeatures")) != null) {
                    MappingJsonFactoryObjectFactory.configureDeserializationFeatures(objectMapper, (String)deserializationFeatures);
                }
                if ((serializationFeatures = environment.get("serializationFeatures")) != null) {
                    MappingJsonFactoryObjectFactory.configureSerializationFeatures(objectMapper, (String)serializationFeatures);
                }
                if ((deserializationProblemHandlers = environment.get("deserializationProblemHandlers")) != null) {
                    MappingJsonFactoryObjectFactory.configureDeserializationProblemHandlers(objectMapper, (String)deserializationProblemHandlers, classLoader);
                }
                MappingJsonFactoryObjectFactory.configureCustomSerializersAndDeserializers(objectMapper, (String)environment.get("customSerializers"), (String)environment.get("customDeserializers"), classLoader);
                NoMappingJsonFactoryObjectFactory.configureInputDecoratorAndOutputDecorator((JsonFactory)jsonFactory, environment);
            }
        }
        return jsonFactory;
    }

    static void configureDeserializationProblemHandlers(ObjectMapper objectMapper, String deserializationProblemHandlers, ClassLoader classLoader) throws Exception {
        StringTokenizer st = new StringTokenizer(deserializationProblemHandlers, ", ");
        while (st.hasMoreTokens()) {
            Class<?> c = classLoader.loadClass(st.nextToken());
            objectMapper.addHandler((DeserializationProblemHandler)c.newInstance());
        }
    }

    static void configureCustomSerializersAndDeserializers(ObjectMapper objectMapper, String customSerializers, String customDeserializers, ClassLoader classLoader) throws Exception {
        Class<?> aClass;
        StringTokenizer st;
        if (customDeserializers == null && customSerializers == null) {
            return;
        }
        SimpleModule simpleModule = new SimpleModule("custom-serializer-deserializer-module");
        if (customSerializers != null) {
            st = new StringTokenizer(customSerializers, ", ");
            while (st.hasMoreTokens()) {
                aClass = classLoader.loadClass(st.nextToken());
                simpleModule.addSerializer(aClass, (JsonSerializer)aClass.newInstance());
            }
        }
        if (customDeserializers != null) {
            st = new StringTokenizer(customDeserializers, ", ");
            while (st.hasMoreTokens()) {
                aClass = classLoader.loadClass(st.nextToken());
                simpleModule.addDeserializer(aClass, (JsonDeserializer)aClass.newInstance());
            }
        }
        objectMapper.registerModule((Module)simpleModule);
    }

    static void configureMapperFeatures(ObjectMapper objectMapper, String features) {
        StringTokenizer st = new StringTokenizer(features, ",");
        while (st.hasMoreTokens()) {
            MapperFeature feature;
            String[] pair = NoMappingJsonFactoryObjectFactory.parseSingleFeatureValue(st.nextToken().trim());
            String key = pair[0];
            String value = pair[1];
            try {
                feature = MapperFeature.valueOf((String)key);
            }
            catch (Exception e1) {
                throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
            }
            if ("true".equals(value)) {
                if (feature.enabledByDefault()) continue;
                objectMapper.configure(feature, true);
                continue;
            }
            if ("false".equals(value)) {
                if (!feature.enabledByDefault()) continue;
                objectMapper.configure(feature, false);
                continue;
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, value, key);
        }
    }

    static void configureSerializationFeatures(ObjectMapper objectMapper, String features) {
        StringTokenizer st = new StringTokenizer(features, ",");
        while (st.hasMoreTokens()) {
            SerializationFeature feature;
            String[] pair = NoMappingJsonFactoryObjectFactory.parseSingleFeatureValue(st.nextToken().trim());
            String key = pair[0];
            String value = pair[1];
            try {
                feature = SerializationFeature.valueOf((String)key);
            }
            catch (Exception e1) {
                throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
            }
            if ("true".equals(value)) {
                if (feature.enabledByDefault()) continue;
                objectMapper.configure(feature, true);
                continue;
            }
            if ("false".equals(value)) {
                if (!feature.enabledByDefault()) continue;
                objectMapper.configure(feature, false);
                continue;
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, value, key);
        }
    }

    static void configureDeserializationFeatures(ObjectMapper objectMapper, String features) {
        StringTokenizer st = new StringTokenizer(features, ",");
        while (st.hasMoreTokens()) {
            DeserializationFeature feature;
            String[] pair = NoMappingJsonFactoryObjectFactory.parseSingleFeatureValue(st.nextToken().trim());
            String key = pair[0];
            String value = pair[1];
            try {
                feature = DeserializationFeature.valueOf((String)key);
            }
            catch (Exception e1) {
                throw SupportLogger.LOGGER.unrecognizedReaderWriterProperty(key, value);
            }
            if ("true".equals(value)) {
                if (feature.enabledByDefault()) continue;
                objectMapper.configure(feature, true);
                continue;
            }
            if ("false".equals(value)) {
                if (!feature.enabledByDefault()) continue;
                objectMapper.configure(feature, false);
                continue;
            }
            throw SupportLogger.LOGGER.invalidReaderWriterProperty(null, value, key);
        }
    }
}

