/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.ReadPreference;
import java.util.Map;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class MapReduce {
    public static <T, K> MapReduceCommand<T, K> build(String map, String reduce, OutputType outputType, String collection, Class<T> resultType, Class<K> keyType) {
        return new MapReduceCommand(map, reduce, outputType, collection, resultType, keyType);
    }

    public static class MapReduceCommand<T, K> {
        private final String map;
        private final String reduce;
        private final OutputType outputType;
        private final String collection;
        private final Class<T> resultType;
        private final Class<K> keyType;
        private ReadPreference readPreference;
        private String outputDB;
        private DBQuery.Query query;
        private String finalize;
        private DBObject sort;
        private int limit;
        private Map<String, Object> scope;
        private boolean verbose = true;
        private DBObject extra;

        private MapReduceCommand(String map, String reduce, OutputType outputType, String collection, Class<T> resultType, Class<K> keyType) {
            this.map = map;
            this.reduce = reduce;
            this.outputType = outputType;
            this.collection = collection;
            this.resultType = resultType;
            this.keyType = keyType;
        }

        public MapReduceCommand<T, K> setReadPreference(ReadPreference readPreference) {
            this.readPreference = readPreference;
            return this;
        }

        public MapReduceCommand<T, K> setOutputDB(String outputDB) {
            this.outputDB = outputDB;
            return this;
        }

        public MapReduceCommand<T, K> setQuery(DBQuery.Query query) {
            this.query = query;
            return this;
        }

        public MapReduceCommand<T, K> setFinalize(String finalize) {
            this.finalize = finalize;
            return this;
        }

        public MapReduceCommand<T, K> setSort(DBObject sort) {
            this.sort = sort;
            return this;
        }

        public MapReduceCommand<T, K> setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public MapReduceCommand<T, K> setScope(Map<String, Object> scope) {
            this.scope = scope;
            return this;
        }

        public MapReduceCommand<T, K> setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public MapReduceCommand<T, K> setExtra(DBObject extra) {
            this.extra = extra;
            return this;
        }

        com.mongodb.MapReduceCommand build(JacksonDBCollection<?, ?> collection) {
            DBObject query = null;
            if (this.query != null) {
                query = collection.serializeQuery(this.query);
            }
            com.mongodb.MapReduceCommand command = new com.mongodb.MapReduceCommand(collection.getDbCollection(), this.map, this.reduce, this.collection, this.outputType.getDriverType(), query);
            if (this.finalize != null) {
                command.setFinalize(this.finalize);
            }
            if (this.readPreference != null) {
                command.setReadPreference(this.readPreference);
            }
            if (this.outputDB != null) {
                command.setOutputDB(this.outputDB);
            }
            if (this.sort != null) {
                command.setSort(this.sort);
            }
            command.setLimit(this.limit);
            if (this.scope != null) {
                command.setScope(this.scope);
            }
            command.setVerbose(Boolean.valueOf(this.verbose));
            if (this.extra != null) {
                for (String key : this.extra.keySet()) {
                    command.addExtraOption(key, this.extra.get(key));
                }
            }
            return command;
        }

        Class<T> getResultType() {
            return this.resultType;
        }

        Class<K> getKeyType() {
            return this.keyType;
        }
    }

    public static enum OutputType {
        REPLACE(MapReduceCommand.OutputType.REPLACE),
        MERGE(MapReduceCommand.OutputType.MERGE),
        REDUCE(MapReduceCommand.OutputType.REDUCE),
        INLINE(MapReduceCommand.OutputType.INLINE);

        private final MapReduceCommand.OutputType driverType;

        private OutputType(MapReduceCommand.OutputType driverType) {
            this.driverType = driverType;
        }

        MapReduceCommand.OutputType getDriverType() {
            return this.driverType;
        }
    }
}

