/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import org.mongojack.DBRef;
import org.mongojack.Id;
import org.mongojack.ObjectId;
import org.mongojack.internal.DBRefDeserializer;
import org.mongojack.internal.ObjectIdDeserializers;
import org.mongojack.internal.ObjectIdSerializer;

public class MongoAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final TypeFactory typeFactory;

    public MongoAnnotationIntrospector(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public boolean isHandled(Annotation ann) {
        return ann.annotationType() == ObjectId.class || ann.annotationType() == Id.class || ann.annotationType() == javax.persistence.Id.class;
    }

    public String findSerializationName(AnnotatedMethod am) {
        return this.findPropertyName((Annotated)am);
    }

    public String findDeserializationName(AnnotatedMethod am) {
        return this.findPropertyName((Annotated)am);
    }

    public String findDeserializationName(AnnotatedField af) {
        return this.findPropertyName((Annotated)af);
    }

    public String findSerializationName(AnnotatedField af) {
        return this.findPropertyName((Annotated)af);
    }

    public String findDeserializationName(AnnotatedParameter param) {
        return this.findPropertyName((Annotated)param);
    }

    private String findPropertyName(Annotated annotated) {
        if (annotated.hasAnnotation(Id.class) || annotated.hasAnnotation(javax.persistence.Id.class)) {
            return "_id";
        }
        return null;
    }

    public Object findSerializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            return ObjectIdSerializer.class;
        }
        return null;
    }

    public Object findDeserializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            return this.findObjectIdDeserializer(this.typeFactory.constructType(am.getGenericType()));
        }
        return null;
    }

    public JsonDeserializer findContentDeserializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            JavaType type = this.typeFactory.constructType(am.getGenericType());
            if (type.isCollectionLikeType()) {
                return this.findObjectIdDeserializer(type.containedType(0));
            }
            if (type.isMapLikeType()) {
                return this.findObjectIdDeserializer(type.containedType(1));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonDeserializer findObjectIdDeserializer(JavaType type) {
        if (type.getRawClass() == String.class) {
            return new ObjectIdDeserializers.ToStringDeserializer();
        }
        if (type.getRawClass() == byte[].class) {
            return new ObjectIdDeserializers.ToByteArrayDeserializer();
        }
        if (type.getRawClass() == DBRef.class) {
            JavaType dbRefType;
            if (type.isContainerType()) {
                if (type.isCollectionLikeType()) {
                    dbRefType = type.containedType(0);
                } else {
                    if (!type.isMapLikeType()) return null;
                    dbRefType = type.containedType(1);
                }
            } else {
                dbRefType = type;
            }
            JsonDeserializer keyDeserializer = this.findObjectIdDeserializer(dbRefType.containedType(1));
            return new DBRefDeserializer(dbRefType.containedType(0), dbRefType.containedType(1), keyDeserializer);
        }
        if (type.getRawClass() != org.bson.types.ObjectId.class) return null;
        return new ObjectIdDeserializers.ToObjectIdDeserializer();
    }
}

