/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import java.util.Calendar;
import java.util.Date;
import org.mongojack.DBRef;
import org.mongojack.internal.CalendarDeserializer;
import org.mongojack.internal.DBRefDeserializer;
import org.mongojack.internal.DateDeserializer;

public class MongoJackDeserializers
extends SimpleDeserializers {
    public MongoJackDeserializers() {
        this.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        this.addDeserializer(Calendar.class, (JsonDeserializer)new CalendarDeserializer());
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (type.getRawClass() == DBRef.class) {
            if (type.containedTypeCount() != 2) {
                throw new JsonMappingException("Property doesn't declare object and key type");
            }
            JavaType objectType = type.containedType(0);
            JavaType keyType = type.containedType(1);
            return new DBRefDeserializer(objectType, keyType);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

