/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.object;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.mongojack.internal.util.VersionUtils;

public class BsonObjectGenerator
extends JsonGenerator {
    private Node rootNode;
    private ObjectCodec objectCodec;
    private Node currentNode;
    private boolean closed = false;

    public DBObject getDBObject() {
        if (this.rootNode instanceof ObjectNode) {
            return ((ObjectNode)this.rootNode).get();
        }
        throw new IllegalStateException("Object node was not generated");
    }

    public Object getValue() {
        return this.rootNode.get();
    }

    public Version version() {
        return VersionUtils.VERSION;
    }

    public JsonGenerator enable(JsonGenerator.Feature f) {
        return this;
    }

    public JsonGenerator disable(JsonGenerator.Feature f) {
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature f) {
        return false;
    }

    public JsonGenerator setCodec(ObjectCodec oc) {
        this.objectCodec = oc;
        return this;
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public void writeStartArray() throws IOException {
        this.currentNode = this.rootNode == null ? (this.rootNode = new ArrayNode(null)) : new ArrayNode(this.currentNode);
    }

    public void writeEndArray() throws IOException {
        Object array = this.currentNode.get();
        this.currentNode = this.currentNode.getParent();
        if (this.currentNode != null) {
            this.currentNode.set(array);
        }
    }

    public void writeStartObject() throws IOException {
        this.currentNode = this.rootNode == null ? (this.rootNode = new ObjectNode(null)) : new ObjectNode(this.currentNode);
    }

    public void writeEndObject() throws IOException {
        Object object = this.currentNode.get();
        this.currentNode = this.currentNode.getParent();
        if (this.currentNode != null) {
            this.currentNode.set(object);
        }
    }

    public void writeFieldName(String name) throws IOException {
        this.currentNode.setName(name);
    }

    public void writeString(String text) throws IOException {
        this.setValue(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.setValue(new String(text, offset, len));
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.setValue(new String(text, offset, length, "UTF-8"));
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.setValue(new String(text, offset, length, "UTF-8"));
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException("Writing raw not supported");
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("Writing raw not supported");
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("Writing raw not supported");
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException("Writing raw not supported");
    }

    public void writeRawValue(String text) throws IOException {
        this.setValue(text);
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this.setValue(text.substring(offset, offset + len));
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this.setValue(new String(text, offset, len));
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (offset != 0 || len != data.length) {
            byte[] subset = new byte[len];
            System.arraycopy(data, offset, subset, 0, len);
            data = subset;
        }
        this.setValue(data);
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException, JsonGenerationException {
        throw new UnsupportedOperationException();
    }

    public void writeNumber(int v) throws IOException {
        this.setValue(v);
    }

    public void writeNumber(long v) throws IOException {
        this.setValue(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.setValue(v);
    }

    public void writeNumber(double d) throws IOException {
        this.setValue(d);
    }

    public void writeNumber(float f) throws IOException {
        this.setValue(Float.valueOf(f));
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        this.setValue(dec);
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        this.setValue(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException {
        this.setValue(state);
    }

    public void writeNull() throws IOException {
        this.setValue(null);
    }

    public void writeObject(Object pojo) throws IOException {
        this.setValue(pojo);
    }

    public void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        this.writeFieldName(name.getValue());
    }

    public void writeString(SerializableString text) throws IOException, JsonGenerationException {
        this.setValue(text.getValue());
    }

    public void writeTree(TreeNode rootNode) throws IOException, JsonProcessingException {
        throw new UnsupportedClassVersionError("Writing JSON nodes not supported");
    }

    public void copyCurrentEvent(JsonParser jp) throws IOException {
        JsonToken t = jp.getCurrentToken();
        block0 : switch (t) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jp.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                if (jp.hasTextCharacters()) {
                    this.writeString(jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength());
                    break;
                }
                this.writeString(jp.getText());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jp.getNumberType()) {
                    case INT: {
                        this.writeNumber(jp.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jp.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jp.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jp.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jp.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jp.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jp.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jp.getEmbeddedObject());
            }
        }
    }

    public void copyCurrentStructure(JsonParser jp) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.FIELD_NAME) {
            this.writeFieldName(jp.getCurrentName());
            t = jp.nextToken();
        }
        switch (t) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jp);
            }
        }
    }

    public JsonStreamContext getOutputContext() {
        return this.currentNode;
    }

    public void flush() throws IOException {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    private void setValue(Object value) {
        if (this.rootNode == null) {
            this.rootNode = new RootValueNode(value);
        } else {
            this.currentNode.set(value);
        }
    }

    private class RootValueNode
    extends Node {
        private final Object rootValue;

        private RootValueNode(Object rootValue) {
            super(null, 0);
            this.rootValue = rootValue;
        }

        @Override
        void set(Object value) {
            throw new IllegalStateException("Cannot write multiple values to a root value node");
        }

        @Override
        Object get() {
            return this.rootValue;
        }
    }

    private class ArrayNode
    extends Node {
        private final List<Object> array;

        private ArrayNode(Node parent) {
            super(parent, 1);
            this.array = new ArrayList<Object>();
        }

        @Override
        void set(Object value) {
            this.array.add(value);
        }

        @Override
        List<Object> get() {
            return this.array;
        }
    }

    private class ObjectNode
    extends Node {
        private final BasicDBObject object;

        private ObjectNode(Node parent) {
            super(parent, 2);
            this.object = new BasicDBObject();
        }

        @Override
        void set(Object value) {
            this.object.put(this.getCurrentName(), value);
        }

        DBObject get() {
            return this.object;
        }
    }

    private abstract class Node
    extends JsonStreamContext {
        private final Node parent;
        private String name;

        private Node(Node parent, int contextType) {
            this.parent = parent;
            this._type = contextType;
            this._index = -1;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCurrentName() {
            return this.name;
        }

        abstract void set(Object var1);

        abstract Object get();
    }
}

