/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.mongojack.DBQuery;
import org.mongojack.DBRef;
import org.mongojack.MongoJsonMappingException;
import org.mongojack.internal.ObjectIdSerializer;
import org.mongojack.internal.object.BsonObjectGenerator;
import org.mongojack.internal.query.CollectionQueryCondition;
import org.mongojack.internal.query.CompoundQueryCondition;
import org.mongojack.internal.query.QueryCondition;
import org.mongojack.internal.query.SimpleQueryCondition;
import org.mongojack.internal.update.MultiUpdateOperationValue;
import org.mongojack.internal.update.UpdateOperationValue;
import org.mongojack.internal.util.JacksonAccessor;

public class SerializationUtils {
    private static final Set<Class<?>> BASIC_TYPES;

    public static DBObject serializeFields(ObjectMapper objectMapper, DBObject object) {
        BasicDBObject serialised = null;
        for (String field : object.keySet()) {
            Object serialisedValue;
            Object value = object.get(field);
            if (value == (serialisedValue = SerializationUtils.serializeField(objectMapper, value))) continue;
            if (serialised == null) {
                serialised = new BasicDBObject();
                for (String f : object.keySet()) {
                    serialised.put(f, object.get(f));
                }
            }
            serialised.put(field, serialisedValue);
        }
        if (serialised != null) {
            return serialised;
        }
        return object;
    }

    public static DBObject serializeQuery(ObjectMapper objectMapper, JavaType type, DBQuery.Query query) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, type);
        return SerializationUtils.serializeQuery(serializerProvider, serializer, query);
    }

    private static DBObject serializeQuery(SerializerProvider serializerProvider, JsonSerializer serializer, DBQuery.Query query) {
        BasicDBObject serializedQuery = new BasicDBObject();
        for (Map.Entry<String, QueryCondition> field : query.conditions()) {
            String key = field.getKey();
            QueryCondition condition = field.getValue();
            serializedQuery.put(key, SerializationUtils.serializeQueryCondition(serializerProvider, serializer, key, condition));
        }
        return serializedQuery;
    }

    public static Object serializeQueryCondition(ObjectMapper objectMapper, JavaType type, String key, QueryCondition condition) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, type);
        return SerializationUtils.serializeQueryCondition(serializerProvider, serializer, key, condition);
    }

    private static Object serializeQueryCondition(SerializerProvider serializerProvider, JsonSerializer serializer, String key, QueryCondition condition) {
        if (condition instanceof SimpleQueryCondition) {
            SimpleQueryCondition simple = (SimpleQueryCondition)condition;
            if (!simple.requiresSerialization() || simple.getValue() == null) {
                return simple.getValue();
            }
            if (!key.startsWith("$")) {
                serializer = SerializationUtils.findQuerySerializer(false, key, serializerProvider, serializer);
            }
            return SerializationUtils.serializeQueryField(simple.getValue(), serializer, serializerProvider, key);
        }
        if (condition instanceof CollectionQueryCondition) {
            CollectionQueryCondition coll = (CollectionQueryCondition)condition;
            if (!key.startsWith("$")) {
                serializer = SerializationUtils.findQuerySerializer(coll.targetIsCollection(), key, serializerProvider, (JsonSerializer)serializer);
            }
            ArrayList<Object> serializedConditions = new ArrayList<Object>();
            for (QueryCondition item : coll.getValues()) {
                serializedConditions.add(SerializationUtils.serializeQueryCondition(serializerProvider, serializer, "$", item));
            }
            return serializedConditions;
        }
        CompoundQueryCondition compound = (CompoundQueryCondition)condition;
        if (!key.startsWith("$")) {
            serializer = SerializationUtils.findQuerySerializer(false, key, serializerProvider, (JsonSerializer)serializer);
        }
        return SerializationUtils.serializeQuery(serializerProvider, (JsonSerializer)serializer, compound.getQuery());
    }

    private static Object serializeQueryField(Object value, JsonSerializer serializer, SerializerProvider serializerProvider, String op) {
        if (serializer == null) {
            if (value == null || BASIC_TYPES.contains(value.getClass())) {
                return value;
            }
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                ArrayList<Object> copy = null;
                int position = 0;
                for (Object item : coll) {
                    Object returned = SerializationUtils.serializeQueryField(item, null, serializerProvider, op);
                    if (returned != item) {
                        if (copy == null) {
                            copy = new ArrayList<Object>(coll);
                        }
                        copy.set(position, returned);
                    }
                    ++position;
                }
                if (copy != null) {
                    return copy;
                }
                return coll;
            }
            if (value.getClass().isArray()) {
                if (BASIC_TYPES.contains(value.getClass().getComponentType())) {
                    return value;
                }
                Object[] array = (Object[])value;
                Object[] copy = null;
                for (int i = 0; i < array.length; ++i) {
                    Object returned = SerializationUtils.serializeQueryField(array[i], null, serializerProvider, op);
                    if (returned == array[i]) continue;
                    if (copy == null) {
                        copy = new Object[array.length];
                        System.arraycopy(array, 0, copy, 0, array.length);
                    }
                    copy[i] = returned;
                }
                if (copy != null) {
                    return copy;
                }
                return array;
            }
            serializer = JacksonAccessor.findValueSerializer(serializerProvider, value.getClass());
        }
        BsonObjectGenerator objectGenerator = new BsonObjectGenerator();
        try {
            serializer.serialize(value, (JsonGenerator)objectGenerator, serializerProvider);
        }
        catch (IOException e) {
            throw new MongoJsonMappingException("Error serializing value " + value + " in DBQuery operation " + op, e);
        }
        return objectGenerator.getValue();
    }

    public static Object serializeField(ObjectMapper objectMapper, Object value) {
        if (value == null || BASIC_TYPES.contains(value.getClass())) {
            return value;
        }
        if (value instanceof DBObject) {
            return SerializationUtils.serializeFields(objectMapper, (DBObject)value);
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            ArrayList<Object> copy = null;
            int position = 0;
            for (Object item : coll) {
                Object returned = SerializationUtils.serializeField(objectMapper, item);
                if (returned != item) {
                    if (copy == null) {
                        copy = new ArrayList<Object>(coll);
                    }
                    copy.set(position, returned);
                }
                ++position;
            }
            if (copy != null) {
                return copy;
            }
            return coll;
        }
        if (value.getClass().isArray()) {
            if (BASIC_TYPES.contains(value.getClass().getComponentType())) {
                return value;
            }
            Object[] array = (Object[])value;
            Object[] copy = null;
            for (int i = 0; i < array.length; ++i) {
                Object returned = SerializationUtils.serializeField(objectMapper, array[i]);
                if (returned == array[i]) continue;
                if (copy == null) {
                    copy = new Object[array.length];
                    System.arraycopy(array, 0, copy, 0, array.length);
                }
                copy[i] = returned;
            }
            if (copy != null) {
                return copy;
            }
            return array;
        }
        BsonObjectGenerator generator = new BsonObjectGenerator();
        try {
            objectMapper.writeValue((JsonGenerator)generator, value);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new RuntimeException("Somehow got an IOException writing to memory", e);
        }
        return generator.getValue();
    }

    public static DBObject serializeDBUpdate(Map<String, Map<String, UpdateOperationValue>> update, ObjectMapper objectMapper, JavaType javaType) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        BasicDBObject dbObject = new BasicDBObject();
        JsonSerializer serializer = null;
        for (Map.Entry<String, Map<String, UpdateOperationValue>> op : update.entrySet()) {
            BasicDBObject opObject = new BasicDBObject();
            for (Map.Entry<String, UpdateOperationValue> field : op.getValue().entrySet()) {
                Object value;
                if (field.getValue().requiresSerialization()) {
                    JsonSerializer<?> fieldSerializer;
                    if (serializer == null) {
                        serializer = JacksonAccessor.findValueSerializer(serializerProvider, javaType);
                    }
                    value = (fieldSerializer = SerializationUtils.findUpdateSerializer(field.getValue().isTargetCollection(), field.getKey(), serializerProvider, serializer)) != null ? SerializationUtils.serializeUpdateField(field.getValue(), fieldSerializer, serializerProvider, op.getKey(), field.getKey()) : SerializationUtils.serializeField(objectMapper, field.getValue().getValue());
                } else {
                    value = field.getValue().getValue();
                }
                if (op.getKey().equals("$addToSet") && field.getValue() instanceof MultiUpdateOperationValue) {
                    opObject.put(field.getKey(), (Object)new BasicDBObject("$each", value));
                    continue;
                }
                opObject.put(field.getKey(), value);
            }
            dbObject.append(op.getKey(), (Object)opObject);
        }
        return dbObject;
    }

    private static Object serializeUpdateField(UpdateOperationValue value, JsonSerializer serializer, SerializerProvider serializerProvider, String op, String field) {
        if (value instanceof MultiUpdateOperationValue) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object item : ((MultiUpdateOperationValue)value).getValues()) {
                results.add(SerializationUtils.serializeUpdateField(item, serializer, serializerProvider, op, field));
            }
            return results;
        }
        return SerializationUtils.serializeUpdateField(value.getValue(), serializer, serializerProvider, op, field);
    }

    private static Object serializeUpdateField(Object value, JsonSerializer serializer, SerializerProvider serializerProvider, String op, String field) {
        BsonObjectGenerator objectGenerator = new BsonObjectGenerator();
        try {
            serializer.serialize(value, (JsonGenerator)objectGenerator, serializerProvider);
        }
        catch (IOException e) {
            throw new MongoJsonMappingException("Error serializing value in DBUpdate operation " + op + " field " + field, e);
        }
        return objectGenerator.getValue();
    }

    private static JsonSerializer<?> findUpdateSerializer(boolean targetIsCollection, String fieldPath, SerializerProvider serializerProvider, JsonSerializer serializer) {
        if (serializer instanceof BeanSerializerBase) {
            String[] fields;
            JsonSerializer fieldSerializer = serializer;
            for (String field : fields = fieldPath.split("\\.")) {
                if (fieldSerializer == null) {
                    return null;
                }
                if (field.equals("$") || field.matches("\\d+")) {
                    if (fieldSerializer instanceof ContainerSerializer) {
                        JavaType contentType;
                        JsonSerializer contentSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                        if (contentSerializer == null && (contentType = ((ContainerSerializer)fieldSerializer).getContentType()) != null) {
                            contentSerializer = JacksonAccessor.findValueSerializer(serializerProvider, contentType);
                        }
                        fieldSerializer = contentSerializer;
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof BeanSerializerBase) {
                    BeanPropertyWriter writer = JacksonAccessor.findPropertyWriter((BeanSerializerBase)serializer, field);
                    if (writer != null) {
                        fieldSerializer = writer.getSerializer();
                        if (fieldSerializer != null) continue;
                        fieldSerializer = JacksonAccessor.findValueSerializer(serializerProvider, writer.getType());
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof MapSerializer) {
                    fieldSerializer = ((MapSerializer)fieldSerializer).getContentSerializer();
                    continue;
                }
                return null;
            }
            if (targetIsCollection) {
                if (fieldSerializer instanceof ContainerSerializer) {
                    fieldSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                } else if (!(fieldSerializer instanceof ObjectIdSerializer)) {
                    return null;
                }
            }
            return fieldSerializer;
        }
        return null;
    }

    private static JsonSerializer<?> findQuerySerializer(boolean targetIsCollection, String fieldPath, SerializerProvider serializerProvider, JsonSerializer serializer) {
        if (serializer instanceof BeanSerializerBase || serializer instanceof MapSerializer) {
            String[] fields;
            JsonSerializer fieldSerializer = serializer;
            for (String field : fields = fieldPath.split("\\.")) {
                JavaType contentType;
                JsonSerializer contentSerializer;
                if (fieldSerializer == null) {
                    return null;
                }
                boolean isIndex = field.matches("\\d+");
                if (!isIndex) {
                    while (fieldSerializer instanceof ContainerSerializer) {
                        contentSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                        if (contentSerializer == null && (contentType = ((ContainerSerializer)fieldSerializer).getContentType()) != null) {
                            contentSerializer = JacksonAccessor.findValueSerializer(serializerProvider, contentType);
                        }
                        fieldSerializer = contentSerializer;
                    }
                }
                if (isIndex) {
                    if (fieldSerializer instanceof ContainerSerializer) {
                        contentSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                        if (contentSerializer == null && (contentType = ((ContainerSerializer)fieldSerializer).getContentType()) != null) {
                            contentSerializer = JacksonAccessor.findValueSerializer(serializerProvider, contentType);
                        }
                        fieldSerializer = contentSerializer;
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof BeanSerializerBase) {
                    BeanPropertyWriter writer = JacksonAccessor.findPropertyWriter((BeanSerializerBase)serializer, field);
                    if (writer != null) {
                        fieldSerializer = writer.getSerializer();
                        if (fieldSerializer != null) continue;
                        fieldSerializer = JacksonAccessor.findValueSerializer(serializerProvider, writer.getType());
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof MapSerializer) {
                    fieldSerializer = ((MapSerializer)fieldSerializer).getContentSerializer();
                    continue;
                }
                return null;
            }
            if (targetIsCollection) {
                if (fieldSerializer instanceof ContainerSerializer) {
                    fieldSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                } else if (!(fieldSerializer instanceof ObjectIdSerializer)) {
                    return null;
                }
            }
            return fieldSerializer;
        }
        return null;
    }

    static {
        HashSet types = new HashSet();
        types.add(String.class);
        types.add(Integer.class);
        types.add(Boolean.class);
        types.add(Short.class);
        types.add(Long.class);
        types.add(BigInteger.class);
        types.add(Float.class);
        types.add(Double.class);
        types.add(Byte.class);
        types.add(Character.class);
        types.add(BigDecimal.class);
        types.add(int[].class);
        types.add(boolean[].class);
        types.add(short[].class);
        types.add(long[].class);
        types.add(float[].class);
        types.add(double[].class);
        types.add(byte[].class);
        types.add(char[].class);
        types.add(Date.class);
        types.add(Pattern.class);
        types.add(ObjectId.class);
        types.add(DBRef.class);
        BASIC_TYPES = types;
    }
}

