/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.creation.ArtifactCreationContext;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Job;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.PropertyResolver;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Step;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.runtime.context.StepContextImpl;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;

public class JobContextImpl
extends AbstractContext
implements JobContext,
Cloneable {
    private static final AbstractContext[] EMPTY_ABSTRACT_CONTEXT_ARRAY = new AbstractContext[0];
    JobExecutionImpl jobExecution;
    private ArtifactFactory artifactFactory;
    JobRepository jobRepository;
    private JobListener[] jobListeners;
    private List<Step> executedSteps = Collections.synchronizedList(new ArrayList());
    JobExecutionImpl originalToRestart;
    final BatchEnvironment batchEnvironment;
    BatchArtifacts batchArtifacts;

    public JobContextImpl(JobExecutionImpl jobExecution, JobExecutionImpl originalToRestart, ArtifactFactory artifactFactory, JobRepository jobRepository, BatchEnvironment batchEnvironment) {
        super(jobExecution.getSubstitutedJob().getId());
        this.jobExecution = jobExecution;
        this.batchEnvironment = batchEnvironment;
        this.classLoader = batchEnvironment.getClassLoader();
        this.artifactFactory = artifactFactory;
        this.jobRepository = jobRepository;
        if (originalToRestart != null) {
            this.originalToRestart = originalToRestart;
            this.jobExecution.setRestartPosition(originalToRestart.getRestartPosition());
        }
        PropertyResolver resolver = new PropertyResolver();
        resolver.setJobParameters(jobExecution.getJobParameters());
        resolver.resolve(jobExecution.getSubstitutedJob());
        this.batchArtifacts = ArchiveXmlLoader.loadBatchXml(this.classLoader);
        this.createJobListeners();
    }

    @Override
    public JobContextImpl clone() {
        JobContextImpl result = null;
        try {
            result = (JobContextImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobName(), "");
        }
        result.jobExecution = this.jobExecution.clone();
        return result;
    }

    public boolean isRestart() {
        return this.originalToRestart != null;
    }

    public List<Step> getExecutedSteps() {
        return this.executedSteps;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public JobListener[] getJobListeners() {
        return this.jobListeners;
    }

    public Properties getJobParameters() {
        return this.jobExecution.getJobParameters();
    }

    @Override
    public AbstractContext[] getOuterContexts() {
        return EMPTY_ABSTRACT_CONTEXT_ARRAY;
    }

    public String getJobName() {
        return this.jobExecution.getJobInstance().getJobName();
    }

    public long getInstanceId() {
        return this.jobExecution.getJobInstance().getInstanceId();
    }

    public long getExecutionId() {
        return this.jobExecution.getExecutionId();
    }

    public Properties getProperties() {
        return org.jberet.job.model.Properties.toJavaUtilProperties(this.jobExecution.getSubstitutedJob().getProperties());
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.jobExecution.getBatchStatus();
    }

    @Override
    public String getExitStatus() {
        return this.jobExecution.getExitStatus();
    }

    @Override
    public void setBatchStatus(BatchStatus status) {
        this.jobExecution.setBatchStatus(status);
    }

    @Override
    public void setExitStatus(String status) {
        this.jobExecution.setExitStatus(status);
    }

    @Override
    public JobContextImpl getJobContext() {
        return this;
    }

    public JobExecutionImpl getJobExecution() {
        return this.jobExecution;
    }

    public Job getJob() {
        return this.jobExecution.getSubstitutedJob();
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public BatchArtifacts getBatchArtifacts() {
        return this.batchArtifacts;
    }

    public BatchEnvironment getBatchEnvironment() {
        return this.batchEnvironment;
    }

    public <A> A createArtifact(String ref, Class<?> cls, org.jberet.job.model.Properties props, StepContextImpl ... stepContextForInjection) {
        Object a;
        this.prepareCreationContext(props, stepContextForInjection);
        try {
            a = this.artifactFactory.create(ref, cls, this.classLoader);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToCreateArtifact(e, ref);
        }
        if (a == null) {
            throw BatchMessages.MESSAGES.failToCreateArtifact(null, ref);
        }
        return (A)a;
    }

    public Class<?> getArtifactClass(String ref) {
        this.prepareCreationContext(null, new StepContextImpl[0]);
        return this.artifactFactory.getArtifactClass(ref, this.classLoader);
    }

    private void prepareCreationContext(org.jberet.job.model.Properties props, StepContextImpl ... stepContextForInjection) {
        StepContextImpl sc = stepContextForInjection.length > 0 ? stepContextForInjection[0] : null;
        ArtifactCreationContext.resetArtifactCreationContext(this, sc, props);
    }

    public void destroyArtifact(Object ... objs) {
        for (Object obj : objs) {
            this.artifactFactory.destroy(obj);
        }
    }

    public void destroyArtifact(List<?> list) {
        for (Object obj : list) {
            this.artifactFactory.destroy(obj);
        }
    }

    private void createJobListeners() {
        Listeners listeners = this.jobExecution.getSubstitutedJob().getListeners();
        if (listeners != null) {
            List<RefArtifact> listenerList = listeners.getListeners();
            int count = listenerList.size();
            this.jobListeners = new JobListener[count];
            for (int i = 0; i < count; ++i) {
                RefArtifact listener = listenerList.get(i);
                this.jobListeners[i] = (JobListener)this.createArtifact(listener.getRef(), null, listener.getProperties(), new StepContextImpl[0]);
            }
        } else {
            this.jobListeners = new JobListener[0];
        }
    }
}

