/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support._private;

import com.fasterxml.jackson.core.JsonLocation;
import javax.batch.operations.BatchRuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.util.CsvContext;

@MessageLogger(projectCode="JBERET")
@ValidIdRange(min=60000, max=60999)
public interface SupportLogger
extends BasicLogger {
    public static final SupportLogger LOGGER = (SupportLogger)Logger.getMessageLogger(SupportLogger.class, (String)"org.jberet.support");

    @Message(id=60000, value="Invalid reader or writer property value %s for key %s")
    public BatchRuntimeException invalidReaderWriterProperty(@Cause Throwable var1, String var2, String var3);

    @Message(id=60001, value="Failed to read header from CSV resource %s")
    public BatchRuntimeException failToReadCsvHeader(@Cause Throwable var1, String var2);

    @Message(id=60002, value="Failed to load or instantiate custom type based on property value %s")
    public BatchRuntimeException failToLoadOrCreateCustomType(@Cause Throwable var1, String var2);

    @Message(id=60003, value="Invalid property value format (missing quote): %s")
    public BatchRuntimeException missingQuote(String var1);

    @Message(id=60004, value="Failed to open stream from resource: %s")
    public BatchRuntimeException failToOpenStream(@Cause Throwable var1, String var2);

    @Message(id=60005, value="Invalid position %s to start reading, the configured range is between %s and %s")
    public BatchRuntimeException invalidStartPosition(int var1, int var2, int var3);

    @Message(id=60007, value="Unexpected character %s at position %s in character array %s")
    public BatchRuntimeException unexpectedChar(char var1, int var2, String var3);

    @Message(id=60008, value="Invalid parameters for CellProcessor: %s %s")
    public BatchRuntimeException invalidParamsForCellProcessor(String var1, String[] var2);

    @Message(id=60009, value="Unsupported CellProcessor: %s %s")
    public BatchRuntimeException unsupportedCellProcessor(String var1, String[] var2);

    @Message(id=60010, value="The target writer resource already exists: %s")
    public BatchRuntimeException writerResourceAlreadyExists(Object var1);

    @Message(id=60013, value="The CellProcessor value may be missing an ending single quote: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void maybeMissingEndQuote(String var1);

    @Message(id=60014, value="Failed to parse string %s to enum %s in CsvContext %s for CellProcessor %s")
    public BatchRuntimeException failToParseEnum(@Cause Throwable var1, Object var2, String var3, CsvContext var4, CellProcessor var5);

    @Message(id=60015, value="Unrecognized reader or writer property %s = %s")
    public BatchRuntimeException unrecognizedReaderWriterProperty(String var1, String var2);

    @Message(id=60016, value="Unexpected Json content near %s")
    public BatchRuntimeException unexpectedJsonContent(JsonLocation var1);

    @Message(id=60017, value="Opening resource %s in %s")
    @LogMessage(level=Logger.Level.INFO)
    public void openingResource(String var1, Class<?> var2);

    @Message(id=60018, value="Closing resource %s in %s")
    @LogMessage(level=Logger.Level.INFO)
    public void closingResource(String var1, Class<?> var2);
}

