/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LogMessageCallback;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ValidatorLogger
extends WeldLogger {
    public static final ValidatorLogger LOG = Logger.getMessageLogger(ValidatorLogger.class, Category.VALIDATOR.getName());
    public static final LogMessageCallback INJECTION_INTO_NON_DEPENDENT_BEAN_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.injectionIntoNonDependentBean(params[0]);
        }
    };
    public static final LogMessageCallback INJECTION_INTO_DISPOSER_METHOD_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.injectionIntoDisposerMethod(params[0]);
        }
    };
    public static final LogMessageCallback INJECTION_INTO_NON_BEAN_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.injectionIntoNonBean(params[0]);
        }
    };
    public static final LogMessageCallback INTERCEPTOR_SPECIFIED_TWICE_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.interceptorSpecifiedTwice(params[0], params[1], params[2]);
        }
    };
    public static final LogMessageCallback DECORATOR_SPECIFIED_TWICE_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.decoratorSpecifiedTwice(params[0], params[1], params[2]);
        }
    };
    public static final LogMessageCallback ALTERNATIVE_CLASS_SPECIFIED_MULTIPLE_TIMES_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.alternativeClassSpecifiedMultipleTimes(params[0]);
        }
    };
    public static final LogMessageCallback ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES_CALLBACK = new LogMessageCallback(){

        @Override
        public String invoke(Object ... params) {
            return LOG.alternativeStereotypeSpecifiedMultipleTimes(params[0], params[1], params[2]);
        }
    };

    @Message(id=1401, value="Two beans cannot specialize the same bean {0}", format=Message.Format.MESSAGE_FORMAT)
    public InconsistentSpecializationException beanSpecializedTooManyTimes(Object var1);

    @Message(id=1402, value="The bean {0} declared a passivating scope but has a non-serializable interceptor {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException passivatingBeanWithNonserializableInterceptor(Object var1, Object var2);

    @Message(id=1403, value="The bean {0} declared a passivating scope but has non-serializable decorator {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException passivatingBeanWithNonserializableDecorator(Object var1, Object var2);

    @Message(id=1404, value="The injection point {0} is annotated with @New which cannot be combined with other qualifiers", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException newWithQualifiers(Object var1);

    @Message(id=1405, value="Cannot inject {0} in a class which isn't a bean", format=Message.Format.MESSAGE_FORMAT)
    public String injectionIntoNonBean(Object var1);

    @Message(id=1406, value="Cannot inject {0} in a non @Dependent scoped bean", format=Message.Format.MESSAGE_FORMAT)
    public String injectionIntoNonDependentBean(Object var1);

    @Message(id=1407, value="Cannot declare an injection point with a type variable: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointWithTypeVariable(Object var1);

    @Message(id=1408, value="Unsatisfied dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n{4}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasUnsatisfiedDependencies(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1409, value="Ambiguous dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n  Possible dependencies: {4}\n", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasAmbiguousDependencies(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1410, value="The injection point {0} has non-proxyable dependencies", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException injectionPointHasNonProxyableDependencies(Object var1, @Cause Throwable var2);

    @Deprecated
    @Message(id=1411, value="Injection point {0} has nullable dependencies", format=Message.Format.MESSAGE_FORMAT)
    public String injectionPointHasNullableDependencies(Object var1);

    @Deprecated
    @Message(id=1412, value="The bean {0} declares passivating scope but the producer returned a non-serializable bean for injection:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public String nonSerializableBeanInjectedIntoPassivatingBean(Object var1, Object var2);

    @Message(id=1413, value="The bean {0} declares passivating scope but has non-passivation-capable dependency {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException injectionPointHasNonSerializableDependency(Object var1, Object var2);

    @Message(id=1414, value="Bean name is ambiguous. Name {0} resolves to beans: {1}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException ambiguousElName(Object var1, Object var2);

    @Message(id=1415, value="Bean name is identical to a bean name prefix used elsewhere. Name {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException beanNameIsPrefix(Object var1);

    @Message(id=1416, value="Enabled interceptor class {0} specified twice:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public String interceptorSpecifiedTwice(Object var1, Object var2, Object var3);

    @Message(id=1417, value="Enabled interceptor class {0} does not match an interceptor bean: the class is not found, or not annotated with @Interceptor and still not registered through a portable extension, or not annotated with @Dependent inside an implicit bean archive", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException interceptorClassDoesNotMatchInterceptorBean(Object var1);

    @Message(id=1418, value="Enabled decorator class {0} specified twice:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public String decoratorSpecifiedTwice(Object var1, Object var2, Object var3);

    @Message(id=1419, value="Enabled decorator class {0} is not the bean class of at least one decorator bean (detected decorator beans: {1})", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException decoratorClassNotBeanClassOfDecorator(Object var1, Object var2);

    @Message(id=1420, value="Enabled alternative {0} is not a stereotype", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeStereotypeNotStereotype(Object var1);

    @Message(id=1421, value="Cannot enable the same alternative stereotype {0} in beans.xml:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public String alternativeStereotypeSpecifiedMultipleTimes(Object var1, Object var2, Object var3);

    @Message(id=1422, value="Enabled alternative {0} is not an alternative", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeBeanClassNotAnnotated(Object var1);

    @Deprecated
    @Message(id=1423, value="Cannot enable the same alternative bean class {0} in beans.xml:\n  - {1},\n  - {2}", format=Message.Format.MESSAGE_FORMAT)
    public String alternativeBeanClassSpecifiedMultipleTimes(Object var1, Object var2, Object var3);

    @Message(id=1424, value="The following disposal methods were declared but did not resolve to a producer method: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException disposalMethodsWithoutProducer(Object var1);

    @Message(id=1425, value="An injection point of type {0} cannot have a wildcard type parameter:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointHasWildcard(Object var1, Object var2);

    @Message(id=1426, value="An injection point of type {0} must have a type parameter:  {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException injectionPointMustHaveTypeParameter(Object var1, Object var2);

    @Message(id=1427, value="Only field injection points can use the @Named qualifier with no value. {0} is not a field injection point.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException nonFieldInjectionPointCannotUseNamed(Object var1);

    @Message(id=1428, value="A decorator cannot have producer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveProducerMethods(Object var1);

    @Message(id=1429, value="A decorator cannot have producer fields, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveProducerFields(Object var1);

    @Message(id=1430, value="A decorator cannot have disposer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveDisposerMethods(Object var1);

    @Message(id=1431, value="An interceptor cannot have producer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveProducerMethods(Object var1);

    @Message(id=1432, value="An interceptor cannot have producer fields, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveProducerFields(Object var1);

    @Message(id=1433, value="An interceptor cannot have disposer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveDisposerMethods(Object var1);

    @Message(id=1434, value="Normal scoped bean {0} is not proxyable for an unknown reason - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableUnknown(Object var1, Object var2);

    @Message(id=1435, value="Normal scoped bean {0} is not proxyable because it has no no-args constructor - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableNoConstructor(Object var1, Object var2);

    @Message(id=1436, value="Normal scoped bean {0} is not proxyable because it has a private constructor {1} - {2}.", format=Message.Format.MESSAGE_FORMAT)
    public String notProxyablePrivateConstructor(Object var1, Object var2, Object var3);

    @Message(id=1437, value="Normal scoped bean {0} is not proxyable because the type is final or it contains a final method {1} - {2}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableFinalTypeOrMethod(Object var1, Object var2, Object var3);

    @Message(id=1438, value="Normal scoped bean {0} is not proxyable because it is a primitive - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyablePrimitive(Object var1, Object var2);

    @Message(id=1439, value="Normal scoped bean {0} is not proxyable because it is an array type - {1}.", format=Message.Format.MESSAGE_FORMAT)
    public UnproxyableResolutionException notProxyableArrayType(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1440, value="Scope type {0} used on injection point {1}", format=Message.Format.MESSAGE_FORMAT)
    public void scopeAnnotationOnInjectionPoint(Object var1, Object var2);

    @Message(id=1441, value="Enabled alternative {0} is not a class", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeBeanClassNotClass(Object var1);

    @Message(id=1442, value="Enabled alternative {0} is not annotated @Alternative", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException alternativeStereotypeNotAnnotated(Object var1);

    @Message(id=1443, value="Pseudo scoped bean has circular dependencies. Dependency path: {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException pseudoScopedBeanHasCircularReferences(Object var1);

    @Deprecated
    @Message(id=1444, value="Cannot inject {0} {1} into {2}", format=Message.Format.MESSAGE_FORMAT)
    public String cannotInjectBeanMetadata(Object var1, Object var2, Object var3);

    @Message(id=1445, value="An interceptor cannot have observer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorsCannotHaveObserverMethods(Object var1);

    @Message(id=1446, value="A decorator cannot have observer methods, but at least one was found on {0}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException decoratorsCannotHaveObserverMethods(Object var1);

    @Message(id=1447, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotReturnObject(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1448, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have exactly one parameter.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveExactlyOneParameter(Object var1, Object var2, Object var3);

    @Message(id=1449, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but its single parameter is not a {3}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveCorrectTypeOfParameter(Object var1, Object var2, Object var3, Object var4);

    @Deprecated
    @Message(id=1450, value="Interceptor method {0} does not declare that it throws Exception.", format=Message.Format.MESSAGE_FORMAT)
    public String interceptorMethodDoesNotThrowException(Object var1);

    @Message(id=1451, value="javax.transaction.UserTransaction cannot be injected into an enterprise bean with container-managed transactions {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException userTransactionInjectionIntoBeanWithContainerManagedTransactions(Object var1);

    @Message(id=1452, value="{0} is not a valid type for a Bean metadata injection point {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointType(Object var1, Object var2);

    @Message(id=1453, value="{0} is not a valid type argument for a Bean metadata injection point {1}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointTypeArgument(Object var1, Object var2);

    @Message(id=1454, value="{0} cannot be used at a Bean metadata injection point of a bean which is not {1}, {2}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException invalidBeanMetadataInjectionPointQualifier(Object var1, Object var2, Object var3);

    @Message(id=1455, value="{0} does not declare any decorated types.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException noDecoratedTypes(Object var1);

    @Message(id=1456, value="Argument {0} must not be null", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException argumentNull(Object var1);

    @Message(id=1457, value="Cannot enable the same alternative class {0} in beans.xml", format=Message.Format.MESSAGE_FORMAT)
    public String alternativeClassSpecifiedMultipleTimes(Object var1);

    @Deprecated
    @Message(id=1458, value="Locally disabled {0} does not match any global enablement. {1}", format=Message.Format.MESSAGE_FORMAT)
    public String noGloballyEnabledClassMatchingLocalDisable(Object var1, Object var2);

    @Deprecated
    @Message(id=1459, value="Class {0} is enabled but no priority is set for it. Either enable the class globally by providing the priority attribute or do not use the enabled flag explicitly. {1}", format=Message.Format.MESSAGE_FORMAT)
    public String enabledFlagUsedWithoutPrioritySet(Object var1, Object var2);

    @Deprecated
    @Message(id=1460, value="Globally enabled alternative {0} is not present in the bean archive that enables it globally {1}", format=Message.Format.MESSAGE_FORMAT)
    public String globallyEnabledAlternativeNotInArchive(Object var1, Object var2);

    @Deprecated
    @Message(id=1461, value="Globally enabled interceptor {0} is not present in the bean archive that enables it globally {1}", format=Message.Format.MESSAGE_FORMAT)
    public String globallyEnabledInterceptorNotInArchive(Object var1, Object var2);

    @Deprecated
    @Message(id=1462, value="Globally enabled decorator {0} is not present in the bean archive that enables it globally {1}", format=Message.Format.MESSAGE_FORMAT)
    public String globallyEnabledDecoratorNotInArchive(Object var1, Object var2);

    @Message(id=1463, value="Bean declaring a passivating scope must be passivation capable.  Bean:  {0}", format=Message.Format.MESSAGE_FORMAT)
    public DeploymentException beanWithPassivatingScopeNotPassivationCapable(Object var1);

    @Message(id=1465, value="{0} for a built-in bean {1} must be passivation capable.", format=Message.Format.MESSAGE_FORMAT)
    public UnserializableDependencyException builtinBeanWithNonserializableDecorator(Object var1, Object var2);

    @Message(id=1466, value="Cannot inject {0} in a disposer method", format=Message.Format.MESSAGE_FORMAT)
    public String injectionIntoDisposerMethod(Object var1);

    @Message(id=1467, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3} or {4}.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotReturnObjectOrVoid(Object var1, Object var2, Object var3, Object var4, Object var5);

    @Message(id=1468, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have a {3} return type.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveVoidReturnType(Object var1, Object var2, Object var3, Object var4);

    @Message(id=1469, value="Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have zero parameters.", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMethodDoesNotHaveZeroParameters(Object var1, Object var2, Object var3);

    @Deprecated
    @Message(id=1470, value="Method {0} defined on target class {1} is a @{2} callback method and should not be defined on the target class.", format=Message.Format.MESSAGE_FORMAT)
    public String aroundConstructInterceptorMethodNotAllowedOnTargetClass(Object var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1471, value="Interceptor method {0} defined on class {1} is not defined according to the specification. It should not throw {2}, which is a checked exception.", format=Message.Format.MESSAGE_FORMAT)
    public void interceptorMethodShouldNotThrowCheckedExceptions(Object var1, Object var2, Object var3);

    @Message(id=1472, value="EventMetadata can only be injected into an observer method. {0}", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException eventMetadataInjectedOutsideOfObserver(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1473, value="javax.enterprise.inject.spi.Bean implementation {0} declared a normal scope but does not implement javax.enterprise.inject.spi.PassivationCapable. It won'''t be possible to inject this bean into a bean with passivating scope (@SessionScoped, @ConversationScoped). This can be fixed by assigning the Bean implementation a unique id by implementing the PassivationCapable interface.", format=Message.Format.MESSAGE_FORMAT)
    public void beanNotPassivationCapable(Object var1);

    @Message(id=1474, value="Class {0} is on the classpath, but was ignored because a class it references was not found: {1}.\n", format=Message.Format.MESSAGE_FORMAT)
    public String unsatisfiedDependencyBecauseClassIgnored(Object var1, Object var2);

    @Message(id=1475, value="The following beans match by type, but none have matching qualifiers:{0}\n", format=Message.Format.MESSAGE_FORMAT)
    public String unsatisfiedDependencyBecauseQualifiersDontMatch(Object var1);

    @Message(id=1476, value="{0} must be @Dependent", format=Message.Format.MESSAGE_FORMAT)
    public DefinitionException interceptorMustBeDependent(Object var1);
}

