/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.mongojack.DBRef;
import org.mongojack.internal.MongoSerializer;
import org.mongojack.internal.object.BsonObjectGenerator;
import org.mongojack.internal.stream.DBEncoderBsonGenerator;

public class DBRefSerializer
extends MongoSerializer<DBRef> {
    @Override
    public void serialize(DBRef value, DBEncoderBsonGenerator bgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            bgen.writeNull();
        } else {
            bgen.writeStartObject();
            bgen.writeFieldName("$ref");
            bgen.writeString(value.getCollectionName());
            bgen.writeFieldName("$id");
            bgen.writeObject(value.getId());
            bgen.writeEndObject();
        }
    }

    @Override
    protected void serialize(DBRef value, BsonObjectGenerator bgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            bgen.writeNull();
        } else {
            bgen.writeObject(new com.mongodb.DBRef(null, value.getCollectionName(), value.getId()));
        }
    }

    public Class<DBRef> handledType() {
        return DBRef.class;
    }
}

