/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.ObjectId;
import java.io.IOException;
import java.io.InputStream;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.JacksonDBCollectionProvider;
import org.mongojack.internal.stream.JacksonDBObject;
import org.mongojack.internal.stream.ObjectIdConvertor;

public class DBDecoderBsonParser
extends BsonParser
implements JacksonDBCollectionProvider {
    private final JacksonDBObject<?> dbObject;
    private final JacksonDBCollection dbCollection;

    public DBDecoderBsonParser(IOContext ctxt, int jsonFeatures, InputStream in, JacksonDBObject<?> dbObject, JacksonDBCollection dbCollection, ObjectMapper objectMapper) {
        super(ctxt, jsonFeatures, BsonParser.Feature.HONOR_DOCUMENT_LENGTH.getMask(), in);
        this.dbObject = dbObject;
        this.dbCollection = dbCollection;
        this.setCodec((ObjectCodec)objectMapper);
    }

    public String getText() throws IOException, JsonParseException {
        if (JsonToken.VALUE_EMBEDDED_OBJECT == this.getCurrentToken()) {
            return null;
        }
        return super.getText();
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        Object object = super.getEmbeddedObject();
        if (object instanceof ObjectId) {
            return ObjectIdConvertor.convert((ObjectId)object);
        }
        return object;
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
        if (propertyName.startsWith("$") || propertyName.equals("code")) {
            JsonToken token = this.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                token = this.nextToken();
            }
            if (token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT) {
                this.skipChildren();
            }
            this.dbObject.put(propertyName, this.getEmbeddedObject());
            return true;
        }
        return false;
    }

    @Override
    public JacksonDBCollection getDBCollection() {
        return this.dbCollection;
    }
}

