/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.stream.DBDecoderBsonParser;
import org.mongojack.internal.stream.JacksonDBObject;

public class JacksonDBDecoder<T>
implements DBDecoder {
    private final JacksonDBCollection<T, ?> dbCollection;
    private final ObjectMapper objectMapper;
    private final JavaType type;

    public JacksonDBDecoder(JacksonDBCollection<T, ?> dbCollection, ObjectMapper objectMapper, JavaType type) {
        this.dbCollection = dbCollection;
        this.objectMapper = objectMapper;
        this.type = type;
    }

    public DBCallback getDBCallback(DBCollection collection) {
        throw new UnsupportedOperationException("JacksonDBDecoder does not support callback style decoding");
    }

    public DBObject decode(byte[] b, DBCollection collection) {
        try {
            return this.decode((InputStream)new ByteArrayInputStream(b), collection);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException encountered while reading from a byte array input stream", e);
        }
    }

    public DBObject decode(InputStream in, DBCollection collection) throws IOException {
        JacksonDBObject<Object> decoded = new JacksonDBObject<Object>();
        decoded.setObject(this.objectMapper.readValue((JsonParser)new DBDecoderBsonParser(new IOContext(new BufferRecycler(), (Object)in, false), 0, in, decoded, this.dbCollection, this.objectMapper), this.type));
        return decoded;
    }

    public BSONObject readObject(byte[] b) {
        return this.decode(b, (DBCollection)null);
    }

    public BSONObject readObject(InputStream in) throws IOException {
        return this.decode(in, (DBCollection)null);
    }

    public int decode(byte[] b, BSONCallback callback) {
        throw new UnsupportedOperationException("JacksonDBDecoder does not support callback style decoding");
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        throw new UnsupportedOperationException("JacksonDBDecoder does not support callback style decoding");
    }
}

