/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import org.bson.util.annotations.Immutable;

@Immutable
final class MessageSettings {
    private static final int DEFAULT_MAX_DOCUMENT_SIZE = 0x1000000;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    private final int maxDocumentSize;
    private final int maxMessageSize;

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxDocumentSize() {
        return this.maxDocumentSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    MessageSettings(Builder builder) {
        this.maxDocumentSize = builder.maxDocumentSize;
        this.maxMessageSize = builder.maxMessageSize;
    }

    static final class Builder {
        private int maxDocumentSize = 0x1000000;
        private int maxMessageSize = 0x2000000;

        Builder() {
        }

        public MessageSettings build() {
            return new MessageSettings(this);
        }

        public Builder maxDocumentSize(int maxDocumentSize) {
            this.maxDocumentSize = maxDocumentSize;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }
    }
}

