/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.async.AsyncByteScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import javax.xml.stream.XMLStreamException;

public class AsyncUtfScanner
extends AsyncByteScanner {
    private static final int EVENT_INCOMPLETE = 257;
    private static final int PENDING_STATE_ATTR_VALUE_AMP = -60;
    private static final int PENDING_STATE_ATTR_VALUE_AMP_HASH = -61;
    static final int PENDING_STATE_ATTR_VALUE_AMP_HASH_X = -62;
    private static final int PENDING_STATE_ATTR_VALUE_ENTITY_NAME = -63;
    private static final int PENDING_STATE_ATTR_VALUE_DEC_DIGIT = -64;
    private static final int PENDING_STATE_ATTR_VALUE_HEX_DIGIT = -65;
    private static final int PENDING_STATE_TEXT_AMP = -80;
    private static final int PENDING_STATE_TEXT_AMP_HASH = -81;
    private static final int PENDING_STATE_TEXT_DEC_ENTITY = -82;
    private static final int PENDING_STATE_TEXT_HEX_ENTITY = -83;
    private static final int PENDING_STATE_TEXT_IN_ENTITY = -84;
    private static final int PENDING_STATE_TEXT_BRACKET1 = -85;
    private static final int PENDING_STATE_TEXT_BRACKET2 = -86;
    protected boolean _inDtdDeclaration;

    public AsyncUtfScanner(ReaderConfig readerConfig) {
        super(readerConfig);
        this._currToken = 257;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final int startCharacters(byte by) throws XMLStreamException {
        block20: {
            int n = by & 0xFF;
            switch (this._charTypes.TEXT_CHARS[n]) {
                case 1: {
                    n = this.handleInvalidXmlChar(n);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return 257;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    n = 10;
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n;
                        return 257;
                    }
                    n = this.decodeUtf8_2(n);
                    break;
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                            n |= n2 << 8;
                        }
                        this._pendingInput = n;
                        return 257;
                    }
                    n = this.decodeUtf8_3(n);
                    break;
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            int n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                            n |= n3 << 8;
                            if (this._inputEnd > this._inputPtr) {
                                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                                n |= n3 << 16;
                            }
                        }
                        this._pendingInput = n;
                        return 257;
                    }
                    n = this.decodeUtf8_4(n);
                    this._textBuilder.resetWithSurrogate(n);
                    break block20;
                }
                case 4: {
                    this.reportInvalidInitial(n);
                    break;
                }
                case 9: 
                case 10: {
                    this.throwInternal();
                }
            }
            this._textBuilder.resetWithChar((char)n);
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
            return this._currToken;
        }
        this.finishCharacters();
        return this._currToken;
    }

    @Override
    protected int startCharactersPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        int n = this._pendingInput;
        this._pendingInput = 0;
        if (n == -1) {
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
            this.markLF();
            this._textBuilder.resetWithChar('\n');
        } else {
            switch (this._charTypes.TEXT_CHARS[n & 0xFF]) {
                case 5: {
                    this._textBuilder.resetWithChar((char)this.decodeUtf8_2(n));
                    break;
                }
                case 6: {
                    int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    int n3 = n >> 8;
                    if (n3 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = n | n2 << 8;
                            return 257;
                        }
                        int n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        n = this.decodeUtf8_3(n, n2, n4);
                    } else {
                        n = this.decodeUtf8_3(n & 0xFF, n3, n2);
                    }
                    this._textBuilder.resetWithChar((char)n);
                    break;
                }
                case 7: {
                    int n5 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (n >> 8 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = n | n5 << 8;
                            return 257;
                        }
                        int n6 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = n | n5 << 8 | n6 << 16;
                            return 257;
                        }
                        int n7 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        n = this.decodeUtf8_4(n, n5, n6, n7);
                    } else {
                        int n8 = n >> 8 & 0xFF;
                        int n9 = n >> 16;
                        if (n9 == 0) {
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = n | n5 << 16;
                                return 257;
                            }
                            n9 = this._inputBuffer[this._inputPtr++] & 0xFF;
                            n = this.decodeUtf8_4(n & 0xFF, n8, n5, n9);
                        } else {
                            n = this.decodeUtf8_4(n & 0xFF, n8, n9, n5);
                        }
                    }
                    this._textBuilder.resetWithSurrogate(n);
                    this._currToken = 4;
                    return 4;
                }
                default: {
                    this.throwInternal();
                }
            }
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        return this._currToken;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        if (this._pendingInput != 0) {
            this.throwInternal();
        }
        var1_1 = this._charTypes.TEXT_CHARS;
        var2_2 = this._inputBuffer;
        var3_3 = this._textBuilder.getBufferWithoutReset();
        var4_4 = this._textBuilder.getCurrentLength();
        block12: while ((var6_6 = this._inputPtr) < this._inputEnd) {
            block32: {
                if (var4_4 >= var3_3.length) {
                    var3_3 = this._textBuilder.finishCurrentSegment();
                    var4_4 = 0;
                }
                if ((var8_8 = var6_6 + (var3_3.length - var4_4)) < (var7_7 = this._inputEnd)) {
                    var7_7 = var8_8;
                }
                while (var6_6 < var7_7) {
                    if (var1_1[var5_5 = var2_2[var6_6++] & 255] == 0) {
                        var3_3[var4_4++] = (char)var5_5;
                        continue;
                    }
                    break block32;
                }
                this._inputPtr = var6_6;
                continue;
            }
            this._inputPtr = var6_6;
            switch (var1_1[var5_5]) {
                case 1: {
                    var5_5 = this.handleInvalidXmlChar(var5_5);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        break block12;
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    var5_5 = 10;
                    ** GOTO lbl102
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl102
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = var5_5;
                        break block12;
                    }
                    var5_5 = this.decodeUtf8_2(var5_5);
                    ** GOTO lbl102
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            var6_6 = this._inputBuffer[this._inputPtr++] & 255;
                            var5_5 |= var6_6 << 8;
                        }
                        this._pendingInput = var5_5;
                        break block12;
                    }
                    var5_5 = this.decodeUtf8_3(var5_5);
                    ** GOTO lbl102
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            var6_6 = this._inputBuffer[this._inputPtr++] & 255;
                            var5_5 |= var6_6 << 8;
                            if (this._inputEnd > this._inputPtr) {
                                var6_6 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_5 |= var6_6 << 16;
                            }
                        }
                        this._pendingInput = var5_5;
                        break block12;
                    }
                    var5_5 = this.decodeUtf8_4(var5_5);
                    var3_3[var4_4++] = (char)(55296 | var5_5 >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl102
                }
                case 4: {
                    this.reportInvalidInitial(var5_5);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    var5_5 = this.handleEntityInCharacters();
                    if (var5_5 == 0) {
                        --this._inputPtr;
                        break block12;
                    }
                    if (var5_5 >> 16 == 0) ** GOTO lbl102
                    var3_3[var4_4++] = (char)(55296 | (var5_5 -= 65536) >> 10);
                    if (var4_4 >= var3_3.length) {
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                    var5_5 = 56320 | var5_5 & 1023;
                    ** GOTO lbl102
                }
                case 11: {
                    var6_6 = 1;
                    var7_7 = 0;
                    while (this._inputPtr < this._inputEnd && (var7_7 = var2_2[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++var6_6;
                    }
                    if (var7_7 == 62 && var6_6 > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (--var6_6 > 0) {
                        var3_3[var4_4++] = 93;
                        if (var4_4 < var3_3.length) continue;
                        var3_3 = this._textBuilder.finishCurrentSegment();
                        var4_4 = 0;
                    }
                }
lbl102:
                // 9 sources

                default: {
                    var3_3[var4_4++] = (char)var5_5;
                    continue block12;
                }
            }
        }
        this._textBuilder.setCurrentLength(var4_4);
    }

    @Override
    protected final int finishCharactersCoalescing() throws XMLStreamException {
        if (this._pendingInput != 0 && !this.handleAndAppendPending()) {
            return 257;
        }
        throw new UnsupportedOperationException();
    }

    protected int handleEntityInCharacters() throws XMLStreamException {
        int n = this._inputPtr;
        if (n + 3 <= this._inputEnd) {
            byte by;
            if ((by = this._inputBuffer[n++]) == 35) {
                if (this._inputBuffer[n] == 120) {
                    return this.handleHexEntityInCharacters(n + 1);
                }
                return this.handleDecEntityInCharacters(n);
            }
            if (by == 97) {
                if ((by = this._inputBuffer[n++]) == 109) {
                    if (n + 1 < this._inputPtr && this._inputBuffer[n] == 112 && this._inputBuffer[n + 1] == 59) {
                        this._inputPtr = n + 2;
                        return 38;
                    }
                } else if (by == 112 && n + 2 < this._inputPtr && this._inputBuffer[n] == 111 && this._inputBuffer[n + 1] == 115 && this._inputBuffer[n + 2] == 59) {
                    this._inputPtr = n + 3;
                    return 39;
                }
            } else if (by == 103) {
                if (this._inputBuffer[n] == 116 && this._inputBuffer[n + 1] == 59) {
                    this._inputPtr = n + 2;
                    return 62;
                }
            } else if (by == 108) {
                if (this._inputBuffer[n] == 116 && this._inputBuffer[n + 1] == 59) {
                    this._inputPtr = n + 2;
                    return 60;
                }
            } else if (by == 113 && n + 3 < this._inputPtr && this._inputBuffer[n] == 117 && this._inputBuffer[n + 1] == 111 && this._inputBuffer[n + 2] == 116 && this._inputBuffer[n + 3] == 59) {
                this._inputPtr = n + 4;
                return 39;
            }
        }
        return 0;
    }

    protected int handleDecEntityInCharacters(int n) throws XMLStreamException {
        byte by = this._inputBuffer[n++];
        int n2 = this._inputEnd;
        int n3 = 0;
        do {
            byte by2;
            if ((by2 = by) > 57 || by2 < 48) {
                this.throwUnexpectedChar(this.decodeCharForError(by), " expected a digit (0 - 9) for character entity");
            }
            if ((n3 = n3 * 10 + (by2 - 48)) > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (n < n2) continue;
            return 0;
        } while ((by = this._inputBuffer[n++]) != 59);
        this._inputPtr = n;
        this.verifyXmlChar(n3);
        return n3;
    }

    protected int handleHexEntityInCharacters(int n) throws XMLStreamException {
        int n2 = this._inputBuffer[n++];
        int n3 = this._inputEnd;
        int n4 = 0;
        do {
            int n5;
            if ((n5 = n2) <= 57 && n5 >= 48) {
                n5 -= 48;
            } else if (n5 <= 70 && n5 >= 65) {
                n5 = 10 + (n5 - 65);
            } else if (n5 <= 102 && n5 >= 97) {
                n5 = 10 + (n5 - 97);
            } else {
                this.throwUnexpectedChar(this.decodeCharForError((byte)n2), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            n4 = (n4 << 4) + n5;
            if (n4 > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (n < n3) continue;
            return 0;
        } while ((n2 = this._inputBuffer[n++]) != 59);
        this._inputPtr = n;
        this.verifyXmlChar(n4);
        return n4;
    }

    private final boolean handleAndAppendPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        int n = this._pendingInput;
        this._pendingInput = 0;
        if (n < 0) {
            if (n == -1) {
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                this._textBuilder.append('\n');
                return true;
            }
            this.throwInternal();
        }
        switch (this._charTypes.TEXT_CHARS[n & 0xFF]) {
            case 5: {
                this._textBuilder.append((char)this.decodeUtf8_2(n));
                break;
            }
            case 6: {
                int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                int n3 = n >> 8;
                if (n3 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n2 << 8;
                        return false;
                    }
                    int n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    n = this.decodeUtf8_3(n, n2, n4);
                } else {
                    n = this.decodeUtf8_3(n & 0xFF, n3, n2);
                }
                this._textBuilder.append((char)n);
                break;
            }
            case 7: {
                int n5 = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (n >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8;
                        return false;
                    }
                    int n6 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8 | n6 << 16;
                        return false;
                    }
                    int n7 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    n = this.decodeUtf8_4(n, n5, n6, n7);
                } else {
                    int n8 = n >> 8 & 0xFF;
                    int n9 = n >> 16;
                    if (n9 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = n | n5 << 16;
                            return false;
                        }
                        n9 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        n = this.decodeUtf8_4(n & 0xFF, n8, n5, n9);
                    } else {
                        n = this.decodeUtf8_4(n & 0xFF, n8, n9, n5);
                    }
                }
                this._textBuilder.appendSurrogate(n);
                break;
            }
            default: {
                this.throwInternal();
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean skipCharacters() throws XMLStreamException {
        if (this._pendingInput != 0 && !this.skipPending()) {
            return false;
        }
        var1_1 = this._charTypes.TEXT_CHARS;
        var2_2 = this._inputBuffer;
        block12: while ((var4_4 = this._inputPtr) < (var5_5 = this._inputEnd)) {
            block26: {
                while (var4_4 < var5_5) {
                    if (var1_1[var3_3 = var2_2[var4_4++] & 255] == 0) continue;
                    break block26;
                }
                this._inputPtr = var4_4;
                continue;
            }
            this._inputPtr = var4_4;
            switch (var1_1[var3_3]) {
                case 1: {
                    var3_3 = this.handleInvalidXmlChar(var3_3);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        break block12;
                    }
                    if (var2_2[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = var3_3;
                        break block12;
                    }
                    this.skipUtf8_2(var3_3);
                    ** GOTO lbl76
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            var4_4 = this._inputBuffer[this._inputPtr++] & 255;
                            var3_3 |= var4_4 << 8;
                        }
                        this._pendingInput = var3_3;
                        break block12;
                    }
                    this.decodeUtf8_3(var3_3);
                    ** GOTO lbl76
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            var4_4 = this._inputBuffer[this._inputPtr++] & 255;
                            var3_3 |= var4_4 << 8;
                            if (this._inputEnd > this._inputPtr) {
                                var4_4 = this._inputBuffer[this._inputPtr++] & 255;
                                var3_3 |= var4_4 << 16;
                            }
                        }
                        this._pendingInput = var3_3;
                        break block12;
                    }
                    this.decodeUtf8_4(var3_3);
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(var3_3);
                }
                case 9: {
                    --this._inputPtr;
                    return true;
                }
                case 10: {
                    var3_3 = this.skipEntityInCharacters();
                    if (var3_3 == 0) {
                        this._pendingInput = -80;
                        return this._inputPtr < this._inputEnd && this.skipPending() != false;
                    }
                    ** GOTO lbl76
                }
                case 11: {
                    var4_4 = 1;
                    var5_5 = 0;
                    while (this._inputPtr < this._inputEnd && (var5_5 = var2_2[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++var4_4;
                    }
                    if (var5_5 == 62 && var4_4 > 1) {
                        this.reportIllegalCDataEnd();
                    }
                }
lbl76:
                // 10 sources

                default: {
                    continue block12;
                }
            }
        }
        return false;
    }

    private final boolean skipPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput < 0) {
            do {
                switch (this._pendingInput) {
                    case -1: {
                        this._pendingInput = 0;
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        return true;
                    }
                    case -80: {
                        byte by = this._inputBuffer[this._inputPtr++];
                        if (by == 35) {
                            this._pendingInput = -81;
                            break;
                        }
                        PName pName = this.parseNewEntityName(by);
                        if (pName == null) {
                            this._pendingInput = -84;
                            return false;
                        }
                        int n = this.decodeGeneralEntity(pName);
                        if (n == 0) {
                            this._tokenName = pName;
                            this._nextEvent = 9;
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    case -81: {
                        this._entityValue = 0;
                        if (this._inputBuffer[this._inputPtr] == 120) {
                            ++this._inputPtr;
                            if (this.decodeHexEntity()) {
                                this._pendingInput = 0;
                                return true;
                            }
                            this._pendingInput = -83;
                            return false;
                        }
                        if (this.decodeDecEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        this._pendingInput = -82;
                        return false;
                    }
                    case -82: {
                        if (this.decodeDecEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        return false;
                    }
                    case -83: {
                        if (this.decodeHexEntity()) {
                            this._pendingInput = 0;
                            return true;
                        }
                        return false;
                    }
                    case -84: {
                        PName pName = this.parseEntityName();
                        if (pName == null) {
                            return false;
                        }
                        int n = this.decodeGeneralEntity(pName);
                        if (n == 0) {
                            this._tokenName = pName;
                            this._nextEvent = 9;
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    case -85: {
                        if (this._inputBuffer[this._inputPtr] != 93) {
                            this._pendingInput = 0;
                            return true;
                        }
                        ++this._inputPtr;
                        this._pendingInput = -86;
                        break;
                    }
                    case -86: {
                        byte by = this._inputBuffer[this._inputPtr];
                        if (by == 93) {
                            ++this._inputPtr;
                            break;
                        }
                        if (by == 62) {
                            ++this._inputPtr;
                            this.reportInputProblem("Encountered ']]>' in text segment");
                        }
                        this._pendingInput = 0;
                        return true;
                    }
                    default: {
                        this.throwInternal();
                    }
                }
            } while (this._inputPtr < this._inputEnd);
            return false;
        }
        int n = this._pendingInput;
        switch (this._charTypes.TEXT_CHARS[n & 0xFF]) {
            case 5: {
                this.skipUtf8_2(n);
                break;
            }
            case 6: {
                int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                int n3 = n >> 8;
                if (n3 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n2 << 8;
                        return false;
                    }
                    int n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_3(n, n2, n4);
                    break;
                }
                this.decodeUtf8_3(n & 0xFF, n3, n2);
                break;
            }
            case 7: {
                int n5 = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (n >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8;
                        return false;
                    }
                    int n6 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8 | n6 << 16;
                        return false;
                    }
                    int n7 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_4(n, n5, n6, n7);
                    break;
                }
                int n8 = n >> 8 & 0xFF;
                int n9 = n >> 16;
                if (n9 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 16;
                        return false;
                    }
                    n9 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    this.decodeUtf8_4(n & 0xFF, n8, n5, n9);
                    break;
                }
                this.decodeUtf8_4(n & 0xFF, n8, n9, n5);
                break;
            }
            default: {
                this.throwInternal();
            }
        }
        this._pendingInput = 0;
        return true;
    }

    private int skipEntityInCharacters() throws XMLStreamException {
        int n = this._inputPtr;
        if (n + 3 <= this._inputEnd) {
            byte by;
            if ((by = this._inputBuffer[n++]) == 35) {
                if (this._inputBuffer[n] == 120) {
                    return this.handleHexEntityInCharacters(n + 1);
                }
                return this.handleDecEntityInCharacters(n);
            }
            if (by == 97) {
                if ((by = this._inputBuffer[n++]) == 109) {
                    if (n + 1 < this._inputPtr && this._inputBuffer[n] == 112 && this._inputBuffer[n + 1] == 59) {
                        this._inputPtr = n + 2;
                        return 38;
                    }
                } else if (by == 112 && n + 2 < this._inputPtr && this._inputBuffer[n] == 111 && this._inputBuffer[n + 1] == 115 && this._inputBuffer[n + 2] == 59) {
                    this._inputPtr = n + 3;
                    return 39;
                }
            } else if (by == 103) {
                if (this._inputBuffer[n] == 116 && this._inputBuffer[n + 1] == 59) {
                    this._inputPtr = n + 2;
                    return 62;
                }
            } else if (by == 108) {
                if (this._inputBuffer[n] == 116 && this._inputBuffer[n + 1] == 59) {
                    this._inputPtr = n + 2;
                    return 60;
                }
            } else if (by == 113 && n + 3 < this._inputPtr && this._inputBuffer[n] == 117 && this._inputBuffer[n + 1] == 111 && this._inputBuffer[n + 2] == 116 && this._inputBuffer[n + 3] == 59) {
                this._inputPtr = n + 4;
                return 39;
            }
        }
        return 0;
    }

    @Override
    protected boolean skipCoalescedText() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleAttrValue() throws XMLStreamException {
        if (this._pendingInput != 0) {
            if (!this.handleAttrValuePending()) {
                return false;
            }
            this._pendingInput = 0;
        }
        var1_1 = this._attrCollector.continueValue();
        var2_2 = this._charTypes.ATTR_CHARS;
        var3_3 = this._elemAttrQuote;
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this._elemAttrPtr >= var1_1.length) {
                var1_1 = this._attrCollector.valueBufferFull();
            }
            if ((var6_6 = this._inputPtr + (var1_1.length - this._elemAttrPtr)) < (var5_5 = this._inputEnd)) {
                var5_5 = var6_6;
            }
            while (true) {
                if (this._inputPtr >= var5_5) continue block13;
                if (var2_2[var4_4 = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                var1_1[this._elemAttrPtr++] = (char)var4_4;
            }
            switch (var2_2[var4_4]) {
                case 1: {
                    var4_4 = this.handleInvalidXmlChar(var4_4);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    var4_4 = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_2(var4_4);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                            var4_4 |= var5_5 << 8;
                        }
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_3(var4_4);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                            var4_4 |= var5_5 << 8;
                            if (this._inputEnd > this._inputPtr) {
                                var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                                var4_4 |= var5_5 << 16;
                            }
                        }
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_4(var4_4);
                    var1_1[this._elemAttrPtr++] = (char)(55296 | var4_4 >> 10);
                    var4_4 = 56320 | var4_4 & 1023;
                    if (this._elemAttrPtr >= var1_1.length) {
                        var1_1 = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(var4_4);
                }
                case 9: {
                    this.throwUnexpectedChar(var4_4, "'<' not allowed in attribute value");
                }
                case 10: {
                    var4_4 = this.handleEntityInAttributeValue();
                    if (var4_4 <= 0) {
                        if (var4_4 < 0) {
                            return false;
                        }
                        this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                    }
                    if (var4_4 >> 16 != 0) {
                        var1_1[this._elemAttrPtr++] = (char)(55296 | (var4_4 -= 65536) >> 10);
                        var4_4 = 56320 | var4_4 & 1023;
                        if (this._elemAttrPtr >= var1_1.length) {
                            var1_1 = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (var4_4 == var3_3) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    var1_1[this._elemAttrPtr++] = (char)var4_4;
                    continue block13;
                }
            }
            break;
        }
        return true;
    }

    private final boolean handleAttrValuePending() throws XMLStreamException {
        int n;
        if (this._pendingInput == -1) {
            if (!this.handlePartialCR()) {
                return false;
            }
            char[] cArray = this._attrCollector.continueValue();
            if (this._elemAttrPtr >= cArray.length) {
                cArray = this._attrCollector.valueBufferFull();
            }
            cArray[this._elemAttrPtr++] = 32;
            return true;
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput == -60) {
            byte by;
            if ((by = this._inputBuffer[this._inputPtr++]) == 35) {
                this._pendingInput = -61;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr] == 120) {
                    this._pendingInput = -62;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        return false;
                    }
                    n = this.handleHexEntityInAttribute(true);
                } else {
                    n = this.handleDecEntityInAttribute(true);
                }
            } else {
                PName pName = this.parseNewEntityName(by);
                if (pName == null) {
                    this._pendingInput = -63;
                    return false;
                }
                n = this.decodeGeneralEntity(pName);
                if (n == 0) {
                    this._tokenName = pName;
                    this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                }
            }
        } else if (this._pendingInput == -61) {
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                n = this.handleHexEntityInAttribute(true);
            } else {
                n = this.handleDecEntityInAttribute(true);
            }
        } else if (this._pendingInput == -62) {
            n = this.handleHexEntityInAttribute(true);
        } else if (this._pendingInput == -63) {
            PName pName = this.parseEntityName();
            if (pName == null) {
                return false;
            }
            n = this.decodeGeneralEntity(pName);
            if (n == 0) {
                this._tokenName = pName;
                this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
            }
        } else {
            n = this._pendingInput == -64 ? this.handleDecEntityInAttribute(false) : (this._pendingInput == -65 ? this.handleHexEntityInAttribute(false) : this.handleAttrValuePendingUTF8());
        }
        if (n == 0) {
            return false;
        }
        char[] cArray = this._attrCollector.continueValue();
        if (n >> 16 != 0) {
            n -= 65536;
            if (this._elemAttrPtr >= cArray.length) {
                cArray = this._attrCollector.valueBufferFull();
            }
            cArray[this._elemAttrPtr++] = (char)(0xD800 | n >> 10);
            n = 0xDC00 | n & 0x3FF;
        }
        if (this._elemAttrPtr >= cArray.length) {
            cArray = this._attrCollector.valueBufferFull();
        }
        cArray[this._elemAttrPtr++] = (char)n;
        return true;
    }

    private final int handleAttrValuePendingUTF8() throws XMLStreamException {
        int n = this._pendingInput;
        this._pendingInput = 0;
        switch (this._charTypes.TEXT_CHARS[n & 0xFF]) {
            case 5: {
                return this.decodeUtf8_2(n);
            }
            case 6: {
                int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                int n3 = n >> 8;
                if (n3 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n2 << 8;
                        return 0;
                    }
                    int n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    n = this.decodeUtf8_3(n, n2, n4);
                } else {
                    n = this.decodeUtf8_3(n & 0xFF, n3, n2);
                }
                return n;
            }
            case 7: {
                int n5 = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (n >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8;
                        return 0;
                    }
                    int n6 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = n | n5 << 8 | n6 << 16;
                        return 0;
                    }
                    int n7 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    n = this.decodeUtf8_4(n, n5, n6, n7);
                } else {
                    int n8 = n >> 8 & 0xFF;
                    int n9 = n >> 16;
                    if (n9 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = n | n5 << 16;
                            return 0;
                        }
                        n9 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        n = this.decodeUtf8_4(n & 0xFF, n8, n5, n9);
                    } else {
                        n = this.decodeUtf8_4(n & 0xFF, n8, n9, n5);
                    }
                }
                return n;
            }
        }
        this.throwInternal();
        return 0;
    }

    private final int handleDecEntityInAttribute(boolean bl) throws XMLStreamException {
        byte by;
        byte by2 = this._inputBuffer[this._inputPtr++];
        if (bl) {
            by = by2;
            if (by < 48 || by > 57) {
                this.throwUnexpectedChar(this.decodeCharForError(by2), " expected a digit (0 - 9) for character entity");
            }
            this._pendingInput = -64;
            this._entityValue = by - 48;
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            by2 = this._inputBuffer[this._inputPtr++];
        }
        while (by2 != 59) {
            int n;
            by = by2 - 48;
            if (by < 0 || by > 9) {
                this.throwUnexpectedChar(this.decodeCharForError(by2), " expected a digit (0 - 9) for character entity");
            }
            this._entityValue = n = this._entityValue * 10 + by;
            if (n > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            by2 = this._inputBuffer[this._inputPtr++];
        }
        this.verifyXmlChar(this._entityValue);
        this._pendingInput = 0;
        return this._entityValue;
    }

    private final int handleHexEntityInAttribute(boolean bl) throws XMLStreamException {
        int n;
        int n2 = this._inputBuffer[this._inputPtr++];
        if (bl) {
            n = n2;
            if (n < 48 || n > 57) {
                this.throwUnexpectedChar(this.decodeCharForError((byte)n2), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            this._pendingInput = -65;
            this._entityValue = n - 48;
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            n2 = this._inputBuffer[this._inputPtr++];
        }
        while (n2 != 59) {
            int n3;
            n = n2;
            if (n <= 57 && n >= 48) {
                n -= 48;
            } else if (n <= 70 && n >= 65) {
                n = 10 + (n - 65);
            } else if (n <= 102 && n >= 97) {
                n = 10 + (n - 97);
            } else {
                this.throwUnexpectedChar(this.decodeCharForError((byte)n2), " expected a hex digit (0-9a-fA-F) for character entity");
            }
            this._entityValue = n3 = (this._entityValue << 4) + n;
            if (n3 > 0x10FFFF) {
                this.reportEntityOverflow();
            }
            if (this._inputPtr >= this._inputEnd) {
                return 0;
            }
            n2 = this._inputBuffer[this._inputPtr++];
        }
        this.verifyXmlChar(this._entityValue);
        this._pendingInput = 0;
        return this._entityValue;
    }

    protected int handleEntityInAttributeValue() throws XMLStreamException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._pendingInput = -60;
            return -1;
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 35) {
            int n;
            this._pendingInput = -61;
            if (this._inputPtr >= this._inputEnd) {
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return -1;
                }
                n = this.handleHexEntityInAttribute(true);
            } else {
                n = this.handleDecEntityInAttribute(true);
            }
            if (n == 0) {
                return -1;
            }
            return n;
        }
        PName pName = this.parseNewEntityName(by);
        if (pName == null) {
            this._pendingInput = -63;
            return -1;
        }
        int n = this.decodeGeneralEntity(pName);
        if (n != 0) {
            return n;
        }
        this._tokenName = pName;
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleNsDecl() throws XMLStreamException {
        var1_1 = this._charTypes.ATTR_CHARS;
        var2_2 = this._nameBuffer;
        var3_3 = this._elemAttrQuote;
        if (this._pendingInput != 0) {
            if (!this.handleNsValuePending()) {
                return false;
            }
            this._pendingInput = 0;
        }
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this._elemNsPtr >= var2_2.length) {
                this._nameBuffer = var2_2 = DataUtil.growArrayBy(var2_2, var2_2.length);
            }
            if ((var6_7 = this._inputPtr + (var2_2.length - this._elemNsPtr)) < (var5_5 = this._inputEnd)) {
                var5_5 = var6_7;
            }
            while (true) {
                if (this._inputPtr >= var5_5) continue block13;
                if (var1_1[var4_4 = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                var2_2[this._elemNsPtr++] = (char)var4_4;
            }
            switch (var1_1[var4_4]) {
                case 1: {
                    var4_4 = this.handleInvalidXmlChar(var4_4);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    var4_4 = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_2(var4_4);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                            var4_4 |= var5_5 << 8;
                        }
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_3(var4_4);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                            var4_4 |= var5_5 << 8;
                            if (this._inputEnd > this._inputPtr) {
                                var5_5 = this._inputBuffer[this._inputPtr++] & 255;
                                var4_4 |= var5_5 << 16;
                            }
                        }
                        this._pendingInput = var4_4;
                        return false;
                    }
                    var4_4 = this.decodeUtf8_4(var4_4);
                    var2_2[this._elemNsPtr++] = (char)(55296 | var4_4 >> 10);
                    var4_4 = 56320 | var4_4 & 1023;
                    if (this._elemNsPtr >= var2_2.length) {
                        this._nameBuffer = var2_2 = DataUtil.growArrayBy(var2_2, var2_2.length);
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(var4_4);
                }
                case 9: {
                    this.throwUnexpectedChar(var4_4, "'<' not allowed in attribute value");
                }
                case 10: {
                    var4_4 = this.handleEntityInAttributeValue();
                    if (var4_4 <= 0) {
                        if (var4_4 < 0) {
                            return false;
                        }
                        this.reportUnexpandedEntityInAttr(this._elemAttrName, true);
                    }
                    if (var4_4 >> 16 != 0) {
                        var2_2[this._elemNsPtr++] = (char)(55296 | (var4_4 -= 65536) >> 10);
                        var4_4 = 56320 | var4_4 & 1023;
                        if (this._elemNsPtr >= var2_2.length) {
                            this._nameBuffer = var2_2 = DataUtil.growArrayBy(var2_2, var2_2.length);
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (var4_4 == var3_3) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    var2_2[this._elemNsPtr++] = (char)var4_4;
                    continue block13;
                }
            }
            break;
        }
        var4_4 = this._elemNsPtr;
        if (var4_4 == 0) {
            this.bindNs(this._elemAttrName, "");
        } else {
            var5_6 = this._config.canonicalizeURI(var2_2, var4_4);
            this.bindNs(this._elemAttrName, var5_6);
        }
        return true;
    }

    private final boolean handleNsValuePending() throws XMLStreamException {
        int n;
        if (this._pendingInput == -1) {
            if (!this.handlePartialCR()) {
                return false;
            }
            char[] cArray = this._nameBuffer;
            if (this._elemNsPtr >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[this._elemNsPtr++] = 32;
            return true;
        }
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        if (this._pendingInput == -60) {
            byte by;
            if ((by = this._inputBuffer[this._inputPtr++]) == 35) {
                this._pendingInput = -61;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr] == 120) {
                    this._pendingInput = -62;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        return false;
                    }
                    n = this.handleHexEntityInAttribute(true);
                } else {
                    n = this.handleDecEntityInAttribute(true);
                }
            } else {
                PName pName = this.parseNewEntityName(by);
                if (pName == null) {
                    this._pendingInput = -63;
                    return false;
                }
                n = this.decodeGeneralEntity(pName);
                if (n == 0) {
                    this._tokenName = pName;
                    this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
                }
            }
        } else if (this._pendingInput == -61) {
            if (this._inputBuffer[this._inputPtr] == 120) {
                this._pendingInput = -62;
                ++this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    return false;
                }
                n = this.handleHexEntityInAttribute(true);
            } else {
                n = this.handleDecEntityInAttribute(true);
            }
        } else if (this._pendingInput == -62) {
            n = this.handleHexEntityInAttribute(true);
        } else if (this._pendingInput == -63) {
            PName pName = this.parseEntityName();
            if (pName == null) {
                return false;
            }
            n = this.decodeGeneralEntity(pName);
            if (n == 0) {
                this._tokenName = pName;
                this.reportUnexpandedEntityInAttr(this._elemAttrName, false);
            }
        } else {
            n = this._pendingInput == -64 ? this.handleDecEntityInAttribute(false) : (this._pendingInput == -65 ? this.handleHexEntityInAttribute(false) : this.handleAttrValuePendingUTF8());
        }
        if (n == 0) {
            return false;
        }
        char[] cArray = this._nameBuffer;
        if (n >> 16 != 0) {
            n -= 65536;
            if (this._elemNsPtr >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[this._elemNsPtr++] = (char)(0xD800 | n >> 10);
            n = 0xDC00 | n & 0x3FF;
        }
        if (this._elemNsPtr >= cArray.length) {
            this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
        }
        cArray[this._elemNsPtr++] = (char)n;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final boolean handleDTDInternalSubset(boolean var1_1) throws XMLStreamException {
        if (var1_1) {
            var2_2 = this._textBuilder.resetWithEmpty();
            var3_3 = 0;
            this._elemAttrQuote = 0;
            this._inDtdDeclaration = false;
        } else {
            if (this._pendingInput != 0 && !this.handleAndAppendPending()) {
                return false;
            }
            var2_2 = this._textBuilder.getBufferWithoutReset();
            var3_3 = this._textBuilder.getCurrentLength();
        }
        var4_4 = this._charTypes.DTD_CHARS;
        var5_5 = this._inputBuffer;
        block13: while (this._inputPtr < this._inputEnd) {
            if (var3_3 >= var2_2.length) {
                var2_2 = this._textBuilder.finishCurrentSegment();
                var3_3 = 0;
            }
            if ((var8_8 = this._inputPtr + (var2_2.length - var3_3)) < (var7_7 = this._inputEnd)) {
                var7_7 = var8_8;
            }
            while (this._inputPtr < var7_7) {
                if (var4_4[var6_6 = var5_5[this._inputPtr++] & 255] == 0) {
                    var2_2[var3_3++] = (char)var6_6;
                    continue;
                }
                switch (var4_4[var6_6]) {
                    case 1: {
                        var6_6 = this.handleInvalidXmlChar(var6_6);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block13;
                        }
                        if (var5_5[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        var6_6 = 10;
                        ** GOTO lbl91
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl91
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = var6_6;
                            break block13;
                        }
                        var6_6 = this.decodeUtf8_2(var6_6);
                        ** GOTO lbl91
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                var7_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var6_6 |= var7_7 << 8;
                            }
                            this._pendingInput = var6_6;
                            break block13;
                        }
                        var6_6 = this.decodeUtf8_3(var6_6);
                        ** GOTO lbl91
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                var7_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var6_6 |= var7_7 << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    var7_7 = this._inputBuffer[this._inputPtr++] & 255;
                                    var6_6 |= var7_7 << 16;
                                }
                            }
                            this._pendingInput = var6_6;
                            break block13;
                        }
                        var6_6 = this.decodeUtf8_4(var6_6);
                        var2_2[var3_3++] = (char)(55296 | var6_6 >> 10);
                        if (var3_3 >= var2_2.length) {
                            var2_2 = this._textBuilder.finishCurrentSegment();
                            var3_3 = 0;
                        }
                        var6_6 = 56320 | var6_6 & 1023;
                        ** GOTO lbl91
                    }
                    case 4: {
                        this.reportInvalidInitial(var6_6);
                    }
                    case 8: {
                        if (this._elemAttrQuote == 0) {
                            this._elemAttrQuote = (byte)var6_6;
                        } else if (this._elemAttrQuote == var6_6) {
                            this._elemAttrQuote = 0;
                        }
                        ** GOTO lbl91
                    }
                    case 9: {
                        if (!this._inDtdDeclaration) {
                            this._inDtdDeclaration = true;
                        }
                        ** GOTO lbl91
                    }
                    case 10: {
                        if (this._elemAttrQuote == 0) {
                            this._inDtdDeclaration = false;
                        }
                        ** GOTO lbl91
                    }
                    case 11: {
                        if (!this._inDtdDeclaration && this._elemAttrQuote == 0) {
                            this._textBuilder.setCurrentLength(var3_3);
                            return true;
                        }
                    }
lbl91:
                    // 12 sources

                    default: {
                        var2_2[var3_3++] = (char)var6_6;
                        continue block13;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(var3_3);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parseCommentContents() throws XMLStreamException {
        if (this._pendingInput != 0 && (var1_1 = this.handleCommentPending()) != 0) {
            return var1_1;
        }
        var1_2 = this._textBuilder.getBufferWithoutReset();
        var2_3 = this._textBuilder.getCurrentLength();
        var3_4 = this._charTypes.OTHER_CHARS;
        var4_5 = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (var2_3 >= var1_2.length) {
                var1_2 = this._textBuilder.finishCurrentSegment();
                var2_3 = 0;
            }
            if ((var7_8 = this._inputPtr + (var1_2.length - var2_3)) < (var6_7 = this._inputEnd)) {
                var6_7 = var7_8;
            }
            while (this._inputPtr < var6_7) {
                if (var3_4[var5_6 = var4_5[this._inputPtr++] & 255] == 0) {
                    var1_2[var2_3++] = (char)var5_6;
                    continue;
                }
                switch (var3_4[var5_6]) {
                    case 1: {
                        var5_6 = this.handleInvalidXmlChar(var5_6);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (var4_5[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        var5_6 = 10;
                        ** GOTO lbl81
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl81
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_2(var5_6);
                        ** GOTO lbl81
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_3(var5_6);
                        ** GOTO lbl81
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                    var5_6 |= var6_7 << 16;
                                }
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_4(var5_6);
                        var1_2[var2_3++] = (char)(55296 | var5_6 >> 10);
                        if (var2_3 >= var1_2.length) {
                            var1_2 = this._textBuilder.finishCurrentSegment();
                            var2_3 = 0;
                        }
                        var5_6 = 56320 | var5_6 & 1023;
                        ** GOTO lbl81
                    }
                    case 4: {
                        this.reportInvalidInitial(var5_6);
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -20;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 45) {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this._pendingInput = -21;
                                break block10;
                            }
                            if (this._inputBuffer[this._inputPtr++] != 62) {
                                this.reportDoubleHyphenInComments();
                            }
                            this._textBuilder.setCurrentLength(var2_3);
                            this._state = 0;
                            this._nextEvent = 257;
                            return 5;
                        }
                    }
lbl81:
                    // 8 sources

                    default: {
                        var1_2[var2_3++] = (char)var5_6;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(var2_3);
        return 257;
    }

    protected final int handleCommentPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        if (this._pendingInput == -20) {
            if (this._inputBuffer[this._inputPtr] != 45) {
                this._pendingInput = 0;
                this._textBuilder.append("-");
                return 0;
            }
            ++this._inputPtr;
            this._pendingInput = -21;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
        }
        if (this._pendingInput == -21) {
            byte by;
            this._pendingInput = 0;
            if ((by = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportDoubleHyphenInComments();
            }
            this._state = 0;
            this._nextEvent = 257;
            return 5;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parseCDataContents() throws XMLStreamException {
        if (this._pendingInput != 0 && (var1_1 = this.handleCDataPending()) != 0) {
            return var1_1;
        }
        var1_2 = this._textBuilder.getBufferWithoutReset();
        var2_3 = this._textBuilder.getCurrentLength();
        var3_4 = this._charTypes.OTHER_CHARS;
        var4_5 = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (var2_3 >= var1_2.length) {
                var1_2 = this._textBuilder.finishCurrentSegment();
                var2_3 = 0;
            }
            if ((var7_8 = this._inputPtr + (var1_2.length - var2_3)) < (var6_7 = this._inputEnd)) {
                var6_7 = var7_8;
            }
            while (this._inputPtr < var6_7) {
                if (var3_4[var5_6 = var4_5[this._inputPtr++] & 255] == 0) {
                    var1_2[var2_3++] = (char)var5_6;
                    continue;
                }
                switch (var3_4[var5_6]) {
                    case 1: {
                        var5_6 = this.handleInvalidXmlChar(var5_6);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (var4_5[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        var5_6 = 10;
                        ** GOTO lbl95
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl95
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_2(var5_6);
                        ** GOTO lbl95
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_3(var5_6);
                        ** GOTO lbl95
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                    var5_6 |= var6_7 << 16;
                                }
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_4(var5_6);
                        var1_2[var2_3++] = (char)(55296 | var5_6 >> 10);
                        if (var2_3 >= var1_2.length) {
                            var1_2 = this._textBuilder.finishCurrentSegment();
                            var2_3 = 0;
                        }
                        var5_6 = 56320 | var5_6 & 1023;
                        ** GOTO lbl95
                    }
                    case 4: {
                        this.reportInvalidInitial(var5_6);
                    }
                    case 11: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -30;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 93) {
                            ++this._inputPtr;
                            while (true) {
                                if (this._inputPtr >= this._inputEnd) {
                                    this._pendingInput = -31;
                                    break block10;
                                }
                                if (this._inputBuffer[this._inputPtr] == 62) {
                                    ++this._inputPtr;
                                    this._textBuilder.setCurrentLength(var2_3);
                                    this._state = 0;
                                    this._nextEvent = 257;
                                    return 12;
                                }
                                if (this._inputBuffer[this._inputPtr] != 93) {
                                    var1_2[var2_3++] = 93;
                                    if (var2_3 >= var1_2.length) {
                                        var1_2 = this._textBuilder.finishCurrentSegment();
                                        var2_3 = 0;
                                    }
                                    var1_2[var2_3++] = 93;
                                    continue block10;
                                }
                                ++this._inputPtr;
                                var1_2[var2_3++] = 93;
                                if (var2_3 < var1_2.length) continue;
                                var1_2 = this._textBuilder.finishCurrentSegment();
                                var2_3 = 0;
                            }
                        }
                    }
lbl95:
                    // 8 sources

                    default: {
                        var1_2[var2_3++] = (char)var5_6;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(var2_3);
        return 257;
    }

    protected final int handleCDataPending() throws XMLStreamException {
        if (this._pendingInput == -30) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if (this._inputBuffer[this._inputPtr] != 93) {
                this._textBuilder.append(']');
                this._pendingInput = 0;
                return 0;
            }
            ++this._inputPtr;
            this._pendingInput = -31;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
        }
        while (this._pendingInput == -31) {
            byte by;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if ((by = this._inputBuffer[this._inputPtr++]) == 62) {
                this._pendingInput = 0;
                this._state = 0;
                this._nextEvent = 257;
                return 12;
            }
            if (by != 93) {
                --this._inputPtr;
                this._textBuilder.append("]]");
                this._pendingInput = 0;
                return 0;
            }
            this._textBuilder.append(']');
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parsePIData() throws XMLStreamException {
        if (this._pendingInput != 0 && (var1_1 = this.handlePIPending()) != 0) {
            return var1_1;
        }
        var1_2 = this._textBuilder.getBufferWithoutReset();
        var2_3 = this._textBuilder.getCurrentLength();
        var3_4 = this._charTypes.OTHER_CHARS;
        var4_5 = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (var2_3 >= var1_2.length) {
                var1_2 = this._textBuilder.finishCurrentSegment();
                var2_3 = 0;
            }
            if ((var7_8 = this._inputPtr + (var1_2.length - var2_3)) < (var6_7 = this._inputEnd)) {
                var6_7 = var7_8;
            }
            while (this._inputPtr < var6_7) {
                if (var3_4[var5_6 = var4_5[this._inputPtr++] & 255] == 0) {
                    var1_2[var2_3++] = (char)var5_6;
                    continue;
                }
                switch (var3_4[var5_6]) {
                    case 1: {
                        var5_6 = this.handleInvalidXmlChar(var5_6);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -1;
                            break block10;
                        }
                        if (var4_5[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        var5_6 = 10;
                        ** GOTO lbl76
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl76
                    }
                    case 5: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_2(var5_6);
                        ** GOTO lbl76
                    }
                    case 6: {
                        if (this._inputEnd - this._inputPtr < 2) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_3(var5_6);
                        ** GOTO lbl76
                    }
                    case 7: {
                        if (this._inputEnd - this._inputPtr < 3) {
                            if (this._inputEnd > this._inputPtr) {
                                var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                var5_6 |= var6_7 << 8;
                                if (this._inputEnd > this._inputPtr) {
                                    var6_7 = this._inputBuffer[this._inputPtr++] & 255;
                                    var5_6 |= var6_7 << 16;
                                }
                            }
                            this._pendingInput = var5_6;
                            break block10;
                        }
                        var5_6 = this.decodeUtf8_4(var5_6);
                        var1_2[var2_3++] = (char)(55296 | var5_6 >> 10);
                        if (var2_3 >= var1_2.length) {
                            var1_2 = this._textBuilder.finishCurrentSegment();
                            var2_3 = 0;
                        }
                        var5_6 = 56320 | var5_6 & 1023;
                        ** GOTO lbl76
                    }
                    case 4: {
                        this.reportInvalidInitial(var5_6);
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._pendingInput = -15;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 62) {
                            ++this._inputPtr;
                            this._textBuilder.setCurrentLength(var2_3);
                            this._state = 0;
                            this._nextEvent = 257;
                            return 3;
                        }
                    }
lbl76:
                    // 8 sources

                    default: {
                        var1_2[var2_3++] = (char)var5_6;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(var2_3);
        return 257;
    }

    protected final int handlePIPending() throws XMLStreamException {
        if (this._pendingInput == -15) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            byte by = this._inputBuffer[this._inputPtr];
            this._pendingInput = 0;
            if (by != 62) {
                this._textBuilder.append('?');
                return 0;
            }
            ++this._inputPtr;
            this._state = 0;
            this._nextEvent = 257;
            return 3;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    protected final int decodeUtf8_2(int n) throws XMLStreamException {
        byte by;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    protected final void skipUtf8_2(int n) throws XMLStreamException {
        byte by;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    protected final int decodeUtf8_3(int n) throws XMLStreamException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        if (n >= 13 && n2 >= 55296 && (n2 < 57344 || n2 >= 65534 && n2 <= 65535)) {
            n2 = this.handleInvalidXmlChar(n2);
        }
        return n2;
    }

    protected final int decodeUtf8_3(int n, int n2, int n3) throws XMLStreamException {
        if ((n2 & 0xC0) != 128) {
            this.reportInvalidOther(n2 & 0xFF, this._inputPtr - 1);
        }
        if ((n3 & 0xC0) != 128) {
            this.reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        int n4 = (n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F;
        if (n >= 13 && n4 >= 55296 && (n4 < 57344 || n4 >= 65534 && n4 <= 65535)) {
            n4 = this.handleInvalidXmlChar(n4);
        }
        return n4;
    }

    protected final int decodeUtf8_4(int n) throws XMLStreamException {
        byte by;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    protected final int decodeUtf8_4(int n, int n2, int n3, int n4) throws XMLStreamException {
        if ((n2 & 0xC0) != 128) {
            this.reportInvalidOther(n2 & 0xFF, this._inputPtr - 2);
        }
        int n5 = (n & 7) << 6 | n2 & 0x3F;
        if ((n3 & 0xC0) != 128) {
            this.reportInvalidOther(n3 & 0xFF, this._inputPtr - 1);
        }
        n5 = n5 << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            this.reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        return (n5 << 6 | n4 & 0x3F) - 65536;
    }

    @Override
    protected final PName addPName(int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        return this.addUtfPName(this._charTypes, n, nArray, n2, n3);
    }

    @Override
    protected void reportInvalidInitial(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    @Override
    protected void reportInvalidOther(int n) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void reportInvalidOther(int n, int n2) throws XMLStreamException {
        this._inputPtr = n2;
        this.reportInvalidOther(n);
    }
}

