/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.XmlConsts;
import java.io.IOException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public abstract class InputBootstrapper
implements XmlConsts {
    public static final String ERR_XMLDECL_KW_VERSION = "; expected keyword 'version'";
    public static final String ERR_XMLDECL_KW_ENCODING = "; expected keyword 'encoding'";
    public static final String ERR_XMLDECL_KW_STANDALONE = "; expected keyword 'standalone'";
    public static final String ERR_XMLDECL_END_MARKER = "; expected \"?>\" end marker";
    public static final String ERR_XMLDECL_EXP_SPACE = "; expected a white space";
    public static final String ERR_XMLDECL_EXP_EQ = "; expected '=' after ";
    public static final String ERR_XMLDECL_EXP_ATTRVAL = "; expected a quote character enclosing value for ";
    protected int _inputProcessed = 0;
    protected int _inputRow = 0;
    protected int _inputRowStart = 0;
    final ReaderConfig _config;
    int mDeclaredXmlVersion = 0;
    String mFoundEncoding;
    String mStandalone;
    final char[] mKeyword;

    protected InputBootstrapper(ReaderConfig readerConfig) {
        this._config = readerConfig;
        this.mKeyword = readerConfig.allocSmallCBuffer(60);
    }

    public final XmlScanner bootstrap() throws XMLStreamException {
        try {
            XmlScanner xmlScanner = this.doBootstrap();
            return xmlScanner;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        finally {
            this._config.freeSmallCBuffer(this.mKeyword);
        }
    }

    public abstract XmlScanner doBootstrap() throws IOException, XMLStreamException;

    protected void readXmlDeclaration() throws IOException, XMLStreamException {
        int n = this.getNextAfterWs(false);
        if (n != 118) {
            this.reportUnexpectedChar(n, ERR_XMLDECL_KW_VERSION);
        } else {
            this.mDeclaredXmlVersion = this.readXmlVersion();
            n = this.getWsOrChar(63);
        }
        if (n == 101) {
            this.mFoundEncoding = this.readXmlEncoding();
            n = this.getWsOrChar(63);
        }
        if (n == 115) {
            this.mStandalone = this.readXmlStandalone();
            n = this.getWsOrChar(63);
        }
        if (n != 63) {
            this.reportUnexpectedChar(n, ERR_XMLDECL_END_MARKER);
        }
        if ((n = this.getNext()) != 62) {
            this.reportUnexpectedChar(n, ERR_XMLDECL_END_MARKER);
        }
    }

    private final int readXmlVersion() throws IOException, XMLStreamException {
        int n;
        int n2 = this.checkKeyword("version");
        if (n2 != 0) {
            this.reportUnexpectedChar(n2, "version");
        }
        if ((n = this.readQuotedValue(this.mKeyword, n2 = this.handleEq("version"))) == 3 && this.mKeyword[0] == '1' && this.mKeyword[1] == '.') {
            n2 = this.mKeyword[2];
            if (n2 == 48) {
                return 256;
            }
            if (n2 == 49) {
                return 272;
            }
        }
        String string = n < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (n == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, n) + "'");
        this.reportPseudoAttrProblem("version", string, "1.0", "1.1");
        return 0;
    }

    private final String readXmlEncoding() throws IOException, XMLStreamException {
        int n;
        int n2 = this.checkKeyword("encoding");
        if (n2 != 0) {
            this.reportUnexpectedChar(n2, "encoding");
        }
        if ((n = this.readQuotedValue(this.mKeyword, n2 = this.handleEq("encoding"))) == 0) {
            this.reportPseudoAttrProblem("encoding", null, null, null);
        }
        if (n < 0) {
            return new String(this.mKeyword);
        }
        return new String(this.mKeyword, 0, n);
    }

    private final String readXmlStandalone() throws IOException, XMLStreamException {
        int n;
        int n2 = this.checkKeyword("standalone");
        if (n2 != 0) {
            this.reportUnexpectedChar(n2, "standalone");
        }
        if ((n = this.readQuotedValue(this.mKeyword, n2 = this.handleEq("standalone"))) == 2) {
            if (this.mKeyword[0] == 'n' && this.mKeyword[1] == 'o') {
                return "no";
            }
        } else if (n == 3 && this.mKeyword[0] == 'y' && this.mKeyword[1] == 'e' && this.mKeyword[2] == 's') {
            return "yes";
        }
        String string = n < 0 ? "'" + new String(this.mKeyword) + "[..]'" : (n == 0 ? "<empty>" : "'" + new String(this.mKeyword, 0, n) + "'");
        this.reportPseudoAttrProblem("standalone", string, "yes", "no");
        return string;
    }

    private final int handleEq(String string) throws IOException, XMLStreamException {
        int n = this.getNextAfterWs(false);
        if (n != 61) {
            this.reportUnexpectedChar(n, "; expected '=' after '" + string + "'");
        }
        if ((n = this.getNextAfterWs(false)) != 34 && n != 39) {
            this.reportUnexpectedChar(n, "; expected a quote character enclosing value for '" + string + "'");
        }
        return n;
    }

    private final int getWsOrChar(int n) throws IOException, XMLStreamException {
        int n2 = this.getNext();
        if (n2 == n) {
            return n2;
        }
        if (n2 > 32) {
            this.reportUnexpectedChar(n2, "; expected either '" + (char)n + "' or white space");
        }
        if (n2 == 10 || n2 == 13) {
            this.pushback();
        }
        return this.getNextAfterWs(false);
    }

    protected abstract void pushback();

    protected abstract int getNext() throws IOException, XMLStreamException;

    protected abstract int getNextAfterWs(boolean var1) throws IOException, XMLStreamException;

    protected abstract int checkKeyword(String var1) throws IOException, XMLStreamException;

    protected abstract int readQuotedValue(char[] var1, int var2) throws IOException, XMLStreamException;

    protected abstract Location getLocation();

    protected void reportXmlProblem(String string) throws XMLStreamException {
        throw new WFCException(string, this.getLocation());
    }

    protected void reportNull() throws XMLStreamException {
        this.reportXmlProblem("Illegal null byte/char in input stream");
    }

    protected void reportEof() throws XMLStreamException {
        this.reportXmlProblem("Unexpected end-of-input in xml declaration");
    }

    protected void reportUnexpectedChar(int n, String string) throws XMLStreamException {
        String string2 = Character.isISOControl((char)n) ? "Unexpected character (CTRL-CHAR, code " + n + ")" + string : "Unexpected character '" + (char)n + "' (code " + n + ")" + string;
        this.reportXmlProblem(string2);
    }

    protected final void reportPseudoAttrProblem(String string, String string2, String string3, String string4) throws XMLStreamException {
        String string5;
        String string6 = string5 = string3 == null ? "" : "; expected \"" + string3 + "\" or \"" + string4 + "\"";
        if (string2 == null || string2.length() == 0) {
            this.reportXmlProblem("Missing XML pseudo-attribute '" + string + "' value" + string5);
        }
        this.reportXmlProblem("Invalid XML pseudo-attribute '" + string + "' value " + string2 + string5);
    }
}

