/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.CommonConfig;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.CharBasedPNameTable;
import com.fasterxml.aalto.in.InputCharTypes;
import com.fasterxml.aalto.util.BufferRecycler;
import com.fasterxml.aalto.util.IllegalCharHandler;
import com.fasterxml.aalto.util.UriCanonicalizer;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;

public final class ReaderConfig
extends CommonConfig {
    public static final int DEFAULT_SMALL_BUFFER_LEN = 60;
    public static final int DEFAULT_CHAR_BUFFER_LEN = 4000;
    public static final int STANDALONE_UNKNOWN = 0;
    public static final int STANDALONE_YES = 1;
    public static final int STANDALONE_NO = 2;
    static final int F_NS_AWARE = 1;
    static final int F_COALESCING = 2;
    static final int F_DTD_AWARE = 4;
    static final int F_DTD_VALIDATING = 8;
    static final int F_EXPAND_ENTITIES = 16;
    static final int F_LAZY_PARSING = 256;
    static final int F_INTERN_NAMES = 512;
    static final int F_INTERN_NS_URIS = 1024;
    static final int F_REPORT_CDATA = 2048;
    static final int F_PRESERVE_LOCATION = 4096;
    static final int F_AUTO_CLOSE_INPUT = 8192;
    static final int DEFAULT_FLAGS = 7957;
    private static final HashMap<String, Object> sProperties = new HashMap();
    private final EncodingContext mEncCtxt;
    private final UriCanonicalizer mCanonicalizer;
    private final String mPublicId;
    private final String mSystemId;
    private final String mExtEncoding;
    private String mActualEncoding = null;
    private String mXmlDeclVersion = null;
    private String mXmlDeclEncoding = null;
    private int mXmlDeclStandalone = 0;
    private XMLReporter mReporter;
    private XMLResolver mResolver;
    private IllegalCharHandler illegalCharHandler;
    static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef;
    protected BufferRecycler _currRecycler = null;

    private ReaderConfig(String string, String string2, String string3, EncodingContext encodingContext, int n, int n2, XMLReporter xMLReporter, XMLResolver xMLResolver, UriCanonicalizer uriCanonicalizer) {
        super(n, n2);
        this.mPublicId = string;
        this.mSystemId = string2;
        this.mExtEncoding = string3;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        if (softReference != null) {
            this._currRecycler = softReference.get();
        }
        this.mEncCtxt = encodingContext;
        this._flags = n;
        this._flagMods = n2;
        this.mReporter = xMLReporter;
        this.mResolver = xMLResolver;
        this.mCanonicalizer = uriCanonicalizer;
    }

    public ReaderConfig() {
        this(null, null, null, new EncodingContext(), 7957, 0, null, null, new UriCanonicalizer());
    }

    public void setActualEncoding(String string) {
        this.mActualEncoding = string;
    }

    public void setXmlDeclInfo(int n, String string, String string2) {
        this.mXmlDeclVersion = n == 256 ? "1.0" : (n == 272 ? "1.1" : null);
        this.mXmlDeclEncoding = string;
        this.mXmlDeclStandalone = string2 == "yes" ? 1 : (string2 == "no" ? 2 : 0);
    }

    public final void setXmlVersion(String string) {
        this.mXmlDeclVersion = string;
    }

    public final void setXmlEncoding(String string) {
        this.mXmlDeclEncoding = string;
    }

    public final void setXmlStandalone(Boolean bl) {
        this.mXmlDeclStandalone = bl == null ? 0 : (bl != false ? 1 : 2);
    }

    public void setXMLReporter(XMLReporter xMLReporter) {
        this.mReporter = xMLReporter;
    }

    public void setXMLResolver(XMLResolver xMLResolver) {
        this.mResolver = xMLResolver;
    }

    public void doCoalesceText(boolean bl) {
        this.setFlag(2, bl);
    }

    public void doAutoCloseInput(boolean bl) {
        this.setFlag(8192, bl);
    }

    public void doPreserveLocation(boolean bl) {
        this.setFlag(4096, bl);
    }

    public void doParseLazily(boolean bl) {
        this.setFlag(256, bl);
    }

    public void doReportCData(boolean bl) {
        this.setFlag(2048, bl);
    }

    public ReaderConfig createNonShared(String string, String string2, String string3) {
        return new ReaderConfig(string, string2, string3, this.mEncCtxt, this._flags, this._flagMods, this.mReporter, this.mResolver, this.mCanonicalizer);
    }

    @Override
    public String getExternalEncoding() {
        return this.mExtEncoding;
    }

    @Override
    public String getActualEncoding() {
        return this.mActualEncoding;
    }

    @Override
    public boolean isXml11() {
        return false;
    }

    protected int findPropertyId(String string) {
        Integer n = (Integer)sProperties.get(string);
        return n == null ? -1 : n;
    }

    @Override
    public final Object getProperty(String string, boolean bl) {
        Object object = sProperties.get(string);
        if (object == null) {
            if (sProperties.containsKey(string)) {
                return null;
            }
            return super.getProperty(string, bl);
        }
        if (object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        if (!(object instanceof Integer)) {
            throw new RuntimeException("Internal error: unrecognized property value type: " + object.getClass().getName());
        }
        int n = (Integer)object;
        return this.hasFlag(n);
    }

    @Override
    public boolean setProperty(String string, Object object) {
        Object object2 = sProperties.get(string);
        if (object2 == null) {
            if (sProperties.containsKey(string)) {
                return false;
            }
            return super.setProperty(string, object);
        }
        if (object2 instanceof Boolean) {
            return false;
        }
        if (!(object2 instanceof Integer)) {
            throw new RuntimeException("Internal error");
        }
        int n = (Integer)object2;
        boolean bl = (Boolean)object;
        this.setFlag(n, bl);
        return true;
    }

    @Override
    public boolean isPropertySupported(String string) {
        return sProperties.containsKey(string) || super.isPropertySupported(string);
    }

    public XMLReporter getXMLReporter() {
        return this.mReporter;
    }

    public XMLResolver getXMLResolver() {
        return this.mResolver;
    }

    public boolean willExpandEntities() {
        return this.hasFlag(16);
    }

    public boolean willCoalesceText() {
        return this.hasFlag(2);
    }

    public boolean willSupportNamespaces() {
        return true;
    }

    public boolean willParseLazily() {
        return this.hasFlag(256);
    }

    public boolean willInternNames() {
        return this.hasFlag(512);
    }

    public boolean willInternNsURIs() {
        return this.hasFlag(1024);
    }

    public boolean willReportCData() {
        return this.hasFlag(2048);
    }

    public boolean willPreserveLocation() {
        return this.hasFlag(4096);
    }

    public boolean willAutoCloseInput() {
        return this.hasFlag(8192);
    }

    public boolean hasInternNamesBeenEnabled() {
        return this.hasExplicitFlag(512);
    }

    public boolean hasInternNsURIsBeenEnabled() {
        return this.hasExplicitFlag(1024);
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getXmlDeclVersion() {
        return this.mXmlDeclVersion;
    }

    public String getXmlDeclEncoding() {
        return this.mXmlDeclEncoding;
    }

    public int getXmlDeclStandalone() {
        return this.mXmlDeclStandalone;
    }

    public void configureForXmlConformance() {
    }

    public void configureForConvenience() {
        this.doCoalesceText(true);
        this.doPreserveLocation(true);
    }

    public void configureForSpeed() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
    }

    public void configureForLowMemUsage() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
    }

    public void configureForRoundTripping() {
        this.doCoalesceText(false);
    }

    public String canonicalizeURI(char[] cArray, int n) {
        return this.mCanonicalizer.canonicalizeURI(cArray, n);
    }

    public char[] allocSmallCBuffer(int n) {
        char[] cArray;
        if (this._currRecycler != null && (cArray = this._currRecycler.getSmallCBuffer(n)) != null) {
            return cArray;
        }
        return new char[n];
    }

    public void freeSmallCBuffer(char[] cArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnSmallCBuffer(cArray);
    }

    public char[] allocMediumCBuffer(int n) {
        char[] cArray;
        if (this._currRecycler != null && (cArray = this._currRecycler.getMediumCBuffer(n)) != null) {
            return cArray;
        }
        return new char[n];
    }

    public void freeMediumCBuffer(char[] cArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnMediumCBuffer(cArray);
    }

    public char[] allocFullCBuffer(int n) {
        char[] cArray;
        if (this._currRecycler != null && (cArray = this._currRecycler.getFullCBuffer(n)) != null) {
            return cArray;
        }
        return new char[n];
    }

    public void freeFullCBuffer(char[] cArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullCBuffer(cArray);
    }

    public byte[] allocFullBBuffer(int n) {
        byte[] byArray;
        if (this._currRecycler != null && (byArray = this._currRecycler.getFullBBuffer(n)) != null) {
            return byArray;
        }
        return new byte[n];
    }

    public void freeFullBBuffer(byte[] byArray) {
        if (this._currRecycler == null) {
            this._currRecycler = this.createRecycler();
        }
        this._currRecycler.returnFullBBuffer(byArray);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler bufferRecycler = new BufferRecycler();
        _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        return bufferRecycler;
    }

    public ByteBasedPNameTable getBBSymbols() {
        if (this.mActualEncoding == "UTF-8") {
            return this.mEncCtxt.getUtf8Symbols();
        }
        if (this.mActualEncoding == "ISO-8859-1") {
            return this.mEncCtxt.getLatin1Symbols();
        }
        if (this.mActualEncoding == "US-ASCII") {
            return this.mEncCtxt.getAsciiSymbols();
        }
        throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
    }

    public CharBasedPNameTable getCBSymbols() {
        return this.mEncCtxt.getSymbols();
    }

    public void updateBBSymbols(ByteBasedPNameTable byteBasedPNameTable) {
        if (this.mActualEncoding == "UTF-8") {
            this.mEncCtxt.updateUtf8Symbols(byteBasedPNameTable);
        } else if (this.mActualEncoding == "ISO-8859-1") {
            this.mEncCtxt.updateLatin1Symbols(byteBasedPNameTable);
        } else if (this.mActualEncoding == "US-ASCII") {
            this.mEncCtxt.updateAsciiSymbols(byteBasedPNameTable);
        } else {
            throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
        }
    }

    public void updateCBSymbols(CharBasedPNameTable charBasedPNameTable) {
        this.mEncCtxt.updateSymbols(charBasedPNameTable);
    }

    public XmlCharTypes getCharTypes() {
        if (this.mActualEncoding == "UTF-8") {
            return InputCharTypes.getUtf8CharTypes();
        }
        if (this.mActualEncoding == "ISO-8859-1") {
            return InputCharTypes.getLatin1CharTypes();
        }
        if (this.mActualEncoding == "US-ASCII") {
            return InputCharTypes.getAsciiCharTypes();
        }
        throw new Error("Internal error, unknown encoding '" + this.mActualEncoding + "'");
    }

    public void setIllegalCharHandler(IllegalCharHandler illegalCharHandler) {
        this.illegalCharHandler = illegalCharHandler;
    }

    public IllegalCharHandler getIllegalCharHandler() {
        return this.illegalCharHandler;
    }

    static {
        sProperties.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        sProperties.put("javax.xml.stream.isValidating", new Integer(8));
        sProperties.put("javax.xml.stream.isCoalescing", 2);
        sProperties.put("javax.xml.stream.isReplacingEntityReferences", 16);
        sProperties.put("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        sProperties.put("javax.xml.stream.supportDTD", 4);
        sProperties.put("javax.xml.stream.reporter", null);
        sProperties.put("javax.xml.stream.resolver", null);
        sProperties.put("javax.xml.stream.allocator", null);
        sProperties.put("com.ctc.wstx.lazyParsing", 256);
        sProperties.put("org.codehaus.stax2.internNames", 512);
        sProperties.put("org.codehaus.stax2.internNsUris", 1024);
        sProperties.put("org.codehaus.stax2.closeInputSource", 8192);
        sProperties.put("org.codehaus.stax2.preserveLocation", 4096);
        sProperties.put("org.codehaus.stax2.reportPrologWhitespace", Boolean.FALSE);
        sProperties.put("http://java.sun.com/xml/stream/properties/report-cdata-event", 2048);
        sProperties.put("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
        sProperties.put("org.codehaus.stax2.propDtdOverride", null);
        _recyclerRef = new ThreadLocal();
    }

    static final class EncodingContext {
        ByteBasedPNameTable mUtf8Table;
        ByteBasedPNameTable mLatin1Table;
        ByteBasedPNameTable mAsciiTable;
        CharBasedPNameTable mGeneralTable;

        EncodingContext() {
        }

        public synchronized ByteBasedPNameTable getUtf8Symbols() {
            if (this.mUtf8Table == null) {
                this.mUtf8Table = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mUtf8Table);
        }

        public synchronized void updateUtf8Symbols(ByteBasedPNameTable byteBasedPNameTable) {
            this.mUtf8Table.mergeFromChild(byteBasedPNameTable);
        }

        public synchronized ByteBasedPNameTable getLatin1Symbols() {
            if (this.mLatin1Table == null) {
                this.mLatin1Table = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mLatin1Table);
        }

        public synchronized void updateLatin1Symbols(ByteBasedPNameTable byteBasedPNameTable) {
            this.mLatin1Table.mergeFromChild(byteBasedPNameTable);
        }

        public synchronized ByteBasedPNameTable getAsciiSymbols() {
            if (this.mAsciiTable == null) {
                this.mAsciiTable = new ByteBasedPNameTable(64);
            }
            return new ByteBasedPNameTable(this.mAsciiTable);
        }

        public synchronized void updateAsciiSymbols(ByteBasedPNameTable byteBasedPNameTable) {
            this.mAsciiTable.mergeFromChild(byteBasedPNameTable);
        }

        public synchronized CharBasedPNameTable getSymbols() {
            if (this.mGeneralTable == null) {
                this.mGeneralTable = new CharBasedPNameTable(64);
            }
            return new CharBasedPNameTable(this.mGeneralTable);
        }

        public synchronized void updateSymbols(CharBasedPNameTable charBasedPNameTable) {
            this.mGeneralTable.mergeFromChild(charBasedPNameTable);
        }
    }
}

