/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.out.ByteWName;
import com.fasterxml.aalto.out.ByteXmlWriter;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class Utf8XmlWriter
extends ByteXmlWriter {
    public Utf8XmlWriter(WriterConfig writerConfig, OutputStream outputStream) {
        super(writerConfig, outputStream, OutputCharTypes.getUtf8CharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 0x10FFFF;
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null || n2 == 0) {
            return;
        }
        if (this.mSurrogate != 0) {
            this.outputSurrogates(this.mSurrogate, cArray[n]);
            ++n;
            --n2;
        }
        n2 += n;
        block0: while (n < n2) {
            char c;
            while ((c = cArray[n]) < '\u0080') {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c;
                if (++n < n2) continue;
                break block0;
            }
            if ((c = cArray[n++]) < '\u0800') {
                this.output2ByteChar(c);
            } else {
                n = this.outputMultiByteChar(c, cArray, n, n2);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c;
        }
    }

    @Override
    protected WName doConstructName(String string) throws XMLStreamException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return new ByteWName(string, byArray);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    @Override
    protected WName doConstructName(String string, String string2) throws XMLStreamException {
        try {
            byte[] byArray = (string + ":" + string2).getBytes("UTF-8");
            return new ByteWName(string, string2, byArray);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    @Override
    protected final void outputSurrogates(int n, int n2) throws IOException, XMLStreamException {
        int n3 = this.calcSurrogate(n, n2, " in content");
        if (this._outputPtr + 4 > this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = (byte)(0xF0 | n3 >> 18);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n3 >> 12 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n3 >> 6 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n3 & 0x3F);
    }

    @Override
    protected final void output2ByteChar(int n) throws IOException, XMLStreamException {
        if (this._outputPtr + 2 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xC0 | n >> 6);
        byArray[this._outputPtr++] = (byte)(0x80 | n & 0x3F);
    }

    @Override
    protected final int outputMultiByteChar(int n, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (n >= 55296) {
            if (n <= 57343) {
                if (n2 >= n3) {
                    this.mSurrogate = n;
                } else {
                    this.outputSurrogates(n, cArray[n2]);
                    ++n2;
                }
                return n2;
            }
            if (n >= 65534) {
                this.reportInvalidChar(n);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xE0 | n >> 12);
        byArray[this._outputPtr++] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[this._outputPtr++] = (byte)(0x80 | n & 0x3F);
        return n2;
    }

    @Override
    protected final int outputStrictMultiByteChar(int n, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (n >= 55296) {
            if (n <= 57343) {
                if (n2 >= n3) {
                    this.mSurrogate = n;
                } else {
                    this.outputSurrogates(n, cArray[n2]);
                    ++n2;
                }
                return n2;
            }
            if (n >= 65534) {
                this.reportInvalidChar(n);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xE0 | n >> 12);
        byArray[this._outputPtr++] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[this._outputPtr++] = (byte)(0x80 | n & 0x3F);
        return n2;
    }
}

