/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.sax;

import com.fasterxml.aalto.sax.SAXFeature;
import com.fasterxml.aalto.sax.SAXParserImpl;
import com.fasterxml.aalto.sax.SAXUtil;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    final InputFactoryImpl mStaxFactory = new InputFactoryImpl();

    public static SAXParserFactory newInstance() {
        return new SAXParserFactoryImpl();
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature != null) {
            Boolean bl = SAXUtil.getFixedStdFeatureValue(sAXFeature);
            if (bl != null) {
                return bl;
            }
            switch (sAXFeature) {
                case IS_STANDALONE: {
                    return true;
                }
            }
        }
        SAXUtil.reportUnknownFeature(string);
        return false;
    }

    @Override
    public SAXParser newSAXParser() {
        return new SAXParserImpl(this.mStaxFactory);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature != null) {
            boolean bl2;
            switch (sAXFeature) {
                case EXTERNAL_GENERAL_ENTITIES: {
                    bl2 = !bl;
                    break;
                }
                case EXTERNAL_PARAMETER_ENTITIES: {
                    bl2 = !bl;
                    break;
                }
                case IS_STANDALONE: {
                    bl2 = true;
                    break;
                }
                case LEXICAL_HANDLER_PARAMETER_ENTITIES: {
                    bl2 = true;
                    break;
                }
                case NAMESPACES: {
                    bl2 = bl;
                    break;
                }
                case NAMESPACE_PREFIXES: {
                    bl2 = !bl;
                    break;
                }
                case RESOLVE_DTD_URIS: {
                    bl2 = true;
                    break;
                }
                case STRING_INTERNING: {
                    bl2 = true;
                    break;
                }
                case UNICODE_NORMALIZATION_CHECKING: {
                    bl2 = false;
                    break;
                }
                case USE_ATTRIBUTES2: 
                case USE_LOCATOR2: 
                case USE_ENTITY_RESOLVER2: {
                    bl2 = true;
                    break;
                }
                case VALIDATION: {
                    bl2 = !bl;
                    break;
                }
                case XMLNS_URIS: {
                    bl2 = true;
                    break;
                }
                case XML_1_1: {
                    bl2 = !bl;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (!bl2) {
                throw new SAXNotSupportedException("Setting std feature " + (Object)((Object)sAXFeature) + " to " + bl + " not supported");
            }
            return;
        }
        SAXUtil.reportUnknownFeature(string);
    }

    @Override
    public void setNamespaceAware(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("Non-namespace-aware mode not implemented");
        }
        super.setNamespaceAware(bl);
    }

    @Override
    public void setValidating(boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Validating mode not implemented");
        }
        super.setValidating(bl);
    }
}

