/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TestEventReader {
    final XMLInputFactory mFactory;

    public TestEventReader() {
        XMLInputFactory xMLInputFactory;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.fasterxml.aalto.stax.InputFactoryImpl");
        this.mFactory = xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        System.out.println("Factory instance: " + xMLInputFactory.getClass());
        System.out.println("  coalescing: " + xMLInputFactory.getProperty("javax.xml.stream.isCoalescing"));
    }

    public void test(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... " + this.getClass().getName() + " [file]");
            System.exit(1);
        }
        String string = stringArray[0];
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        XMLEventReader xMLEventReader = this.mFactory.createXMLEventReader(file.toURL().toString(), fileReader);
        PrintWriter printWriter = new PrintWriter(System.out);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            if (xMLEvent2.isStartElement()) {
                xMLEvent = (StartElement)xMLEvent2;
                QName qName = xMLEvent.getName();
                System.err.println("QName = [" + qName + ", ns='" + qName.getNamespaceURI() + "']");
                Iterator<Namespace> iterator = xMLEvent.getNamespaces();
                int n = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
            } else if (xMLEvent2.isCharacters()) {
                xMLEvent = xMLEvent2.asCharacters();
                int n = xMLEvent.getData().length();
                ((Writer)printWriter).write("[CHARACTERS(" + n + "), ws: " + xMLEvent.isWhiteSpace() + ", iws: " + xMLEvent.isIgnorableWhiteSpace() + "]");
            } else if (xMLEvent2 instanceof EntityReference) {
                xMLEvent = (EntityReference)xMLEvent2;
                ((Writer)printWriter).write("[ENTITY-REF '" + xMLEvent.getName() + "']");
            }
            xMLEvent2.writeAsEncodedUnicode(printWriter);
        }
        ((Writer)printWriter).flush();
    }

    public static void main(String[] stringArray) throws Exception {
        new TestEventReader().test(stringArray);
    }
}

