/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.PName;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public final class TestNameHashing {
    ByteBasedPNameTable mTable = null;
    int mCharCount = 0;

    protected TestNameHashing() {
    }

    protected void test(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java " + this.getClass().getName() + " <file>");
            System.exit(1);
        }
        this.test2(stringArray);
        int n = this.mTable.size();
        double d = (double)this.mCharCount / (double)n;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        System.out.println("DEBUG: Free1: " + l + ", total: " + runtime.totalMemory() + ", max: " + runtime.maxMemory());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        System.gc();
        Thread.yield();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        System.gc();
        Thread.yield();
        l = runtime.freeMemory();
        System.out.println("DEBUG: Free2: " + l + ", total: " + runtime.totalMemory() + ", max: " + runtime.maxMemory());
        this.mTable.nuke();
        this.mTable = null;
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        System.gc();
        Thread.yield();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        System.gc();
        Thread.yield();
        long l2 = runtime.freeMemory();
        System.out.println("DEBUG: Free3: " + l2 + ", total: " + runtime.totalMemory() + ", max: " + runtime.maxMemory());
        long l3 = l2 - l;
        double d2 = (double)l3 / (double)n;
        System.out.println("Memory used by table: " + l3 + " -> " + d2 + " bytes per word (" + d + " chars/word)");
    }

    protected void test2(String[] stringArray) throws Exception {
        String string;
        this.mTable = new ByteBasedPNameTable(64);
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        System.out.println("Ok, starting to read in names: ");
        this.mCharCount = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (this.tryToFind(this.mTable, string) == null) {
                this.addSymbol(this.mTable, string);
                this.mCharCount += string.length();
                continue;
            }
            System.out.print('.');
        }
        System.out.println(".");
        System.out.println("Done! Table: " + this.mTable.toString());
        ((InputStream)fileInputStream).close();
    }

    PName tryToFind(ByteBasedPNameTable byteBasedPNameTable, String string) {
        int[] nArray = this.calcQuads(string);
        int n = ByteBasedPNameTable.calcHash(nArray, nArray.length);
        if (nArray.length < 3) {
            return byteBasedPNameTable.findSymbol(n, nArray[0], nArray.length < 2 ? 0 : nArray[1]);
        }
        return byteBasedPNameTable.findSymbol(n, nArray, nArray.length);
    }

    PName addSymbol(ByteBasedPNameTable byteBasedPNameTable, String string) {
        int[] nArray = this.calcQuads(string);
        int n = string.indexOf(58);
        int n2 = ByteBasedPNameTable.calcHash(nArray, nArray.length);
        if (nArray.length < 3) {
            return byteBasedPNameTable.addSymbol(n2, string, n, nArray[0], nArray.length < 2 ? 0 : nArray[1]);
        }
        return byteBasedPNameTable.addSymbol(n2, string, n, nArray, nArray.length);
    }

    int[] calcQuads(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Internal error: " + unsupportedEncodingException);
        }
        int n = byArray.length;
        int[] nArray = new int[(n + 3) / 4];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (++i < n) {
                n2 = n2 << 8 | byArray[i] & 0xFF;
                if (++i < n) {
                    n2 = n2 << 8 | byArray[i] & 0xFF;
                    if (++i < n) {
                        n2 = n2 << 8 | byArray[i] & 0xFF;
                    }
                }
            }
            nArray[i / 4] = n2;
        }
        return nArray;
    }

    public static void main(String[] stringArray) throws Exception {
        new TestNameHashing().test(stringArray);
    }
}

